/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.job.BChangeDeviceIdJob;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.job.BTimeSynchJob;
import com.tridium.bacnet.job.BWhoHasJob;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BBacnetLearnTable;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BacnetDeviceLearn
extends MgrLearn
implements AsnConst {
    static BImage bacnetDeviceIcon = BImage.make((String)"module://icons/x16/device.png");
    BDiscoveryDevice[] lastLearn;
    BBacnetDeviceManager mgr;
    protected boolean jobComplete;
    static final Lexicon lex = UiLexicon.makeUiLexicon(BacnetDeviceLearn.class);
    static final String lexName = lex.getText("deviceManager.name");
    static final String lexDeviceId = lex.getText("deviceManager.deviceId");
    static final String lexNet = lex.getText("deviceManager.network");
    static final String lexAddr = lex.getText("deviceManager.mac");
    static final String lexVendorName = lex.getText("deviceManager.vendorName");
    static final String lexModelName = lex.getText("deviceManager.modelName");
    static final String lexMaxApdu = lex.getText("deviceManager.maxApdu");
    static final String lexSeg = lex.getText("deviceManager.segmentation");
    static final String lexVendorId = lex.getText("deviceManager.vId");
    static final String lexSize = lex.getText("deviceManager.size");
    static final String lexCset = lex.getText("deviceManager.charSet");
    static final String lexUnknown = lex.getText("deviceManager.unknown");
    static final String lexFwRev = lex.getText("deviceManager.fwRev");
    static final String lexAppSwVer = lex.getText("deviceManager.appSwVer");
    static final String lexDup = lex.getText("deviceManager.dup");
    private static final int COV_BIT_INDEX = (Integer)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_INDEX_MAP.get("subscribeCov");
    private static final int COVP_PROTOCOL_REVISION = 2;
    private static final int COVP_BIT_INDEX = (Integer)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_INDEX_MAP.get("subscribeCovProperty");
    MgrColumn dcolName = new MgrColumn.Prop(lexName, BDiscoveryDevice.deviceName, 0);
    MgrColumn dcolObjectId = new MgrColumn.Prop(lexDeviceId, BDiscoveryDevice.objectId, 0);
    MgrColumn dcolNetwork = new NetworkCol(lexNet);
    MgrColumn dcolAddr = new AddrCol(lexAddr);
    MgrColumn dcolVendorName = new MgrColumn.Prop(lexVendorName, BDiscoveryDevice.vendorName, 0);
    MgrColumn dcolModelName = new MgrColumn.Prop(lexModelName, BDiscoveryDevice.modelName, 0);
    MgrColumn dcolMaxApdu = new MgrColumn.Prop(lexMaxApdu, BDiscoveryDevice.maxApduLengthAccepted, 2);
    MgrColumn dcolSeg = new MgrColumn.Prop(lexSeg, BDiscoveryDevice.segmentationSupported, 2);
    MgrColumn dcolVendorId = new MgrColumn.Prop(lexVendorId, BDiscoveryDevice.vendorId, 2);
    MgrColumn dcolSize = new SizeCol(lexSize);
    MgrColumn dcolCharset = new MgrColumn.Prop(lexCset, BDiscoveryDevice.encoding, 2);
    MgrColumn dcolFwRev = new MgrColumn.Prop(lexFwRev, BDiscoveryDevice.firmwareRevision, 2);
    MgrColumn dcolAppSwVer = new MgrColumn.Prop(lexAppSwVer, BDiscoveryDevice.applicationSoftwareVersion, 2);
    MgrColumn dcolDup = new MgrColumn.Prop(lexDup, BDiscoveryDevice.duplicate, 2);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolObjectId, this.dcolNetwork, this.dcolAddr, this.dcolDup, this.dcolVendorName, this.dcolModelName, this.dcolMaxApdu, this.dcolSeg, this.dcolVendorId, this.dcolSize, this.dcolCharset, this.dcolFwRev, this.dcolAppSwVer};

    public BacnetDeviceLearn(BBacnetDeviceManager mgr) {
        super((BAbstractManager)mgr);
        this.mgr = mgr;
    }

    protected final BWidget makeJobBar() {
        return null;
    }

    protected BDiscoveryDevice disc(Object o) {
        return (BDiscoveryDevice)o;
    }

    protected MgrColumn[] makeColumns() {
        return this.dcols;
    }

    public boolean isMatchable(Object dis, BComponent db) {
        return true;
    }

    public boolean isExisting(Object dis, BComponent comp) {
        if (!comp.getType().is(BBacnetDevice.TYPE)) {
            return false;
        }
        return ((BBacnetDevice)comp).getObjectId().equals((Object)this.disc(dis).getObjectId());
    }

    public BImage getIcon(Object dis) {
        return bacnetDeviceIcon;
    }

    public MgrTypeInfo[] toTypes(Object dis) {
        return this.mgr.toTypes();
    }

    public void toRow(Object dis, MgrEditRow row) throws Exception {
        BDiscoveryDevice device = (BDiscoveryDevice)dis;
        BBacnetAddress address = device.getAddress();
        BBacnetBitString servicesSupported = device.getServicesSupported();
        row.setDefaultName(SlotPath.escape((String)device.getDeviceName()));
        row.setCell(this.mgr.bacModel().colOid, (BValue)device.getObjectId());
        row.setCell(this.mgr.bacModel().colNetNum, (BValue)BInteger.make((int)address.getNetworkNumber()));
        String addressString = BBacnetAddress.bytesToString((int)address.getAddressType(), (byte[])address.getMacAddress().getBytes());
        row.setCell(this.mgr.bacModel().colMacAddr, (BValue)BString.make((String)addressString));
        boolean cov = servicesSupported.length() > COV_BIT_INDEX && servicesSupported.getBit(COV_BIT_INDEX);
        row.setCell(this.mgr.bacModel().colUseCov, (BValue)BBoolean.make((boolean)cov));
        boolean covp = device.getProtocolRevision() >= 2 && servicesSupported.length() > COVP_BIT_INDEX && servicesSupported.getBit(COVP_BIT_INDEX);
        row.setCell(this.mgr.bacModel().colUseCovProperty, (BValue)BBoolean.make((boolean)covp));
    }

    public void jobComplete(BJob job) {
        Type jobType = job.getType();
        if (jobType == BBacnetDiscoverDevicesJob.TYPE) {
            job.lease(1);
            this.lastLearn = (BDiscoveryDevice[])job.getChildren(BDiscoveryDevice.class);
            this.updateRoots(this.lastLearn);
        } else if (jobType == BTimeSynchJob.TYPE) {
            String msg = null;
            if (job.getJobState() == BJobState.success) {
                msg = lex.getText("timeSynch.success");
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                msg = MessageFormat.format(lex.getText("timeSynch.fail"), cause);
            }
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("timeSynch.title"), (Object)msg);
        } else if (jobType == BWhoHasJob.TYPE) {
            job.lease(1);
            BTextEditorPane pane = new BTextEditorPane("", 20, 80, false);
            BString[] iHaves = (BString[])job.getChildren(BString.class);
            StringBuilder sb = new StringBuilder("I-Have Responses for\n");
            sb.append(iHaves[0].getString());
            sb.append("\n\n");
            for (int i = 1; i < iHaves.length; ++i) {
                sb.append(IHaveRequest.fromJob((String)iHaves[i].getString()));
            }
            pane.setText(sb.toString());
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("whoHas.label"), (Object)pane);
        } else if (jobType == BChangeDeviceIdJob.TYPE) {
            String msg = null;
            if (job.getJobState() == BJobState.success) {
                msg = lex.getText("changeId.success");
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                msg = MessageFormat.format(lex.getText("changeId.fail"), cause);
            }
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("changeId.title"), (Object)msg);
        }
    }

    public BDiscoveryDevice[] getLastLearn() {
        return this.lastLearn;
    }

    protected BLearnTable makeTable() {
        return new BBacnetLearnTable(this);
    }

    public final int getColumnIndex(MgrColumn col) {
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (col != cols[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("MgrColumn not found in getColumns()");
    }

    class SizeCol
    extends MgrColumn {
        public SizeCol(String displayName) {
            super(displayName);
        }

        public Object get(Object row) {
            return BacnetDeviceLearn.this.disc(row).getListSize() > 0 ? String.valueOf(BacnetDeviceLearn.this.disc(row).getListSize()) : lexUnknown;
        }
    }

    class AddrCol
    extends MgrColumn {
        public AddrCol(String displayName) {
            super(displayName);
        }

        public Object get(Object row) {
            BBacnetStack stack = (BBacnetStack)((BBacnetDeviceManager)this.getManager()).getNetwork().getBacnetComm();
            BDiscoveryDevice dev = BacnetDeviceLearn.this.disc(row);
            BNetworkPort port = stack.getNetwork().getPortByNetwork(dev.getAddress().getNetworkNumber());
            byte[] mac = dev.getAddress().getMacAddress().getBytes();
            int macType = 0;
            if (port != null) {
                BBacnetLinkLayer link = port.getLink();
                if (link instanceof BBacnetIpLinkLayer) {
                    macType = 2;
                } else if (link instanceof BBacnetEthernetLinkLayer) {
                    macType = 1;
                } else if (link instanceof BBacnetMstpLinkLayer) {
                    macType = 3;
                } else if (link instanceof BScLinkLayer) {
                    macType = 4;
                }
            }
            return BBacnetAddress.bytesToString((int)macType, (byte[])mac);
        }
    }

    class NetworkCol
    extends MgrColumn {
        public NetworkCol(String displayName) {
            super(displayName);
        }

        public Object get(Object row) {
            return String.valueOf(BacnetDeviceLearn.this.disc(row).getAddress().getNetworkNumber());
        }
    }
}

