/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.config;

import com.tridium.bacnet.job.BBacnetDiscoverConfigJob;
import com.tridium.bacnet.job.BDiscoveryConfig;
import com.tridium.bacnet.ui.col.PropName;
import com.tridium.driver.util.StringUtil;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetConfigFolder;
import javax.baja.bacnet.config.BIBacnetConfigFolder;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetConfigDeviceExt", "bacnet:BacnetConfigFolder"}, requiredPermissions="W")})
public class BBacnetConfigManager
extends BFolderManager
implements BacnetConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetConfigManager.class);
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetConfigManager.class);
    static BImage bacnetObjectIcon = BImage.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lex.getText("configManager.value"), 0);
    MgrColumn colObjId = new MgrColumn.Prop(lex.getText("learn.objectId"), BBacnetObject.objectId, 1);
    MgrColumn colOName = new MgrColumn.Prop(lex.getText("configManager.objectName"), BBacnetObject.objectName, 0);
    MgrColumn colPollFreq = new MgrColumn.Prop(BBacnetObject.pollFrequency, 3);
    MgrColumn colDesc = new PropName(lex.getText("configManager.description"), "description", 0);
    protected MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colObjId, this.colOName, this.colDesc, this.colPollFreq};
    MgrColumn dcolName = new MgrColumn.Prop(lex.getText("configManager.objectName"), BDiscoveryConfig.objectName, 0);
    MgrColumn dcolObjectId = new MgrColumn.Prop(lex.getText("learn.objectId"), BDiscoveryConfig.objectId, 0);
    MgrColumn dcolValue = new MgrColumn.Prop(lex.getText("configManager.value"), BDiscoveryConfig.value, 0);
    MgrColumn dcolDesc = new MgrColumn.Prop(lex.getText("configManager.description"), BDiscoveryConfig.description, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolObjectId, this.dcolValue, this.dcolDesc};
    private BBacnetConfigDeviceExt deviceExt;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void doLoadValue(BObject obj, Context cx) {
        this.deviceExt = ((BIBacnetConfigFolder)obj).getConfig();
        super.doLoadValue(obj, cx);
    }

    public BBacnetConfigDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = ((BIBacnetConfigFolder)this.getCurrentValue()).getConfig();
        }
        return this.deviceExt;
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    static class State
    extends FolderState {
        Object[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetConfigManager mgr = (BBacnetConfigManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetConfigManager mgr = (BBacnetConfigManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateRoots(this.lastLearn);
            }
        }
    }

    public class Controller
    extends FolderController {
        public Controller(BBacnetConfigManager manager) {
            super((BFolderManager)manager);
            this.cancel.setFlags(7);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BBacnetConfigManager.this.getDeviceExt().submitConfigDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BBacnetConfigManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }
    }

    class Learn
    extends MgrLearn {
        BDiscoveryConfig[] lastLearn;

        Learn(BBacnetConfigManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected BDiscoveryConfig lr(Object o) {
            return (BDiscoveryConfig)o;
        }

        BBacnetDiscoverConfigJob getDiscoveryJob() {
            return (BBacnetDiscoverConfigJob)this.getJob();
        }

        protected MgrColumn[] makeColumns() {
            return BBacnetConfigManager.this.dcols;
        }

        public void jobComplete(BJob job) {
            job.lease(1);
            this.lastLearn = (BDiscoveryConfig[])job.getChildren(BDiscoveryConfig.class);
            this.updateRoots(this.lastLearn);
        }

        public BImage getIcon(Object dis) {
            return bacnetObjectIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            BDiscoveryConfig lr = this.lr(dis);
            String[] infos = StringUtil.getStringArray((String)lr.getTypeSpecs(), (String)";");
            TypeInfo[] ti = new TypeInfo[infos.length];
            for (int i = 0; i < ti.length; ++i) {
                ti[i] = BTypeSpec.make((String)infos[i]).getTypeInfo();
            }
            return MgrTypeInfo.makeArray((TypeInfo[])ti);
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BDiscoveryConfig lr = this.lr(dis);
            return comp.getType().is(BBacnetObject.TYPE) && ((BBacnetObject)comp).getObjectId().equals((Object)lr.getObjectId());
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BDiscoveryConfig lr = this.lr(dis);
            row.setName(SlotPath.escape((String)lr.getObjectName()));
            row.setCell(BBacnetConfigManager.this.colObjId, (BValue)lr.getObjectId());
        }
    }

    protected class Model
    extends FolderModel {
        protected Model(BBacnetConfigManager mgr) {
            super((BFolderManager)mgr);
        }

        public Type getFolderType() {
            return BBacnetConfigFolder.TYPE;
        }

        protected MgrColumn[] makeColumns() {
            return BBacnetConfigManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            Array ret = new Array(TypeInfo.class);
            BString blist = BBacnetConfigManager.this.getDeviceExt().getConfigTypes();
            String[] infos = StringUtil.getStringArray((String)blist.getString(), (String)";");
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].equals("bacnet:BacnetDeviceObject")) continue;
                ret.add((Object)BTypeSpec.make((String)infos[i]).getTypeInfo());
            }
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])ret.trim()));
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BBacnetObject obj = (BBacnetObject)type.newInstance();
            return obj;
        }
    }
}

