/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneReq;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.InputStream;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class MilestoneEventRefreshReq
extends MilestoneReq {
    protected BVideoEvent[] milestoneEvents;
    protected MilestoneCameraConnectReq cameraConnectReq;
    protected long earlierTime = -1L;
    protected long laterTime = -1L;
    protected long dbEarliestTime = -1L;
    public static final long ONE_HOUR = 3600000L;
    protected Array<BVideoEvent> alarmsSoFar = new Array(BVideoEvent.class);
    protected BRetrieveActionParam retrieveActionParam;

    public void processReceiveEvents(InputStream in) throws Exception {
        int numEventsToReturn = this.alarmsSoFar.size() > 20 ? 20 : this.alarmsSoFar.size();
        BVideoEvent[] retVal = new BVideoEvent[numEventsToReturn];
        for (int i = 0; i < numEventsToReturn; ++i) {
            retVal[i] = (BVideoEvent)this.alarmsSoFar.get(i);
        }
    }

    public boolean isResponse() {
        return false;
    }

    public Object getTag() {
        return "EventRefresh";
    }

    public void fromInputStream(InputStream in) throws Exception {
        long startTime = MilestoneEventRefreshReq.getEarliestTime(in);
        long stopTime = MilestoneEventRefreshReq.getLatestTime(in);
        System.out.println("Earliest in db = " + BAbsTime.make((long)startTime));
        System.out.println("Latest in db = " + BAbsTime.make((long)stopTime));
        this.alarmsSoFar.addAll((Object[])MilestoneEventRefreshReq.getEventsFor(in));
        if (this.alarmsSoFar.size() >= 20 || this.getRetrieveActionParam().getNumEvents() < 0 && this.earlierTime < startTime || this.getRetrieveActionParam().getNumEvents() > 0 && this.laterTime > stopTime) {
            this.processReceiveEvents(in);
        }
    }

    public byte[] toByteArray() {
        this.laterTime = this.laterTime == -1L ? (this.getRetrieveActionParam().getNumEvents() < 0 ? this.getRetrieveActionParam().getTimeIndex().getMillis() : this.getRetrieveActionParam().getTimeIndex().getMillis() + 3600000L) : (this.getRetrieveActionParam().getNumEvents() < 0 ? (this.laterTime -= 3600000L) : (this.laterTime += 3600000L));
        this.earlierTime = this.laterTime - 3600000L;
        System.out.println("earlierTime = " + BAbsTime.make((long)this.earlierTime));
        System.out.println("laterTime   = " + BAbsTime.make((long)this.laterTime));
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + BMilestoneCamera.getNextVideoRequestId() + "</requestid><methodname>alarms</methodname><starttime>" + this.earlierTime + "</starttime><stoptime>" + this.laterTime + "</stoptime></methodcall>\r\n\r\n").getBytes();
    }

    public static long getLatestTime(InputStream in) throws Exception {
        XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(in);
        String methodName = MilestoneReqUtil.getText(methodResponse, "methodname");
        if (methodName.length() > 0) {
            if ("alarms".equals(methodName)) {
                XElem dbLimitElem = MilestoneReqUtil.getElem(methodResponse, "dblimit");
                try {
                    return dbLimitElem.getl("endTime");
                }
                catch (XException xe) {
                    throw new Exception(xe);
                }
            }
            throw new Exception("<methodname>...</methodname> text = " + methodName + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public static long getEarliestTime(InputStream in) throws Exception {
        XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(in);
        String methodName = MilestoneReqUtil.getText(methodResponse, "methodname");
        if (methodName.length() > 0) {
            if ("alarms".equals(methodName)) {
                XElem dbLimitElem = MilestoneReqUtil.getElem(methodResponse, "dblimit");
                try {
                    return dbLimitElem.getl("startTime");
                }
                catch (XException xe) {
                    throw new Exception(xe);
                }
            }
            throw new Exception("<methodname>...</methodname> text = " + methodName + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public static BVideoEvent[] getEventsFor(InputStream in) throws Exception {
        XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(in);
        String methodName = MilestoneReqUtil.getText(methodResponse, "methodname");
        if (methodName.length() > 0) {
            if ("alarms".equals(methodName)) {
                XElem alarmsElem = MilestoneReqUtil.getElem(methodResponse, "alarms");
                XElem[] alarmElem = alarmsElem.elems("alarm");
                if (alarmElem == null || alarmElem.length == 0) {
                    return new BVideoEvent[0];
                }
                BVideoEvent[] milestoneEvents = new BVideoEvent[alarmElem.length];
                for (int i = 0; i < alarmElem.length; ++i) {
                    milestoneEvents[i] = BVideoEvent.makeOffNormalEvent();
                    milestoneEvents[i].setDescription(BMilestoneEventPointId.LEX.getText("MilestoneRecording"));
                    milestoneEvents[i].setEventType(BVideoEventTypesEnum.customEvent);
                    try {
                        long startTime = alarmElem[i].getl("startTime");
                        long alarmTime = alarmElem[i].getl("alarmTime");
                        long endTime = alarmElem[i].getl("endTime");
                        milestoneEvents[i].setTimestamp(BAbsTime.make((long)startTime));
                        milestoneEvents[i].setMetaData(BFacets.make((String)"milestoneStartTime", (BIDataValue)BLong.make((long)startTime), (String)"milestoneAlarmTime", (BIDataValue)BLong.make((long)alarmTime), (String)"milestoneEndTime", (BIDataValue)BLong.make((long)endTime)));
                        continue;
                    }
                    catch (XException xe) {
                        xe.printStackTrace();
                    }
                }
                return milestoneEvents;
            }
            throw new Exception("<methodname>...</methodname> text = " + methodName + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public BVideoEvent[] getVideoEvents() {
        return this.milestoneEvents;
    }

    public byte[] getBytes() {
        return this.toByteArray();
    }

    public boolean isComplete() {
        return false;
    }

    public BRetrieveActionParam getRetrieveActionParam() {
        return this.retrieveActionParam;
    }

    public void setRetrieveActionParam(BRetrieveActionParam retrieveActionParam) {
        this.retrieveActionParam = retrieveActionParam;
    }
}

