/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.event;

import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.util.StringTokenizer;
import javax.baja.sys.BAbsTime;

public class MilestoneEvent {
    String relativeId;
    String cam;
    String alm;
    String julian;
    String offset;
    String file;
    String ondisk;
    String index;
    String duration;
    String pre_alarm;
    String archive;

    public MilestoneEvent(String eventLine) {
        StringTokenizer tokenizer = new StringTokenizer(eventLine, ",");
        this.relativeId = tokenizer.nextToken().trim();
        this.cam = tokenizer.nextToken().trim();
        this.alm = tokenizer.nextToken().trim();
        this.julian = tokenizer.nextToken().trim();
        this.offset = tokenizer.nextToken().trim();
        this.file = tokenizer.nextToken().trim();
        this.ondisk = tokenizer.nextToken().trim();
        this.index = tokenizer.nextToken().trim();
        this.duration = tokenizer.nextToken().trim();
        this.pre_alarm = tokenizer.nextToken().trim();
        this.archive = tokenizer.nextToken().trim();
    }

    public String toString() {
        return "DmEvent:> cam=" + this.cam + " julian=" + this.julian + " alm=" + this.alm;
    }

    public BVideoEvent getVideoEvent() {
        BVideoEvent videoEventI = new BVideoEvent();
        videoEventI.setEventType(this.getEventType());
        videoEventI.setDescription(this.getEventDescription());
        videoEventI.setTimestamp(BAbsTime.make((long)this.getEventTimeStamp()));
        videoEventI.setIsNormal(false);
        if ("No matching records".equalsIgnoreCase(videoEventI.getDescription())) {
            return null;
        }
        return videoEventI;
    }

    protected long getEventTimeStamp() {
        String eventTimeStampString = this.julian;
        return Long.parseLong(eventTimeStampString) * 1000L;
    }

    protected BVideoEventTypesEnum getEventType() {
        String eventDescription = this.getEventDescription();
        if (eventDescription.startsWith("VMD")) {
            return BVideoEventTypesEnum.motionStarted;
        }
        return BVideoEventTypesEnum.fault;
    }

    protected String getEventDescription() {
        String evtDsc = this.alm;
        if (evtDsc.startsWith("\"")) {
            evtDsc = evtDsc.substring(1);
        }
        if (evtDsc.endsWith("\"")) {
            evtDsc = evtDsc.substring(0, evtDsc.length() - 1);
        }
        return evtDsc;
    }
}

