/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTime;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.BFidIOPointTypeEntry;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.FidIOPointTypes;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class CcnRspFidUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int[] GLOBAL_TABLE = new int[]{1280};
    public static int[] CHANNEL_IO_TABLE = new int[]{1281};
    public static int[] SETPOINT_SCHEDULE_TABLE = new int[]{1284};
    public static int[] TIME_SCHEDULE_TABLE = new int[]{1283};
    public static int[] HOLIDAY_TABLE = new int[]{1285};

    public static byte getForceLevel(CcnResponseMessage rsp, int ptIndex) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), GLOBAL_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        int retVal = 0;
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int forceFlag = buf[3 + ptIndex * 3] & 0xFF;
            if (forceFlag == 0) {
                retVal = 0;
            } else if ((forceFlag & 1) != 0) {
                retVal = 4;
            } else if ((forceFlag & 0x80) != 0) {
                retVal = 8;
            } else if ((forceFlag & 4) != 0) {
                retVal = 10;
            } else if ((forceFlag & 0x10) != 0) {
                retVal = 7;
            } else if ((forceFlag & 2) != 0) {
                retVal = 3;
            } else if ((forceFlag & 8) != 0) {
                retVal = 5;
            } else if ((forceFlag & 0x20) != 0) {
                retVal = 6;
            } else if ((forceFlag & 0x40) != 0) {
                retVal = 9;
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getForceLevel");
        }
        return (byte)retVal;
    }

    public static String getValue(CcnResponseMessage rsp, int ptIndex, String euc, int displayDigits) throws CcnException {
        float fVal = 0.0f;
        CcnRspFidUtil.checkTableType(rsp.getTableType(), GLOBAL_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int intComp = buf[3 + ptIndex * 3 + 1] & 0xFF;
            int fracComp = buf[3 + ptIndex * 3 + 2] >> 4 & 0xF;
            if (euc == null || euc.length() <= 1) {
                return Integer.toString(intComp);
            }
            if (euc.equals("TTEM")) {
                fVal = CcnRspFidUtil.getConversion_TTEM(intComp, fracComp);
            } else if (euc.equals("TPER")) {
                fVal = CcnRspFidUtil.getConversion_TPER(intComp);
            } else if (euc.equals("TINC")) {
                fVal = CcnRspFidUtil.getConversion_TINC(intComp, fracComp);
            } else if (euc.equals("TMIL")) {
                fVal = CcnRspFidUtil.getConversion_TMIL(intComp, fracComp);
            } else if (euc.equals("TDTM")) {
                fVal = CcnRspFidUtil.getConversion_TDTM(intComp, fracComp);
            } else if (euc.equals("TTMP")) {
                fVal = CcnRspFidUtil.getConversion_TTMP(intComp, fracComp);
            } else {
                if (euc.equals("TNUM")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TNUM(intComp));
                }
                if (euc.equals("TVOL")) {
                    fVal = CcnRspFidUtil.getConversion_TVOL(intComp, fracComp);
                } else if (euc.equals("TPSI")) {
                    fVal = CcnRspFidUtil.getConversion_TPSI(intComp, fracComp);
                } else if (euc.equals("TENT")) {
                    fVal = CcnRspFidUtil.getConversion_TENT(intComp, fracComp);
                } else if (euc.equals("TCFM")) {
                    fVal = CcnRspFidUtil.getConversion_TCFM(intComp, fracComp);
                } else if (euc.equals("TOFF")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TOFF(intComp));
                }
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getValue");
        }
        NumberFormat nf = NumberFormat.getInstance();
        int fracDigits = displayDigits & 0xF;
        nf.setMaximumFractionDigits(fracDigits);
        nf.setMinimumFractionDigits(fracDigits);
        ((DecimalFormat)nf).setGroupingSize(20);
        return nf.format(fVal);
    }

    public static byte getStatus(CcnResponseMessage rsp, int ptIndex) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), GLOBAL_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        int statVal = 0;
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int statusFlag = buf[3 + ptIndex * 3 + 2] & 0xF;
            if (statusFlag == 0) {
                statVal = 0;
            } else if ((statusFlag & 1) != 0) {
                statVal = 1;
            } else if ((statusFlag & 0x80) != 0) {
                statVal = 2;
            } else if ((statusFlag & 4) != 0) {
                statVal = 3;
            }
        } else {
            throw new CcnException(6488167, "FidTable - Need block 6 to getStatus");
        }
        return (byte)statVal;
    }

    public static String getPointName(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspFidUtil.getSubByteArray(buf, 3, 8));
        }
        throw new CcnException(6488167, "FidTable - Need block 1 to getPointName");
    }

    public static boolean getInSystem(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return (buf[3] & 1) == 1;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getInSystem");
    }

    public static boolean setInSystem(boolean val, byte[] blk) {
        blk[0] = val ? (byte)(blk[0] | 1) : (byte)(blk[0] & 0xFE);
        return true;
    }

    public static byte getSensedPulsed(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return (byte)((buf[3] & 4) >> 2);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getInSystem");
    }

    public static boolean setSensedPulsed(boolean val, byte[] blk) {
        blk[0] = val ? (byte)(blk[0] | 4) : (byte)(blk[0] & 0xFB);
        return true;
    }

    public static byte getDeviceType(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[7];
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getDeviceType");
    }

    public static boolean setDeviceType(byte val, byte[] blk) {
        blk[4] = val;
        return true;
    }

    public static byte getCtrlSensType(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return (byte)CcnRspFidUtil.getConversion_TOFF(buf[8]);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getCtrlSensType");
    }

    public static boolean setCtrlSensType(byte val, byte[] blk) {
        blk[5] = val;
        return true;
    }

    public static int getUnitsIndex(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), CHANNEL_IO_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[40] & 0xFF;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getUnitsIndex");
    }

    public static boolean setUnitsIndex(byte val, byte[] blk) {
        blk[37] = val;
        return true;
    }

    public static int getSetpointType(CcnResponseMessage rsp) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), SETPOINT_SCHEDULE_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[7];
            return CcnRspFidUtil.getConversion_TOFF(intComp);
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static boolean setSetpointType(byte val, byte[] blk) {
        blk[4] = val;
        return true;
    }

    public static float getSetpointValue(CcnResponseMessage rsp, int decision, int ptNum) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), SETPOINT_SCHEDULE_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int intComp = buf[3 + ptNum] & 0xFF;
            if (decision == 1) {
                return CcnRspFidUtil.getConversion_TTEM(intComp, 0);
            }
            if (decision == 2) {
                return CcnRspFidUtil.getConversion_TPER(intComp);
            }
            if (decision == 3) {
                return CcnRspFidUtil.getConversion_TINC(intComp, 0);
            }
            if (decision == 4) {
                return CcnRspFidUtil.getConversion_TMIL(intComp, 0);
            }
            if (decision == 5) {
                return CcnRspFidUtil.getConversion_TCFM(intComp, 0);
            }
            return 0.0f;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static boolean setSetpointValue(String val, byte[] blk, int decision, int ptNum) {
        int intComp = 0;
        try {
            if (decision == 1) {
                intComp = (int)CcnRspFidUtil.getCounts_TTEM(Float.valueOf(val).floatValue());
            } else if (decision == 2) {
                intComp = (int)CcnRspFidUtil.getCounts_TPER(Float.valueOf(val).floatValue());
            } else if (decision == 3) {
                intComp = (int)CcnRspFidUtil.getCounts_TINC(Float.valueOf(val).floatValue());
            } else if (decision == 4) {
                intComp = (int)CcnRspFidUtil.getCounts_TMIL(Float.valueOf(val).floatValue());
            } else if (decision == 5) {
                intComp = (int)CcnRspFidUtil.getCounts_TCFM(Float.valueOf(val).floatValue());
            }
            blk[ptNum + 3] = (byte)(intComp & 0xFF);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getSetpointUnits(int decision) {
        if (decision == 1) {
            return 1;
        }
        if (decision == 2) {
            return 46;
        }
        if (decision == 3) {
            return 4;
        }
        if (decision == 4) {
            return 5;
        }
        if (decision == 5) {
            return 52;
        }
        return 0;
    }

    public static int getSetpointDecision(int units) {
        if (units == 1) {
            return 1;
        }
        if (units == 46) {
            return 2;
        }
        if (units == 4) {
            return 3;
        }
        if (units == 5) {
            return 4;
        }
        if (units == 52) {
            return 5;
        }
        return 0;
    }

    public static String getSetPointDesc(int i) {
        String desc;
        switch (i) {
            case 0: {
                desc = "High value - occupied";
                break;
            }
            case 1: {
                desc = "High value - unoccupied";
                break;
            }
            case 2: {
                desc = "Low value - occupied";
                break;
            }
            case 3: {
                desc = "Low value - unoccupied";
                break;
            }
            default: {
                desc = "";
            }
        }
        return desc;
    }

    public static String getSetPointLoLimit(int i) {
        String limit;
        switch (i) {
            case 1: {
                limit = "-9.0";
                break;
            }
            case 2: {
                limit = "0";
                break;
            }
            case 3: {
                limit = "0.0";
                break;
            }
            case 4: {
                limit = "4.0";
                break;
            }
            case 5: {
                limit = "0.0";
                break;
            }
            default: {
                limit = "0";
            }
        }
        return limit;
    }

    public static String getSetPointHiLimit(int i) {
        String limit;
        switch (i) {
            case 1: {
                limit = "244.0";
                break;
            }
            case 2: {
                limit = "99";
                break;
            }
            case 3: {
                limit = "5.0";
                break;
            }
            case 4: {
                limit = "20.0";
                break;
            }
            case 5: {
                limit = "10.0";
                break;
            }
            default: {
                limit = "0";
            }
        }
        return limit;
    }

    public static String getPeriodOccTime(CcnResponseMessage rsp, int per) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), TIME_SCHEDULE_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[3 + (per - 1) * 3];
            byte fracComp = buf[33 + (per - 1) * 3];
            int minTime = intComp * 15 + fracComp;
            BCcnTime occTime = new BCcnTime(minTime / 60, minTime % 60, 0);
            String temp = occTime.getHour() + ":" + occTime.getMinute();
            if (occTime.getHour() == 0 && occTime.getMinute() == 0 && minTime / 60 == 24) {
                temp = "24" + temp.substring(temp.indexOf(":"));
            } else if (occTime.getHour() < 10) {
                temp = "0" + temp;
            }
            return temp;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static boolean setPeriodOccTime(String val, byte[] blk, int ptNum) {
        if (val != null) {
            try {
                int hh = Integer.valueOf(val.substring(0, val.indexOf(":")));
                int mm = Integer.valueOf(val.substring(val.indexOf(":") + 1));
                int iVal = hh * 60 + mm;
                blk[ptNum + 3] = (byte)(iVal / 15 & 0xFF);
                blk[ptNum + 30 + 3] = (byte)(iVal % 15 & 0xFF);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getPeriodUnoccTime(CcnResponseMessage rsp, int per) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), TIME_SCHEDULE_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[3 + (per - 1) * 3 + 1];
            byte fracComp = buf[33 + (per - 1) * 3 + 1];
            int minTime = intComp * 15 + fracComp;
            BCcnTime unoccTime = new BCcnTime(minTime / 60, minTime % 60, 0);
            String temp = unoccTime.getHour() + ":" + unoccTime.getMinute();
            if (unoccTime.getHour() == 0 && unoccTime.getMinute() == 0 && minTime / 60 == 24) {
                temp = "24" + temp.substring(temp.indexOf(":"));
            } else if (unoccTime.getHour() < 10) {
                temp = "0" + temp;
            }
            return temp;
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static boolean setPeriodUnoccTime(String val, byte[] blk, int ptNum) {
        if (val != null) {
            try {
                int hh = Integer.valueOf(val.substring(0, val.indexOf(":")));
                int mm = Integer.valueOf(val.substring(val.indexOf(":") + 1));
                int iVal = hh * 60 + mm;
                blk[ptNum + 3] = (byte)(iVal / 15 & 0xFF);
                blk[ptNum + 30 + 3] = (byte)(iVal % 15 & 0xFF);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getDaysFlags(CcnResponseMessage rsp, int per) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), TIME_SCHEDULE_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[3 + (per - 1) * 3 + 2];
            int daysFlags = ((intComp & 1) << 7) + ((intComp & 2) << 5) + ((intComp & 4) << 3) + ((intComp & 8) << 1) + ((intComp & 0x10) >> 1) + ((intComp & 0x20) >> 3) + ((intComp & 0x40) >> 5) + ((intComp & 0x80) >> 7);
            String daysFlagsStr = Integer.toBinaryString(daysFlags);
            daysFlagsStr = "00000000" + daysFlagsStr;
            daysFlagsStr = daysFlagsStr.substring(daysFlagsStr.length() - 8, daysFlagsStr.length());
            return daysFlagsStr.toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getSetpointType");
    }

    public static boolean setDaysFlags(String val, byte[] blk, int ptNum) {
        if (val != null) {
            try {
                int intComp = Integer.parseInt(val, 2) & 0xFF;
                int daysFlags = ((intComp & 1) << 7) + ((intComp & 2) << 5) + ((intComp & 4) << 3) + ((intComp & 8) << 1) + ((intComp & 0x10) >> 1) + ((intComp & 0x20) >> 3) + ((intComp & 0x40) >> 5) + ((intComp & 0x80) >> 7);
                blk[ptNum + 3] = (byte)daysFlags;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getHolidayMonth(CcnResponseMessage rsp, int hol) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), HOLIDAY_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[3 + (hol - 1) * 2];
            return Integer.valueOf(intComp).toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getHolidayMonth");
    }

    public static String getHolidayDay(CcnResponseMessage rsp, int hol) throws CcnException {
        CcnRspFidUtil.checkTableType(rsp.getTableType(), HOLIDAY_TABLE);
        int blockNo = CcnRspFidUtil.parseBlockNo(rsp);
        if (blockNo == 2) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte intComp = buf[3 + (hol - 1) * 2 + 1];
            return Integer.valueOf(intComp).toString();
        }
        throw new CcnException(6488167, "FidTable - Need block 2 to getHolidayDay");
    }

    public static boolean setHolidayMonth(String val, byte[] blk, int ptNum) {
        if (val != null) {
            try {
                int iVal = Integer.valueOf(val);
                if (1 <= iVal && iVal <= 12) {
                    blk[ptNum + 3] = (byte)(iVal & 0xFF);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean setHolidayDay(String val, byte[] blk, int ptNum) {
        if (val != null) {
            try {
                int iVal = Integer.valueOf(val);
                if (1 <= iVal && iVal <= 31) {
                    blk[ptNum + 3] = (byte)(iVal & 0xFF);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getPointDesc(int dt, int cst) throws CcnException {
        BFidIOPointTypeEntry currentList = FidIOPointTypes.getListItem(dt, cst);
        if (currentList == null) {
            return " ";
        }
        return currentList.getDescription();
    }

    public static int getPointUnits(int dt, int cst) throws CcnException {
        BFidIOPointTypeEntry currentList = FidIOPointTypes.getListItem(dt, cst);
        if (currentList == null) {
            return 0;
        }
        return currentList.getUnits();
    }

    public static String getEUC(int dt, int cst) throws CcnException {
        BFidIOPointTypeEntry currentList = FidIOPointTypes.getListItem(dt, cst);
        if (currentList == null) {
            return " ";
        }
        return currentList.getEUC();
    }

    public static String getLoLimit(int dt, int cst) throws CcnException {
        BFidIOPointTypeEntry currentList = FidIOPointTypes.getListItem(dt, cst);
        if (currentList == null) {
            return " ";
        }
        return currentList.getLowLim();
    }

    public static String getHiLimit(int dt, int cst) throws CcnException {
        BFidIOPointTypeEntry currentList = FidIOPointTypes.getListItem(dt, cst);
        if (currentList == null) {
            return " ";
        }
        return currentList.getHiLim();
    }

    public static float convertFloatToCounts(float value, String euc) throws CcnException {
        if (euc.equals("TTEM")) {
            return CcnRspFidUtil.getCounts_TTEM(value);
        }
        if (euc.equals("TPER")) {
            return CcnRspFidUtil.getCounts_TPER(value);
        }
        if (euc.equals("TINC")) {
            return CcnRspFidUtil.getCounts_TINC(value);
        }
        if (euc.equals("TMIL")) {
            return CcnRspFidUtil.getCounts_TMIL(value);
        }
        if (euc.equals("TDTM")) {
            return CcnRspFidUtil.getCounts_TDTM(value);
        }
        if (euc.equals("TTMP")) {
            return CcnRspFidUtil.getCounts_TTMP(value);
        }
        if (euc.equals("TNUM")) {
            return CcnRspFidUtil.getCounts_TNUM(value);
        }
        if (euc.equals("TVOL")) {
            return CcnRspFidUtil.getCounts_TVOL(value);
        }
        if (euc.equals("TPSI")) {
            return CcnRspFidUtil.getCounts_TPSI(value);
        }
        if (euc.equals("TENT")) {
            return CcnRspFidUtil.getCounts_TENT(value);
        }
        if (euc.equals("TCFM")) {
            return CcnRspFidUtil.getCounts_TCFM(value);
        }
        if (euc.equals("TOFF")) {
            return CcnRspFidUtil.getCounts_TOFF(value);
        }
        throw new CcnException(6488180, "FidTable - convertFloatToCounts... bad EUC=" + euc);
    }

    public static String get2DigString(int val) {
        String dig = "00" + Integer.toString(val);
        return dig.substring(dig.length() - 2);
    }

    private static float getConversion_TTEM(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp > 254) {
            f1 = 254.0f;
        }
        float f2 = fracComp;
        float newVal = f1 - 10.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TPER(int intComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 254) {
            f1 = 254.0f;
        }
        float newVal = (f1 - 1.0f) * 99.0f / 253.0f;
        return newVal;
    }

    private static float getConversion_TINC(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 254) {
            f1 = 254.0f;
        }
        float f2 = fracComp;
        float newVal = (f1 - 1.0f) * 10.0f / 506.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TMIL(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp > 254) {
            f1 = 254.0f;
        }
        float f2 = fracComp;
        float newVal = (f1 - 1.0f) * 16.0f / 253.0f + 4.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TDTM(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp > 253) {
            f1 = 253.0f;
        }
        float f2 = fracComp;
        float newVal = (f1 - 10.0f) / 10.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TTMP(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 253) {
            f1 = 253.0f;
        }
        float f2 = fracComp;
        float newVal = (f1 - 10.0f) / 3.0f + f2 / 10.0f;
        return newVal;
    }

    private static int getConversion_TNUM(int intComp) {
        int newVal = intComp;
        if (intComp > 255) {
            newVal = 255;
        }
        return newVal;
    }

    private static float getConversion_TVOL(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 254) {
            f1 = 254.0f;
        }
        float f2 = fracComp;
        float newVal = (f1 - 1.0f) * 10.0f / 253.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TPSI(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 255) {
            f1 = 255.0f;
        }
        float f2 = fracComp;
        float newVal = f1 * 11.0f / 170.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TENT(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 255) {
            f1 = 255.0f;
        }
        float f2 = fracComp;
        float newVal = f1 / 5.0f + f2 / 10.0f;
        return newVal;
    }

    private static float getConversion_TCFM(int intComp, int fracComp) {
        float f1 = intComp;
        if (intComp == 0) {
            f1 = 1.0f;
        } else if (intComp > 95) {
            f1 = 95.0f;
        }
        float f2 = fracComp;
        float newVal = (float)((double)f1 / 9.5) + f2 / 10.0f;
        return newVal;
    }

    private static int getConversion_TOFF(int intComp) {
        int intVal = intComp & 0xFF;
        if (intVal == 255) {
            return 0;
        }
        return intVal + 1;
    }

    private static float getCounts_TTEM(float val) throws CcnException {
        float counts = val + 10.0f;
        if (0.0f <= counts && counts <= 254.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTEM... bad count=" + counts);
    }

    private static float getCounts_TPER(float val) throws CcnException {
        float counts = val * 253.0f / 99.0f + 1.0f;
        if (1.0f <= counts && counts <= 254.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TPER... bad count=" + counts);
    }

    private static float getCounts_TINC(float val) throws CcnException {
        float counts = val * 506.0f / 10.0f + 1.0f;
        if (1.0f <= counts && counts <= 254.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TINC... bad val|count=" + val + "|" + counts);
    }

    private static float getCounts_TMIL(float val) throws CcnException {
        float counts = (val - 4.0f) * 253.0f / 16.0f + 1.0f;
        if (0.0f <= counts && counts <= 254.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TMIL... bad count=" + counts);
    }

    private static float getCounts_TDTM(float val) throws CcnException {
        float counts = val * 10.0f + 10.0f;
        if (0.0f <= counts && counts <= 253.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TDTM... bad count=" + counts);
    }

    private static float getCounts_TTMP(float val) throws CcnException {
        float counts = val * 3.0f + 10.0f;
        if (1.0f <= counts && counts <= 253.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTMP... bad count=" + counts);
    }

    private static float getCounts_TNUM(float val) throws CcnException {
        float counts = val;
        if (0.0f <= counts && counts <= 255.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TTMP... bad count=" + counts);
    }

    private static float getCounts_TVOL(float val) throws CcnException {
        float counts = val * 253.0f / 10.0f + 1.0f;
        if (1.0f <= counts && counts <= 254.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TVOL... bad count=" + counts);
    }

    private static float getCounts_TPSI(float val) throws CcnException {
        float counts = val * 170.0f / 11.0f;
        if (0.0f <= counts && counts <= 255.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TPSI... bad count=" + counts);
    }

    private static float getCounts_TENT(float val) throws CcnException {
        float counts = val * 5.0f;
        if (0.0f <= counts && counts <= 255.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TENT... bad count=" + counts);
    }

    private static float getCounts_TCFM(float val) throws CcnException {
        float counts = val * 9.5f;
        if (0.0f <= counts && counts <= 95.0f) {
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TCFM... bad count=" + counts);
    }

    private static float getCounts_TOFF(float val) throws CcnException {
        float counts = val - 1.0f;
        if (-1.0f <= counts && counts <= 254.0f) {
            if (counts == -1.0f) {
                return 0.0f;
            }
            return counts;
        }
        throw new CcnException(6488176, "FidTable - getCounts_TOFF... bad count=" + counts);
    }

    public static float getVariableValue(CcnResponseMessage rsp) {
        byte[] buf = rsp.getResponseBuffer().getResponseData();
        int iData = buf[0] << 24 & 0xFF000000;
        iData |= buf[1] << 16 & 0xFF0000;
        iData |= buf[2] << 8 & 0xFF00;
        return Float.intBitsToFloat(iData |= buf[3] & 0xFF);
    }

    public static String getEUValue(float val, String euc, int displayDigits) {
        int intComp = (int)val;
        int fracComp = (int)((val - (float)intComp) * 10.0f);
        float fVal = 0.0f;
        if (euc.equals("TTEM")) {
            fVal = CcnRspFidUtil.getConversion_TTEM(intComp, fracComp);
        } else if (euc.equals("TPER")) {
            fVal = CcnRspFidUtil.getConversion_TPER(intComp);
        } else if (euc.equals("TINC")) {
            fVal = CcnRspFidUtil.getConversion_TINC(intComp, fracComp);
        } else if (euc.equals("TMIL")) {
            fVal = CcnRspFidUtil.getConversion_TMIL(intComp, fracComp);
        } else if (euc.equals("TDTM")) {
            fVal = CcnRspFidUtil.getConversion_TDTM(intComp, fracComp);
        } else if (euc.equals("TTMP")) {
            fVal = CcnRspFidUtil.getConversion_TTMP(intComp, fracComp);
        } else {
            if (euc.equals("TNUM")) {
                return Integer.toString(CcnRspFidUtil.getConversion_TNUM(intComp));
            }
            if (euc.equals("TVOL")) {
                fVal = CcnRspFidUtil.getConversion_TVOL(intComp, fracComp);
            } else if (euc.equals("TPSI")) {
                fVal = CcnRspFidUtil.getConversion_TPSI(intComp, fracComp);
            } else if (euc.equals("TENT")) {
                fVal = CcnRspFidUtil.getConversion_TENT(intComp, fracComp);
            } else if (euc.equals("TCFM")) {
                fVal = CcnRspFidUtil.getConversion_TCFM(intComp, fracComp);
            } else {
                if (euc.equals("TOFF")) {
                    return Integer.toString(CcnRspFidUtil.getConversion_TOFF(intComp));
                }
                return null;
            }
        }
        NumberFormat nf = NumberFormat.getInstance();
        int fracDigits = displayDigits & 0xF;
        nf.setMaximumFractionDigits(fracDigits);
        nf.setMinimumFractionDigits(fracDigits);
        ((DecimalFormat)nf).setGroupingSize(20);
        return nf.format(fVal);
    }

    public static byte[] mergeNewValue(byte[] blockData, String newValue, BCcnPointEntry pt, int tableType) {
        int ptNum = pt.getFieldIndex();
        if (tableType == 1283) {
            if (ptNum % 3 == 0) {
                CcnRspFidUtil.setPeriodOccTime(newValue, blockData, ptNum);
            } else if (ptNum % 3 == 1) {
                CcnRspFidUtil.setPeriodUnoccTime(newValue, blockData, ptNum);
            } else if (ptNum % 3 == 2) {
                CcnRspFidUtil.setDaysFlags(newValue, blockData, ptNum);
            }
        } else if (tableType == 1284) {
            if (0 <= ptNum && ptNum <= 3) {
                int decision = CcnRspFidUtil.getSetpointDecision(pt.getUnits());
                CcnRspFidUtil.setSetpointValue(newValue, blockData, decision, ptNum);
            }
        } else if (tableType == 1285 && 0 <= ptNum && ptNum <= 59) {
            if (ptNum % 2 == 0) {
                CcnRspFidUtil.setHolidayMonth(newValue, blockData, ptNum);
            } else {
                CcnRspFidUtil.setHolidayDay(newValue, blockData, ptNum);
            }
        }
        return blockData;
    }

    public static byte[] mergeNewValue(byte[] blockData, String newValue, BCcnProxyExt pt, int tableType) {
        int ptNum = pt.getFieldIndex();
        if (tableType == 1283) {
            if (ptNum % 3 == 0) {
                CcnRspFidUtil.setPeriodOccTime(newValue, blockData, ptNum);
            } else if (ptNum % 3 == 1) {
                CcnRspFidUtil.setPeriodUnoccTime(newValue, blockData, ptNum);
            } else if (ptNum % 3 == 2) {
                CcnRspFidUtil.setDaysFlags(newValue, blockData, ptNum);
            }
        } else if (tableType == 1284) {
            if (0 <= ptNum && ptNum <= 3) {
                int decision = CcnRspFidUtil.getSetpointDecision(pt.getUnits());
                CcnRspFidUtil.setSetpointValue(newValue, blockData, decision, ptNum);
            }
        } else if (tableType == 1285 && 0 <= ptNum && ptNum <= 59) {
            if (ptNum % 2 == 0) {
                CcnRspFidUtil.setHolidayMonth(newValue, blockData, ptNum);
            } else {
                CcnRspFidUtil.setHolidayDay(newValue, blockData, ptNum);
            }
        }
        return blockData;
    }

    public static String getValue(CcnResponseMessage rsp, BCcnPointEntry entry) throws CcnException {
        String newValue = new String();
        int tableType = rsp.getTableType();
        if (1283 <= tableType && tableType <= 1285) {
            int ptNum = entry.getFieldIndex();
            if (tableType == 1283) {
                int period = ptNum / 3 + 1;
                if (ptNum % 3 == 0) {
                    newValue = CcnRspFidUtil.getPeriodOccTime(rsp, period);
                } else if (ptNum % 3 == 1) {
                    newValue = CcnRspFidUtil.getPeriodUnoccTime(rsp, period);
                } else if (ptNum % 3 == 2) {
                    newValue = CcnRspFidUtil.getDaysFlags(rsp, period);
                }
            } else if (tableType == 1284) {
                if (0 <= ptNum && ptNum <= 3) {
                    int decision = CcnRspFidUtil.getSetpointType(rsp);
                    float fVal = CcnRspFidUtil.getSetpointValue(rsp, decision, ptNum);
                    NumberFormat nf = NumberFormat.getInstance();
                    int fracDigits = entry.getDisplayDigits() & 0xF;
                    nf.setMaximumFractionDigits(fracDigits);
                    nf.setMinimumFractionDigits(fracDigits);
                    ((DecimalFormat)nf).setGroupingSize(20);
                    return nf.format(fVal);
                }
            } else if (tableType == 1285) {
                int holidayNumber = ptNum / 2 + 1;
                if (0 <= ptNum && ptNum <= 59) {
                    newValue = ptNum % 2 == 0 ? CcnRspFidUtil.getHolidayMonth(rsp, holidayNumber) : CcnRspFidUtil.getHolidayDay(rsp, holidayNumber);
                }
            }
            return newValue;
        }
        throw new CcnException(6488168, "FidTable: " + tableType + " - FID Table type not valid to getValue");
    }

    public static String getValue(CcnResponseMessage rsp, BCcnProxyExt entry) throws CcnException {
        String newValue = new String();
        int tableType = rsp.getTableType();
        if (1283 <= tableType && tableType <= 1285) {
            int ptNum = entry.getFieldIndex();
            if (tableType == 1283) {
                int period = ptNum / 3 + 1;
                if (ptNum % 3 == 0) {
                    newValue = CcnRspFidUtil.getPeriodOccTime(rsp, period);
                } else if (ptNum % 3 == 1) {
                    newValue = CcnRspFidUtil.getPeriodUnoccTime(rsp, period);
                } else if (ptNum % 3 == 2) {
                    newValue = CcnRspFidUtil.getDaysFlags(rsp, period);
                }
            } else if (tableType == 1284) {
                if (0 <= ptNum && ptNum <= 3) {
                    int decision = CcnRspFidUtil.getSetpointType(rsp);
                    float fVal = CcnRspFidUtil.getSetpointValue(rsp, decision, ptNum);
                    NumberFormat nf = NumberFormat.getInstance();
                    int fracDigits = entry.getDisplayDigits() & 0xF;
                    nf.setMaximumFractionDigits(fracDigits);
                    nf.setMinimumFractionDigits(fracDigits);
                    ((DecimalFormat)nf).setGroupingSize(20);
                    return nf.format(fVal);
                }
            } else if (tableType == 1285) {
                int holidayNumber = ptNum / 2 + 1;
                if (0 <= ptNum && ptNum <= 59) {
                    newValue = ptNum % 2 == 0 ? CcnRspFidUtil.getHolidayMonth(rsp, holidayNumber) : CcnRspFidUtil.getHolidayDay(rsp, holidayNumber);
                }
            }
            return newValue;
        }
        throw new CcnException(6488168, "FidTable: " + tableType + " - FID Table type not valid to getValue");
    }

    public static BCcnTimeScheduleEntry[] buildTimeSchedules(BCcnPointEntry[] pointEntries) {
        BCcnTimeScheduleEntry[] tsList = new BCcnTimeScheduleEntry[7];
        BCcnTimeScheduleList list = new BCcnTimeScheduleList();
        for (int i = 0; i < 21; i += 3) {
            int j = i / 3;
            int pointValue = Integer.parseInt(pointEntries[i + 2].getPointValue(), 2);
            boolean mon = (pointValue & 0x80) == 128;
            boolean tues = (pointValue & 0x40) == 64;
            boolean wed = (pointValue & 0x20) == 32;
            boolean thur = (pointValue & 0x10) == 16;
            boolean fri = (pointValue & 8) == 8;
            boolean sat = (pointValue & 4) == 4;
            boolean sun = (pointValue & 2) == 2;
            boolean holiday = (pointValue & 1) == 1;
            String from = pointEntries[i].getPointValue();
            String to = pointEntries[i + 1].getPointValue();
            String period = "Period " + (j + 1);
            tsList[j] = new BCcnTimeScheduleEntry(mon, tues, wed, thur, fri, sat, sun, holiday, from, to, period);
        }
        list.setTimeScheduleList(tsList);
        return tsList;
    }
}

