/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspTableUtil;

public final class CcnRspDevUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int EXPECTED_DEV_TBL_TYPE = 32;

    private static CcnException wrongTableException() {
        return new CcnException(6488168, "Method needs table " + EXPECTED_DEV_TBL_TYPE + ".");
    }

    public static String getDevName(CcnResponseMessage rsp) throws CcnException {
        if (rsp.getTableType() != EXPECTED_DEV_TBL_TYPE) {
            throw CcnRspDevUtil.wrongTableException();
        }
        return CcnRspDevUtil.getTableName(rsp);
    }

    public static int getPrimaryBaudRate(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (3 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return ((buf[3] & 0xFF) << 8 | buf[4] & 0xFF) & 0xFFFF;
        }
        throw new CcnException(6488167, "Device Table - Need block 3 to getPrimaryBaudRate");
    }

    public static int getSecondaryBaudRate(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (3 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return ((buf[5] & 0xFF) << 8 | buf[6] & 0xFF) & 0xFFFF;
        }
        throw new CcnException(6488167, "Device Table - Need block 3 to getPrimaryBaudRate");
    }

    public static String getDevDesc(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 3, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getDevDesc");
    }

    public static String getLocDesc(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 27, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getLocDesc");
    }

    public static String getSwPartNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 51, 16));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getSwPartNum");
    }

    public static String getModelNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 67, 20));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getModelNum");
    }

    public static String getSerialNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 87, 12));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getSerialNum");
    }

    public static String getReferenceNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (4 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 99, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getReferenceNum");
    }

    public static String getPlatformId(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 3, 1));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPlatformId");
    }

    public static String getPICExecSWVerNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(buf, 4, 1));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICExecSWVerNum");
    }

    public static String getPICType(CcnResponseMessage rsp) throws CcnException {
        if (rsp.getTableType() != EXPECTED_DEV_TBL_TYPE) {
            throw CcnRspDevUtil.wrongTableException();
        }
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int iData = buf[5];
            if (iData < 0) {
                iData = 256 + iData;
            }
            return new String("" + Integer.toString(iData) + new String(CcnRspDevUtil.getSubByteArray(buf, 6, 2)));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICType");
    }

    public static String getPICApplSwVerNum(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspDevUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            byte[] temp = CcnRspDevUtil.getSubByteArray(buf, 8, 1);
            return Integer.toString(temp[0] / 10) + "." + Integer.toString(temp[0] % 10);
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICApplSwVerNum");
    }
}

