/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="timeScheduleList", type="BCcnTimeScheduleList", defaultValue="new BCcnTimeScheduleList()", flags=4)
@NiagaraAction(name="saveTimeSchedule", parameterType="BCcnTimeScheduleList", defaultValue="new BCcnTimeScheduleList()", flags=20)
public class BCcnDataTableWithTimeSchedule
extends BCcnDataTable {
    @Generated
    public static final Property timeScheduleList = BCcnDataTableWithTimeSchedule.newProperty((int)4, (BValue)new BCcnTimeScheduleList(), null);
    @Generated
    public static final Action saveTimeSchedule = BCcnDataTableWithTimeSchedule.newAction((int)20, (BValue)new BCcnTimeScheduleList(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnDataTableWithTimeSchedule.class);
    BIcon icon = BIcon.std((String)"editPolygon.png");
    BCcnTableEntry entry;

    @Generated
    public BCcnTimeScheduleList getTimeScheduleList() {
        return (BCcnTimeScheduleList)this.get(timeScheduleList);
    }

    @Generated
    public void setTimeScheduleList(BCcnTimeScheduleList v) {
        this.set(timeScheduleList, (BValue)v, null);
    }

    @Generated
    public void saveTimeSchedule(BCcnTimeScheduleList parameter) {
        this.invoke(saveTimeSchedule, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnDataTableWithTimeSchedule() {
    }

    public BCcnDataTableWithTimeSchedule(BCcnTableEntry entry) {
        this.entry = entry;
    }

    public void doSaveTimeSchedule(BCcnTimeScheduleList newList) {
        BCcnPointEntry[] pointList;
        String errorMessage;
        block32: {
            errorMessage = null;
            pointList = (BCcnPointEntry[])this.getPointList().getChildren(BCcnPointEntry.class);
            BCcnTimeScheduleEntry[] entries = newList.getTimeScheduleList();
            CcnResponseMessage rsp = this.getReadTableResponse(2);
            if (rsp == null) {
                BCcnTimeScheduleEntry[] tsList = CcnRspDataUtil.buildTimeSchedules(pointList);
                this.getTimeScheduleList().setTimeScheduleList(tsList);
                errorMessage = "Reading table block 0x02 is failed";
                this.ccnTablesLog.trace("Write value is unsuccessful.\n" + errorMessage);
                return;
            }
            byte[] data = rsp.getData();
            for (int i = 0; i < 8; ++i) {
                int j = i * 3;
                pointList[j + 2].setPointValue(entries[i].getFrom());
                pointList[j + 3].setPointValue(entries[i].getTo());
                int newValue = entries[i].getMon() ? 128 : 0;
                if (entries[i].getTues()) {
                    newValue |= 0x40;
                }
                if (entries[i].getWed()) {
                    newValue |= 0x20;
                }
                if (entries[i].getThur()) {
                    newValue |= 0x10;
                }
                if (entries[i].getFri()) {
                    newValue |= 8;
                }
                if (entries[i].getSat()) {
                    newValue |= 4;
                }
                if (entries[i].getSun()) {
                    newValue |= 2;
                }
                if (entries[i].getHoliday()) {
                    newValue |= 1;
                }
                pointList[j + 1].setPointValue(Integer.toBinaryString(newValue));
                data = CcnRspPicPocUtil.mergeNewValue(data, pointList[j + 1].getValueBlockOffset(), 0, 1, pointList[j + 1].getPointValue(), null, pointList[j + 1]);
                data = CcnRspPicPocUtil.mergeNewValue(data, pointList[j + 2].getValueBlockOffset(), 12, 2, pointList[j + 2].getPointValue(), null, pointList[j + 2]);
                data = CcnRspPicPocUtil.mergeNewValue(data, pointList[j + 3].getValueBlockOffset(), 12, 2, pointList[j + 3].getPointValue(), null, pointList[j + 3]);
            }
            byte[] newData = new byte[data.length - 3];
            for (int z = 3; z < data.length - 3; ++z) {
                newData[z - 3] = data[z];
            }
            CcnResponseMessage writeRsp = this.writeTable(newData, (byte)2);
            if (writeRsp != null) {
                BCcnPointList pList = new BCcnPointList(pointList);
                BCcnPointEntry[] pUpdatedEntry = pList.getPointList();
                int k = 0;
                if (writeRsp.getResponseCommand() == 6) {
                    try {
                        CcnResponseMessage rspBack = this.getReadTableResponse(2);
                        if (rspBack == null) {
                            errorMessage = "Unknown error. Response is null.";
                            break block32;
                        }
                        int index = 1;
                        for (k = 1; k < 25; ++k) {
                            String value = CcnRspDataUtil.getValue(rspBack, index, pUpdatedEntry[k]);
                            pUpdatedEntry[k].setPointValue(value);
                            if (k == 1 || k == 4 || k == 7 || k == 10 || k == 13 || k == 16 || k == 19 || k == 22) {
                                ++index;
                                continue;
                            }
                            index += 2;
                        }
                        BCcnPointList updatedList = new BCcnPointList(pUpdatedEntry);
                        if (!pList.equals((Object)updatedList)) {
                            errorMessage = "Unknown error. Response command is 0x06, but the value in controller is not updated.";
                            break block32;
                        }
                        this.getPointList().setPointList(pUpdatedEntry);
                        this.getTimeScheduleList().setTimeScheduleList(entries);
                        BCcnProxyExt[] createdPoints = this.getCreatedPoints();
                        for (int z = 0; z < 25; ++z) {
                            if (createdPoints[z] == null) continue;
                            ((BCcnInputProxy)createdPoints[z]).setValue(pUpdatedEntry[z].getPointValue());
                        }
                        return;
                    }
                    catch (CcnException e) {
                        this.ccnTablesLog.error(this.getSummaryString() + "<CcnDataTableWithTimeSchedule: Data table get No." + pUpdatedEntry[k].getFieldIndex() + " field from block 2 ERROR: " + (Object)((Object)e));
                    }
                } else if (writeRsp.getResponseCommand() == 21) {
                    switch (writeRsp.getResponseCode()) {
                        case 1: {
                            errorMessage = "Command not implemented.";
                            break;
                        }
                        case 4: {
                            errorMessage = "Table not defined.";
                            break;
                        }
                        case 9: {
                            errorMessage = "POC function does not exist.";
                            break;
                        }
                        case 10: {
                            errorMessage = "Block not defined.";
                            break;
                        }
                        case 16: {
                            errorMessage = "Access denied.";
                            break;
                        }
                        case 18: {
                            errorMessage = "Invalid configuration parameter.";
                            break;
                        }
                        default: {
                            errorMessage = "Unknown error.";
                            break;
                        }
                    }
                } else {
                    errorMessage = "Unknown error. Response command is neither 0x15 nor 0x06.";
                }
            } else {
                errorMessage = "Unknown error. Response is null.";
            }
        }
        if (errorMessage != null) {
            BCcnTimeScheduleEntry[] tsList = CcnRspDataUtil.buildTimeSchedules(pointList);
            this.getTimeScheduleList().setTimeScheduleList(tsList);
            this.ccnTablesLog.trace(" Write time schedule is unsuccessful.\n" + errorMessage);
        }
    }

    @Override
    public BIcon getIcon() {
        return this.icon;
    }
}

