/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.point;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCcnNonForcableProxy
extends BCcnInputProxy {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnNonForcableProxy.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnNonForcableProxy() {
    }

    public BCcnNonForcableProxy(BCcnPointEntry entry) {
        super(entry);
        this.setDiscreteTextOffset(entry.getDiscreteTextOffset());
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        try {
            if (this.getParentPoint() instanceof BBooleanWritable || this.getParentPoint() instanceof BBooleanPoint) {
                this.updateControlPointFacets();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
    }

    public void doWrite(BStatusValue out) {
        this.ccnPointsLog.trace("doWrite invoked....");
        try {
            if (this.getStatus() != BStatus.ok) {
                return;
            }
            if (this.getTable().getCcnDevice().getStatus() != BStatus.ok) {
                throw new LocalizableRuntimeException("ccn", "CcnWritePoint.Fail");
            }
            long startTime = BAbsTime.now().getMillis();
            String value = "";
            int dataType = this.getPointDataType();
            if (this.isDiscrete()) {
                if (dataType == 1 || dataType == 9) {
                    boolean outValue = ((BStatusBoolean)out).getBoolean();
                    value = outValue + "";
                }
            } else if (dataType == 12 || dataType == 51 || dataType == 1 || dataType == 9 || dataType == 0 || dataType == 16 || dataType == 32 || dataType == 33 || dataType == 34 || dataType == 18 || dataType == 19 || dataType == 20 || dataType == 21 || dataType == 22 || dataType == 23 || dataType == 24) {
                String outValue = ((BStatusString)out).getValue();
                value = dataType == 12 ? CcnUtil.formatTime(outValue) : (dataType == 51 ? CcnUtil.formatDoubleTime(outValue) : outValue);
            } else {
                double outValue = ((BStatusNumeric)out).getNumeric();
                value = outValue + "";
            }
            if (dataType != 0 && !CcnRspPicPocUtil.checkRange(value, this)) {
                if (this.getPointDataType() == 12 || this.getPointDataType() == 51) {
                    throw new CcnRuntimeException(6488176, this.getDebugSummaryString() + "User value " + value + " out of limits, write aborted.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59.");
                }
                throw new CcnRuntimeException(6488176, this.getDebugSummaryString() + "User value " + value + " out of limits, write aborted.\nThe limits are " + this.getLoLimit() + " to " + this.getHiLimit());
            }
            if (dataType == 12 || dataType == 51) {
                try {
                    value = this.massageFloatToTimeString(value);
                }
                catch (CcnException e) {
                    this.ccnPointsLog.error("<doSetValue ERROR: " + this.getDebugSummaryString() + (Object)((Object)e));
                }
            }
            if (dataType == 0) {
                int tempInt = Float.valueOf(value).intValue();
                String tempString = Integer.toString(tempInt);
                byte[] testBA = tempString.getBytes();
                for (int i = 0; i < testBA.length; ++i) {
                    if (testBA[i] == 48 || testBA[i] == 49) continue;
                    throw new CcnRuntimeException(6488181, this.getDebugSummaryString() + "Enter 8-bit flag value such as 11000100");
                }
                value = tempString;
            }
            if ((dataType == 1 || dataType == 2 || dataType == 9 || dataType == 10 || dataType == 17) && this.getDisplayDigits() == 0) {
                try {
                    int tempValue = Float.valueOf(value).intValue();
                    value = Integer.toString(tempValue);
                }
                catch (Exception e) {
                    this.ccnPointsLog.error("<doSetValue ERROR: " + this.getDebugSummaryString() + " value entered = " + value + " must be an Integer");
                    return;
                }
            }
            this.ccnPointsLog.trace("<doSetValue" + this.getDebugSummaryString() + "converted setValue=" + value);
            if (this.isDiscrete()) {
                if (value.equalsIgnoreCase("true")) {
                    this.setFieldValue("1");
                } else {
                    this.setFieldValue("0");
                }
            } else {
                this.setFieldValue(value);
            }
            if (this.getTable().writeTable(this)) {
                this.writeOk((BStatusValue)new BStatusString(value));
            } else {
                this.setFault(true);
            }
            long endTime = BAbsTime.now().getMillis();
            this.ccnTimeLog.trace("Time taken to set a new value  for point-->" + this.getFieldName() + " with Table" + this.getTable().getTableName() + "is" + (endTime - startTime) + "milli seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String massageFloatToTimeString(String _floatValue) throws CcnException {
        String returnValue = new String();
        try {
            int tempInt = Float.valueOf(_floatValue).intValue();
            if (tempInt < 9999) {
                int hh = tempInt / 100;
                int mm = tempInt % 100;
                returnValue = hh > 24 || hh < 0 || mm > 60 || mm < 0 ? null : "" + CcnRspFidUtil.get2DigString(hh) + ":" + CcnRspFidUtil.get2DigString(mm);
            }
        }
        catch (Exception e) {
            throw new CcnException(6488174, "Enter time value in hhmm format");
        }
        return returnValue;
    }
}

