/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnResponseBuffer;
import java.io.OutputStream;

public class CcnResponseMessage
extends Message
implements CcnDataWrapper {
    protected CcnResponseBuffer response = null;
    protected int tableType = 0;
    protected int tableInstance = 0;

    public CcnResponseMessage() {
    }

    public CcnResponseMessage(CcnResponseBuffer responseBuffer) {
        this.response = responseBuffer;
    }

    public byte getResponseCommand() {
        return this.response.getResponseCommand();
    }

    public int getTableNumber() {
        return ((this.response.getResponseData()[0] & 0xFF) << 8 | this.response.getResponseData()[1] & 0xFF) & 0xFFFF;
    }

    public byte getBlock() {
        return this.response.getResponseData()[2];
    }

    public int getBlockLen() {
        return this.response.getResponseDataLength() & 0xFF;
    }

    public byte getResponseCode() {
        byte responseCommand = this.response.getResponseCommand();
        if (responseCommand == 6) {
            return 0;
        }
        if (responseCommand == 21 && this.getBlockLen() > 0) {
            return (byte)(this.getData()[0] & 0xFF);
        }
        return -1;
    }

    public void setTableType(int newType) {
        this.tableType = newType;
    }

    public int getTableType() {
        return this.tableType;
    }

    public void setTableInstance(int newInstance) {
        this.tableInstance = newInstance;
    }

    public int getTableInstance() {
        return this.tableInstance;
    }

    public void write() {
    }

    public CcnResponseBuffer getResponseBuffer() {
        return this.response;
    }

    public String toString() {
        return this.response.toString();
    }

    public byte[] getData() {
        return this.response.getResponseData();
    }

    public void write(OutputStream out) {
    }

    public Message toResponse(ReceivedMessage resp) {
        return null;
    }
}

