/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnBridgesEntry;
import com.tridium.ccn.components.BCcnBridgesList;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDevicesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadObjectDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.platCcn.CcnObjectDef;
import com.tridium.platCcn.CcnTableDef;
import java.io.OutputStream;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnNetworkRequest
extends CcnRequestMessage
implements AsynchronousRequest,
CcnMessageConst {
    boolean isNewDevice;
    private final BCcnNetwork ccnNetwork;
    private final BCcnLearnDevicesJob job;
    private Vector<BCcnControllerEntry> discoveredDevices;
    private static final Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnLearnNetworkRequest(BCcnNetwork network, BCcnLearnDevicesJob learnJob) {
        this.ccnNetwork = network;
        this.job = learnJob;
    }

    public Message toResponse(ReceivedMessage resp) {
        return null;
    }

    public void write(OutputStream out) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.ccnNetwork.isNetworkStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnDevice.add");
        }
        this.ccnNetwork.setLearnStatus("Learn-> Start discovery process...");
        if (this.job != null) {
            this.job.log().message("Learn-> Start discovery process...");
        }
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Start discovery process...");
        }
        this.ccnNetwork.setDeviceLearnCount(0);
        try {
            int busAddress = this.ccnNetwork.getBusAddress();
            if (busAddress != 0 && !this.ccnNetwork.isBridge(busAddress)) {
                this.ccnNetwork.setLearnStatus("Learn-> Local device is on secondary bus " + busAddress + ", determining if address 0:" + busAddress + " is a bridge...");
                if (this.job != null) {
                    this.job.log().message("Learn-> Local device is on secondary bus " + busAddress + ", determining if address 0:" + busAddress + " is a bridge...");
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Local device is on secondary bus " + busAddress + ", determining if address 0:" + busAddress + " is a bridge...");
                }
                if (this.testForBridge(busAddress)) {
                    this.updateBridgesList(busAddress);
                    this.ccnNetwork.setLearnStatus("Learn-> Bridge does exist at address 0:" + busAddress + "... can reach primary bus");
                    if (this.job != null) {
                        this.job.log().message("Learn-> Bridge does exist at address 0:" + busAddress + "... can reach primary bus");
                    }
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Bridge does exist at address 0:" + busAddress + "... can reach primary bus");
                    }
                } else {
                    this.ccnNetwork.setLearnStatus("Learn-> Bridge not responding at address 0:" + busAddress + "... will try but, may not be able to reach primary bus or any other secondary bus");
                    if (this.job != null) {
                        this.job.log().message("Learn-> Bridge not responding at address 0:" + busAddress + "... will try but, may not be able to reach primary bus or any other secondary bus");
                    }
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Bridge not responding at address 0:" + busAddress + "... will try but, may not be able to reach primary bus or any other secondary bus");
                    }
                }
            }
            this.discoveredDevices = new Vector();
            int firstBusNo = this.ccnNetwork.getFirstBusNo();
            int lastBusNo = this.ccnNetwork.getLastBusNo();
            int lowElemNo = this.ccnNetwork.getLowElemNo();
            int highElemNo = this.ccnNetwork.getHighElemNo();
            if (this.ccnNetwork.getClearBridgeList()) {
                this.ccnNetwork.getBridges().removeAll();
                this.ccnNetwork.setClearBridgeList(false);
                this.ccnNetwork.setLearnStatus("Learn-> All bridges cleared per user request...");
                if (this.job != null) {
                    this.job.log().message("Learn-> All bridges cleared per user request...");
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> All bridges cleared per user request...");
                }
            }
            if (firstBusNo <= lastBusNo && lowElemNo <= highElemNo) {
                if (this.job != null) {
                    this.job.progress(1);
                }
                for (int bn = firstBusNo; bn <= lastBusNo; ++bn) {
                    if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                        this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                        this.job.log().message("Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                        }
                        this.ccnNetwork.setAbort(false);
                        break;
                    }
                    if (bn != 0 && bn != busAddress) {
                        this.ccnNetwork.setLearnStatus("Learn-> Determining if address 0:" + bn + " is a bridge...");
                        if (this.job != null) {
                            this.job.log().message("Learn-> Determining if address 0:" + bn + " is a bridge...");
                        }
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Determining if address 0:" + bn + " is a bridge...");
                        }
                        if (!this.ccnNetwork.isBridge(bn)) {
                            if (this.testForBridge(bn)) {
                                this.updateBridgesList(bn);
                            } else {
                                this.ccnNetwork.setLearnStatus("Learn-> No bridge at address 0:" + bn + " skip discovery on bus " + bn);
                                if (this.job != null) {
                                    this.job.log().message("Learn-> No bridge at address 0:" + bn + " skip discovery on bus " + bn);
                                }
                                if (ccnMessageLog.isTraceOn()) {
                                    ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> No bridge at address 0:" + bn + " skip discovery on bus " + bn);
                                }
                                if (this.job == null) continue;
                                this.job.progress((100 * bn + 1) / (lastBusNo + 1));
                                continue;
                            }
                        }
                        this.ccnNetwork.setLearnStatus("Learn-> Bridge at address 0:" + bn + "... path exist from local device bus " + busAddress + " to secondary bus " + bn + ", now attempt to discover elements");
                        if (this.job != null) {
                            this.job.log().message("Learn-> Bridge at address 0:" + bn + "... path exist from local device bus " + busAddress + " to secondary bus " + bn + ", now attempt to discover elements");
                        }
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Bridge at address 0:" + bn + "... path exist from local device bus " + busAddress + " to secondary bus " + bn + ", now attempt to discover elements");
                        }
                    }
                    boolean pathAvailable = false;
                    if (busAddress == 0 && bn == 0) {
                        pathAvailable = true;
                    } else if (busAddress == 0 && bn != 0) {
                        pathAvailable = this.ccnNetwork.isBridge(bn);
                    } else if (busAddress != 0 && busAddress == bn) {
                        pathAvailable = true;
                    } else if (busAddress != 0 && bn == 0) {
                        pathAvailable = this.ccnNetwork.isBridge(busAddress);
                        if (!pathAvailable) {
                            if (ccnMessageLog.isTraceOn()) {
                                ccnMessageLog.trace("CcnLearnNetworkRequest: Local device on secondary bus " + busAddress + " and bridge to primary bus not responding, will continue but questionable if learn will succeed, you may need to verify your bridge to primary bus");
                            }
                            pathAvailable = true;
                        }
                    } else if (busAddress != 0 && busAddress != bn) {
                        pathAvailable = this.ccnNetwork.isBridge(bn);
                    }
                    if (!pathAvailable) {
                        this.ccnNetwork.setLearnStatus("Learn-> Discovery on bus " + bn + " terminated... no path from local device bus " + busAddress + " to bus " + bn);
                        if (this.job != null) {
                            this.job.log().message("Learn-> Discovery on bus " + bn + " terminated... no path from local device bus " + busAddress + " to bus " + bn);
                        }
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Discovery on bus " + bn + " terminated... no path from local device bus " + busAddress + " to bus " + bn);
                        }
                        if (this.job == null) continue;
                        this.job.progress((100 * bn + 1) / (lastBusNo + 1));
                        continue;
                    }
                    for (int en = lowElemNo; en <= highElemNo; ++en) {
                        if (!this.ccnNetwork.isBridge(bn) && this.job != null) {
                            this.job.progress((bn + 1) * en * 100 / ((lastBusNo + 1) * highElemNo));
                        }
                        this.ccnNetwork.setDiscoveryInProgress(true);
                        this.ccnNetwork.setLearnStatus("Learn-> Try element at bus:" + bn + " element:" + en);
                        if (this.job != null) {
                            this.job.log().message("Learn-> Try element at bus:" + bn + " element:" + en);
                        }
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Try element at bus:" + bn + " element:" + en);
                        }
                        this.interrogateDevice(bn, en);
                        if (this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled) continue;
                        this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn element:" + en);
                        this.job.log().message("Cancelled-> Cancellation requested by user during network learn element:" + en);
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnNetworkRequest: Cancelled-> Cancellation requested by user during network learn element:" + en);
                        }
                        this.ccnNetwork.setAbort(false);
                        break;
                    }
                    if (this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled) continue;
                    this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                    this.job.log().message("Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnNetworkRequest: Cancelled-> Cancellation requested by user during network learn bus:" + bn);
                    }
                    this.ccnNetwork.setAbort(false);
                    break;
                }
                if (this.job != null) {
                    this.job.progress(100);
                }
            } else {
                throw new RuntimeException("Setup Valid Bus and Controller Range before starting Network Learn");
            }
            this.ccnNetwork.setDeviceLearnCount(this.discoveredDevices.size());
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnNetworkRequest: Closing out learn, result count = " + this.discoveredDevices.size());
            }
            if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation in process while assembling controller list");
                this.job.log().message("Cancelled-> Cancellation in process while assembling controller list");
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnNetworkRequest: Cancelled-> Cancellation in process while assembling controller list");
                }
                this.ccnNetwork.setAbort(false);
                return;
            }
            if (this.discoveredDevices.size() == 0) {
                this.ccnNetwork.setLearnStatus("Learn-> Assembling controller list, no controllers found");
                if (this.job != null) {
                    this.job.log().message("Learn-> Assembling controller list, no controllers found");
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Assembling controller list, no controllers found");
                }
                this.ccnNetwork.setDeviceLearnCount(0);
            } else {
                this.ccnNetwork.getLearnedDevices().removeAll();
                BCcnControllerEntry[] panelList = new BCcnControllerEntry[this.discoveredDevices.size()];
                this.discoveredDevices.copyInto((Object[])panelList);
                for (int iPanelCount = 0; iPanelCount < panelList.length; ++iPanelCount) {
                    this.addLearnedDevice(panelList[iPanelCount]);
                }
            }
        }
        catch (Exception e) {
            ccnMessageLog.error("Exception occurred during CcnLearnNetworkRequest", (Throwable)e);
        }
        finally {
            this.ccnNetwork.setLearnStatus("Learn-> Complete");
            if (this.job != null) {
                this.job.log().message("Learn-> Complete");
            }
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnNetworkRequest: Learn-> Complete");
            }
            this.ccnNetwork.setLearnStatus("Idle");
        }
    }

    private void interrogateDevice(int curBusNo, int curElemNo) {
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnNetworkRequest: Interrogate device at bus=" + curBusNo + " element=" + curElemNo + " abort=" + this.ccnNetwork.isAbort());
        }
        CcnReadTableRequest readTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, 32, 1, 1, 0, 0));
        CcnResponseMessage readTableResponse = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(readTableRequest);
        if (readTableResponse == null || readTableResponse.getResponseCommand() != 6) {
            return;
        }
        BCcnControllerEntry newEntry = new BCcnControllerEntry();
        try {
            newEntry.setDevName(CcnRspDevUtil.getDevName(readTableResponse).trim());
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnNetworkRequest: interrogateDevice found devName: " + newEntry.getDevName());
            }
        }
        catch (CcnException e) {
            ccnMessageLog.error("Exception occurred while setting CcnControllerEntry device name", (Throwable)((Object)e));
        }
        newEntry.setBusNo(curBusNo);
        newEntry.setElemNo(curElemNo);
        this.discoveredDevices.addElement(new BCcnControllerEntry(newEntry));
        this.ccnNetwork.setDeviceLearnCount(this.discoveredDevices.size());
    }

    private void updateBridgesList(int bridgeBus) {
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnNetworkRequest: Update bridges list at bus=" + bridgeBus + " abort=" + this.ccnNetwork.isAbort());
        }
        BCcnBridgesList vb = new BCcnBridgesList();
        Vector<BCcnBridgesEntry> v = new Vector<BCcnBridgesEntry>();
        boolean isAlreadyExisting = false;
        BCcnBridgesEntry[] knownBridges = (BCcnBridgesEntry[])this.ccnNetwork.getBridges().getChildren(BCcnBridgesEntry.class);
        if (knownBridges != null) {
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnNetworkRequest: Previous bridges count: " + knownBridges.length);
            }
            for (int j = 0; j < knownBridges.length; ++j) {
                if (knownBridges[j].getBridgeBus() != bridgeBus) continue;
                isAlreadyExisting = true;
                break;
            }
            if (!isAlreadyExisting) {
                v.addElement(new BCcnBridgesEntry(bridgeBus));
            }
        }
        BCcnBridgesEntry[] newBridges = new BCcnBridgesEntry[v.size()];
        v.copyInto((Object[])newBridges);
        for (int iBridgeCount = 0; iBridgeCount < newBridges.length; ++iBridgeCount) {
            this.addBridge(newBridges[iBridgeCount]);
        }
    }

    private boolean testForBridge(int bridgeBus) {
        block9: {
            CcnReadTableRequest readTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)bridgeBus, 0, null, 32, 1, 6, 0, 0));
            CcnResponseMessage readTableResponse = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(readTableRequest);
            if (readTableResponse != null && ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnNetworkRequest: testForBridge responseCommand: " + readTableResponse.getResponseCommand() + " responseBuffer: " + ByteArrayUtil.toHexString((byte[])readTableResponse.getResponseBuffer().getResponseData()));
            }
            if (readTableResponse == null || readTableResponse.getResponseCommand() != 6) {
                return false;
            }
            try {
                String picType = CcnRspDevUtil.getPICType(readTableResponse).trim();
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnNetworkRequest: testForBridge picType: " + picType);
                }
                if (!picType.startsWith("100")) break block9;
                if (picType.startsWith("100EN")) {
                    byte[] readObjectDataResponseBytes;
                    byte[] objName = "CCNENET\u0000".getBytes();
                    CcnReadObjectDataRequest readObjectDataRequest = new CcnReadObjectDataRequest(new CcnObjectDef((byte)bridgeBus, 0, objName, 9, 8, 1, 0, 0));
                    CcnResponseMessage readObjectDataResponse = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(readObjectDataRequest);
                    if (readObjectDataResponse != null && ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnNetworkRequest: testForBridge responseCommand: " + readObjectDataResponse.getResponseCommand() + " responseBuffer " + ByteArrayUtil.toHexString((byte[])readObjectDataResponse.getResponseBuffer().getResponseData()));
                    }
                    if (readObjectDataResponse != null && readObjectDataResponse.getResponseCommand() == 21) {
                        return true;
                    }
                    if (readObjectDataResponse != null && readObjectDataResponse.getResponseCommand() == 6 && (readObjectDataResponseBytes = readObjectDataResponse.getResponseBuffer().getResponseData())[0] == 1) {
                        return true;
                    }
                    break block9;
                }
                return true;
            }
            catch (CcnException e) {
                ccnMessageLog.error("Exception occurred during CcnLearnNetworkRequest test for bridge", (Throwable)((Object)e));
            }
        }
        return false;
    }

    void addLearnedDevice(BCcnControllerEntry panel) {
        boolean isDeviceAlreadyLearned = false;
        BCcnControllerEntry[] learnedDevices = (BCcnControllerEntry[])this.ccnNetwork.getLearnedDevices().getChildren(BCcnControllerEntry.class);
        if (panel.getBusNo() == 0 && this.ccnNetwork.isBridge(panel.getElemNo())) {
            panel.setDevType(2);
        } else {
            panel.setDevType(1);
        }
        for (int i = 0; i < learnedDevices.length; ++i) {
            if (!learnedDevices[i].getDevName().equalsIgnoreCase(panel.getDevName()) || learnedDevices[i].getBusNo() != panel.getBusNo() || learnedDevices[i].getElemNo() != panel.getElemNo()) continue;
            isDeviceAlreadyLearned = true;
            break;
        }
        if (!isDeviceAlreadyLearned) {
            this.ccnNetwork.getLearnedDevices().add(SlotPath.escape((String)(panel.getDevName().trim() + "_" + panel.getBusNo() + "_" + panel.getElemNo() + "_" + panel.getDevType())), (BValue)panel);
        }
    }

    void addBridge(BCcnBridgesEntry panel) {
        boolean isBridgeAddedAlready = false;
        BCcnBridgesEntry[] bridges = (BCcnBridgesEntry[])this.ccnNetwork.getBridges().getChildren(BCcnBridgesEntry.class);
        for (int i = 0; i < bridges.length; ++i) {
            if (bridges[i].getBridgeBus() != panel.getBridgeBus()) continue;
            isBridgeAddedAlready = true;
            break;
        }
        if (!isBridgeAddedAlready) {
            this.ccnNetwork.getBridges().add(SlotPath.escape((String)String.valueOf(panel.getBridgeBus())), (BValue)panel);
        }
    }
}

