/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.job.BCcnLearnFidPointsJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnFidTableWithTimeSchedule;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnFidPointsRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice ccnDevice;
    BCcnLearnFidPointsJob job;
    BCcnFidTable ccnTable;
    BCcnFidTableWithTimeSchedule ccnTableWTS;
    BCcnPointEntry[] pointEntries;
    private BFidPointConfig[] pointConfigs;
    String tts;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnLearnFidPointsRequest(BCcnFidTable ccnTable, BCcnDevice ccnDevice, BCcnLearnFidPointsJob job) {
        if (ccnTable instanceof BCcnFidTable) {
            this.ccnTable = ccnTable;
        }
        if (ccnTable instanceof BCcnFidTableWithTimeSchedule) {
            this.ccnTableWTS = (BCcnFidTableWithTimeSchedule)ccnTable;
        }
        this.ccnDevice = ccnDevice;
        this.job = job;
    }

    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnPoint.add");
        }
        int tableType = this.ccnTable.getTableType();
        int tableInstance = this.ccnTable.getTableInstance();
        String tableTypeString = this.ccnTable.getGroup().getTableGroupDescription();
        if (tableType == 1281) {
            Vector<BCcnPointEntry> fidPEsFound = new Vector<BCcnPointEntry>();
            Vector<BFidPointConfig> fidPCsFound = new Vector<BFidPointConfig>();
            for (int j = tableInstance; j < tableInstance + 64; ++j) {
                if (this.job != null) {
                    this.job.progress((100 * j + 1) / (tableInstance + 64));
                }
                CcnResponseMessage[] fidBlockResponses = new CcnResponseMessage[2];
                fidBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, j, 2, tableTypeString);
                if (fidBlockResponses == null) {
                    this.ccnMessageLog.trace("<CcnCreateTablesRequest: interrogateTableForPointData FID 0x501 unsuccessful... skipping data conversion bus|elem|tableType|instance " + this.ccnDevice.getBusNo() + "|" + this.ccnDevice.getElemNo() + "|" + Integer.toHexString(tableType) + "|" + j + " >");
                    continue;
                }
                this.pointEntries = new BCcnPointEntry[1];
                this.pointConfigs = new BFidPointConfig[1];
                CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, this.pointConfigs, tableType, fidBlockResponses, this.ccnTable, j);
                if (this.pointEntries[0] == null) continue;
                fidPEsFound.addElement(this.pointEntries[0]);
                fidPCsFound.addElement(this.pointConfigs[0]);
            }
            BCcnPointEntry[] newPointEntries = new BCcnPointEntry[fidPEsFound.size()];
            BFidPointConfig[] newPointConfigs = new BFidPointConfig[fidPCsFound.size()];
            fidPEsFound.copyInto((Object[])newPointEntries);
            fidPCsFound.copyInto((Object[])newPointConfigs);
            for (int iPointCount = 0; iPointCount < newPointEntries.length; ++iPointCount) {
                if (newPointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                this.addLearnedPoints(this.ccnTable, newPointEntries[iPointCount]);
            }
            for (int iFidCount = 0; iFidCount < newPointConfigs.length; ++iFidCount) {
                this.addLearnedFidConfigs(this.ccnTable, newPointConfigs[iFidCount]);
            }
            this.ccnTable.setPointLearnCount(newPointEntries.length);
        } else if (tableType == 1284 || tableType == 1283 || tableType == 1285) {
            CcnResponseMessage[] fidBlockResponses = new CcnResponseMessage[2];
            this.tts = Integer.toHexString(tableType);
            fidBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, 2, tableTypeString);
            if (fidBlockResponses != null) {
                if (tableType == 1284) {
                    this.pointEntries = new BCcnPointEntry[4];
                } else if (tableType == 1283) {
                    this.pointEntries = this.ccnTable.createDefaultTSConfigTable();
                } else if (tableType == 1285) {
                    this.pointEntries = this.ccnTable.createDefaultHolConfigTable();
                }
                CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, null, tableType, fidBlockResponses, this.ccnTable, tableInstance);
            }
            for (int iPointCount = 0; this.pointEntries != null && iPointCount < this.pointEntries.length; ++iPointCount) {
                if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                this.addLearnedPoints(this.ccnTable, this.pointEntries[iPointCount]);
            }
            if (tableType == 1283 && this.pointEntries != null) {
                BCcnTimeScheduleEntry[] tsList = CcnRspFidUtil.buildTimeSchedules(this.pointEntries);
                this.ccnTableWTS.getTimeScheduleList().setTimeScheduleList(tsList);
            }
        }
    }

    void addLearnedPoints(BCcnFidTable fidTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])fidTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock() || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready && panel != null) {
            fidTable.getPointList().add(SlotPath.escape((String)(panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    void addLearnedFidConfigs(BCcnFidTable fidTable, BFidPointConfig panel) {
        boolean isPointLearntAlready = false;
        BFidPointConfig[] learnedFIDs = (BFidPointConfig[])fidTable.getFidPointList().getChildren(BFidPointConfig.class);
        for (int i = 0; i < learnedFIDs.length; ++i) {
            if (learnedFIDs[i].getPointIndex() != panel.getPointIndex() || learnedFIDs[i].getDeviceType() != panel.getDeviceType() || learnedFIDs[i].getCtrlSensType() != panel.getCtrlSensType() || !learnedFIDs[i].getEUC().equalsIgnoreCase(panel.getEUC())) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready && panel != null) {
            fidTable.getFidPointList().add(SlotPath.escape((String)(panel.getEUC().trim() + "_" + panel.getPointIndex() + "_" + panel.getDeviceType() + "_" + panel.getCtrlSensType())), (BValue)new BFidPointConfig(panel.getPointIndex(), (byte)panel.getDeviceType(), (byte)panel.getCtrlSensType(), panel.getEUC()));
        }
    }

    public CcnResponseMessage[] interrogateTableForPointData(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlockCount, String tableTypeString) {
        int j;
        try {
            BCcnTableGroupTypeEnum tableGroupType = null;
            if (!this.ccnDevice.isDeviceFID()) {
                if (curTableType == 16) {
                    tableGroupType = BCcnTableGroupTypeEnum.UserConfiguration;
                } else if (curTableType == 17) {
                    tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
                } else if (curTableType == 19 || curTableType == 22) {
                    tableGroupType = BCcnTableGroupTypeEnum.ServiceConfiguration;
                } else if (curTableType == 23 || curTableType == 24) {
                    tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
                } else if (curTableType == 18 || curTableType == 21) {
                    tableGroupType = BCcnTableGroupTypeEnum.Maintenance;
                } else if (curTableType == 67) {
                    tableGroupType = BCcnTableGroupTypeEnum.AlarmHistory;
                } else if (curTableType == 20) {
                    if (this.ccnTable.getTableName().equalsIgnoreCase("SPSCHPOC")) {
                        tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
                    } else {
                        CcnResponseMessage tt14_rsp = this.getBlockDataFromTable(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), curTableType, curTableInstance, 6);
                        if (tt14_rsp != null) {
                            this.ccnMessageLog.trace("<CcnCreateTablesRequest: test for 0x14... responseCommand: " + tt14_rsp.getResponseCommand() + "\nresponseBuffer: " + new String(tt14_rsp.getResponseBuffer().getResponseData()));
                        }
                        if (tt14_rsp == null || tt14_rsp.getResponseCommand() != 6) {
                            return null;
                        }
                        int dataTableType = CcnRspPocUtil.getDataTableType(tt14_rsp);
                        tableGroupType = dataTableType == 1556 ? BCcnTableGroupTypeEnum.TimeSchedules : BCcnTableGroupTypeEnum.UserConfiguration;
                    }
                }
            } else if (curTableType == 1281) {
                tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
            } else if (curTableType == 1283) {
                tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
            } else if (curTableType == 1284) {
                tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
            } else if (curTableType == 1285) {
                tableGroupType = BCcnTableGroupTypeEnum.Holiday;
            }
            if (tableGroupType != null && !tableGroupType.getTag().equalsIgnoreCase(tableTypeString)) {
                return null;
            }
        }
        catch (Exception tableGroupType) {
            // empty catch block
        }
        CcnResponseMessage[] curBlockResponses = new CcnResponseMessage[curBlockCount];
        if (!this.ccnDevice.isDeviceFID()) {
            for (j = 2; j <= curBlockCount; ++j) {
                if ((20 <= curTableType && curTableType <= 22 || curTableType == 24) && (j == 5 || j == 9)) continue;
                this.ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
            }
        } else {
            for (j = 1; j <= curBlockCount; ++j) {
                if (j == 1 && curTableType != 1281) continue;
                this.ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
                if (curBlockResponses[j - 1] != null) continue;
                return null;
            }
        }
        return curBlockResponses;
    }

    private CcnResponseMessage getBlockDataFromTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = new CcnResponseMessage();
        BCcnNetwork ccnNetwork = this.ccnDevice.getCcnNetwork();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            this.ccnMessageLog.trace("\n****  createTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnMessageLog.error("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }
}

