/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDataPointsJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnUtil;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnDataPointsRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnDataTable ccnDataTable;
    private BCcnDataTableWithTimeSchedule ccnDataTableWTS;
    private BCcnPocTable ccnPocTable;
    private BCcnPointEntry[] pointEntries;
    private BCcnPointEntry pointEntry;
    private final BCcnDevice ccnDevice;
    private final BCcnLearnDataPointsJob job;
    private static final Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnLearnDataPointsRequest(BCcnDevice device, BCcnDataTable dataTable, BCcnLearnDataPointsJob learnJob) {
        if (dataTable instanceof BCcnDataTable) {
            this.ccnDataTable = dataTable;
            this.ccnPocTable = this.ccnDataTable.getParentPoc();
        }
        if (dataTable instanceof BCcnDataTableWithTimeSchedule) {
            this.ccnDataTableWTS = (BCcnDataTableWithTimeSchedule)dataTable;
            this.ccnPocTable = this.ccnDataTableWTS.getParentPoc();
        }
        this.ccnDevice = device;
        this.job = learnJob;
    }

    @Override
    public void execute() {
        int dataTableStrBlock;
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnPoint.add");
        }
        int dataTableInstance = this.ccnDataTable.getTableInstance();
        int dataTableEndBlock = dataTableStrBlock = this.ccnDataTable.getDataBlock();
        int dataTableType = this.ccnDataTable.getTableType();
        int dataTableTypeAtPoc = this.ccnPocTable.getDataTableType();
        int pocTableType = this.ccnPocTable.getTableType();
        if (dataTableStrBlock == 255) {
            dataTableStrBlock = this.ccnPocTable.getDataTableStartBlock();
            dataTableEndBlock = this.ccnPocTable.getDataTableEndBlock();
        }
        for (int jCount = dataTableStrBlock; jCount <= dataTableEndBlock; ++jCount) {
            int iPointCount;
            CcnResponseMessage dataBlockResponse;
            int dataTableBlock = jCount;
            if (this.job != null) {
                this.job.progress((100 * jCount + 1) / (dataTableEndBlock + 1));
            }
            if (dataTableType != 1556 || dataTableBlock != 2) {
                dataBlockResponse = new CcnResponseMessage();
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDataPointsRequest: interrogateDataTableForPointData: bus | elem | tt | ti | blk: " + this.ccnDevice.getBusNo() + " | " + this.ccnDevice.getElemNo() + " | " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + dataTableBlock);
                }
                if (dataTableType == dataTableTypeAtPoc && pocTableType == this.ccnDataTable.getPocTableType()) {
                    dataBlockResponse = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, dataTableType, dataTableInstance, dataTableBlock);
                }
                if (dataBlockResponse == null) continue;
                this.pointEntries = new BCcnPointEntry[this.ccnPocTable.getPointLearnCount()];
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDataPointsRequest: convertBlockDataToDataTableData: tt | ti | pts | len: " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + this.pointEntries.length + " | " + dataBlockResponse.getBlockLen());
                }
                if (dataTableType == dataTableTypeAtPoc && pocTableType == this.ccnDataTable.getPocTableType()) {
                    this.convertBlockDataToDataTableData(dataTableType, dataBlockResponse, dataTableBlock);
                }
                for (iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                    if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                    this.addLearnedPoints(this.ccnDataTable, this.pointEntries[iPointCount]);
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDataPointsRequest: setPointLearnCount " + this.pointEntries.length);
                }
                this.ccnDataTable.setPointLearnCount(this.pointEntries.length);
                continue;
            }
            dataBlockResponse = new CcnResponseMessage();
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDataPointsRequest: interrogateDataTableForPointData: bus | elem | tt | ti | blk: " + this.ccnDevice.getBusNo() + " | " + this.ccnDevice.getElemNo() + " | " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + dataTableBlock);
            }
            if (dataTableType == dataTableTypeAtPoc && pocTableType == this.ccnDataTableWTS.getPocTableType()) {
                dataBlockResponse = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, dataTableType, dataTableInstance, dataTableBlock);
            }
            if (dataBlockResponse == null) continue;
            this.pointEntries = new BCcnPointEntry[this.ccnPocTable.getPointLearnCount()];
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDataPointsRequest: convertBlockDataToDataTableData: tt | ti | pts | len: " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + this.pointEntries.length + " | " + dataBlockResponse.getBlockLen());
            }
            if (dataTableType == dataTableTypeAtPoc && pocTableType == this.ccnDataTableWTS.getPocTableType()) {
                this.convertBlockDataToDataTableData(dataTableType, dataBlockResponse, dataTableBlock);
            }
            for (iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                this.addLearnedPointsToDataTableTimeSchedule(this.ccnDataTableWTS, this.pointEntries[iPointCount]);
            }
            BCcnTimeScheduleEntry[] tsList = CcnRspDataUtil.buildTimeSchedules(this.pointEntries);
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDataPointsRequest: setTimeScheduleList " + tsList.length);
            }
            this.ccnDataTableWTS.getTimeScheduleList().setTimeScheduleList(tsList);
        }
    }

    void addTimeScheduleList(BCcnDataTableWithTimeSchedule ccnTableWTS, BCcnTimeScheduleEntry panel) {
        boolean isScheduleLearntAlready = false;
        BCcnTimeScheduleEntry[] learnedPoints = (BCcnTimeScheduleEntry[])ccnTableWTS.getLearnedTimeSchedules().getChildren(BCcnTimeScheduleEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getPeriodNo().equalsIgnoreCase(panel.getPeriodNo())) continue;
            isScheduleLearntAlready = true;
            break;
        }
        if (!isScheduleLearntAlready) {
            ccnTableWTS.getLearnedTimeSchedules().add(SlotPath.escape((String)panel.getPeriodNo()), (BValue)panel);
        }
    }

    void addLearnedPointsToDataTableTimeSchedule(BCcnDataTableWithTimeSchedule ccnTableWTS, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])ccnTableWTS.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready) {
            ccnTableWTS.getPointList().add(SlotPath.escape((String)(panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)panel);
        }
    }

    void addLearnedPoints(BCcnDataTable dataTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])dataTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock() || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready && panel != null) {
            String strPtEntry = SlotPath.escape((String)(panel.getFieldIndex() + panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset()));
            if (dataTable.getPointList().get(strPtEntry) != null) {
                dataTable.getPointList().remove(strPtEntry);
            }
            dataTable.getPointList().add(strPtEntry, (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    private void convertBlockDataToDataTableData(int tableType, CcnResponseMessage dataBlockResponse, int dataBlock) {
        int tableFieldCount = this.pointEntries.length;
        int dataBlock_FieldIndex = 0;
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDataPointsRequest: convertBlockDataToDataTableData: tt | cnt: " + Integer.toHexString(tableType) + " | " + tableFieldCount);
        }
        BCcnPointEntry[] pointMasters = (BCcnPointEntry[])this.ccnPocTable.getLearnedSplPoints().getChildren(BCcnPointEntry.class);
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDataPointsRequest: convertBlockDataToDataTableData point entries length: " + tableFieldCount + " master entries length: " + pointMasters.length);
        }
        int highestCommonIndex = Math.min(tableFieldCount, pointMasters.length);
        for (int i = 0; i < highestCommonIndex; ++i) {
            this.pointEntry = new BCcnPointEntry(pointMasters[i]);
            this.pointEntry.setValueBlock((byte)dataBlock);
            int newIndex = CcnLearnDataPointsRequest.getDataBlockData(tableType, tableFieldCount, this.pointEntry, dataBlockResponse, dataBlock_FieldIndex);
            if (newIndex == -1) break;
            dataBlock_FieldIndex = newIndex;
            this.pointEntries[i] = this.pointEntry;
        }
    }

    private static int getDataBlockData(int tableType, int fieldIndex, BCcnPointEntry entry, CcnResponseMessage response, int index) {
        if (response == null || response.getResponseCommand() != 6) {
            return -1;
        }
        int len = response.getBlockLen() - 3;
        int dataLength = entry.getFieldByteCount();
        if (index + dataLength <= len) {
            try {
                entry.setPointValue(CcnRspDataUtil.getValue(response, index, entry));
                entry.setValueBlockOffset(index);
            }
            catch (CcnException e) {
                ccnMessageLog.error("Exception occurred while updating BCcnPointEntry " + (Object)((Object)entry), (Throwable)((Object)e));
            }
            return index += dataLength;
        }
        return -1;
    }
}

