/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnFetchDeviceDataRequest
implements CcnMessageConst,
AsynchronousRequest {
    BCcnDevice dev;
    BCcnNetwork network;
    int controllerNum;
    int busNum;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnFetchDeviceDataRequest(BCcnDevice newDevice, BCcnNetwork newNetwork) {
        this(newDevice, newNetwork, newDevice.getElemNo(), newDevice.getBusNo());
    }

    public CcnFetchDeviceDataRequest(BCcnDevice newDevice, BCcnNetwork newNetwork, int newControllerNum, int newBusNum) {
        this.dev = newDevice;
        this.network = newNetwork;
        this.controllerNum = newControllerNum;
        this.busNum = newBusNum;
    }

    public void fetchBlock3() throws CcnException {
        CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 3, 0, 0));
        CcnResponseMessage rsp = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp == null) {
            throw new CcnException(6488177);
        }
        if (rsp.getResponseCommand() == 21) {
            return;
        }
        if (rsp.getResponseCommand() == 6) {
            try {
                this.dev.setPrimaryBaudRate(BCcnBaudRateEnum.make(CcnRspDevUtil.getPrimaryBaudRate(rsp)));
                this.dev.setSecondaryBaudRate(BCcnBaudRateEnum.make(CcnRspDevUtil.getSecondaryBaudRate(rsp)));
            }
            catch (CcnException e) {
                this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock3: ERROR: " + (Object)((Object)e));
            }
        }
    }

    public void fetchBlock4() throws CcnException {
        CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 4, 0, 0));
        CcnResponseMessage rsp = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp == null || rsp.getResponseCommand() != 6) {
            throw new CcnException(6488177);
        }
        try {
            this.dev.setDeviceDescription(CcnRspDevUtil.getDevDesc(rsp).trim());
            this.dev.setLocation(CcnRspDevUtil.getLocDesc(rsp).trim());
            this.dev.setPartNo(CcnRspDevUtil.getSwPartNum(rsp).trim());
            this.dev.setModelNo(CcnRspDevUtil.getModelNum(rsp).trim());
            this.dev.setSerialNo(CcnRspDevUtil.getSerialNum(rsp).trim());
            this.dev.setReferenceNo(CcnRspDevUtil.getReferenceNum(rsp).trim());
        }
        catch (CcnException e) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock4: ERROR: " + (Object)((Object)e));
        }
    }

    public void fetchBlock6() throws CcnException {
        CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, 32, 1, 6, 0, 0));
        CcnResponseMessage rsp = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp == null || rsp.getResponseCommand() != 6) {
            throw new CcnException(6488177);
        }
        try {
            this.dev.setPlatformNo(CcnRspDevUtil.getPlatformId(rsp).trim());
            this.dev.setOsVersion(CcnRspDevUtil.getPICExecSWVerNum(rsp).trim());
            this.dev.setPicType(CcnRspDevUtil.getPICType(rsp).trim());
            if (!CcnRspDevUtil.getPICType(rsp).equalsIgnoreCase("203UC") && !CcnRspDevUtil.getPICType(rsp).equalsIgnoreCase("201X")) {
                this.ccnMessageLog.trace("<CcnFetchDeviceDataRequest: PICApplSwVerNum: " + CcnRspDevUtil.getPICApplSwVerNum(rsp));
                this.dev.setApplicationVersion(CcnRspDevUtil.getPICApplSwVerNum(rsp).trim());
            }
            if (this.dev.isDeviceFID()) {
                this.dev.setFlags(this.dev.getSlot("userConfiguration"), 4);
                this.dev.setFlags(this.dev.getSlot("maintenance"), 4);
                this.dev.setFlags(this.dev.getSlot("serviceConfiguration"), 4);
                this.dev.setFlags(this.dev.getSlot("alarmHistory"), 4);
            }
        }
        catch (CcnException e) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest, fetchBlock6: ERROR: " + (Object)((Object)e));
        }
    }

    @Override
    public void execute() {
        if (!this.dev.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnDevice.Fetch");
        }
        try {
            this.fetchBlock3();
            this.fetchBlock4();
            this.fetchBlock6();
        }
        catch (Exception t) {
            this.ccnMessageLog.error("<CcnFetchDeviceDataRequest: ERROR: " + t);
            t.printStackTrace();
        }
    }
}

