/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.job.BCcnAddTablesJob;
import com.tridium.ccn.messages.CcnCreateDataTablesRequest;
import com.tridium.ccn.messages.CcnCreatePointsRequest;
import com.tridium.ccn.messages.CcnLearnPocTableRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnFidTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

public class CcnCreateTablesRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnNetwork ccnNetwork;
    private BCcnDevice ccnDevice;
    private BCcnTableList ccnTableList;
    private BCcnTable refreshedTable;
    private String function;
    private BCcnPicTable picTable = null;
    private BCcnPocTable pocTable = null;
    private BCcnAHTable ahTable = null;
    private Vector<BCcnFidTable> fidTablesAdded = null;
    private BCcnFidTable fidTable = null;
    private BCcnFidTableWithTimeSchedule fidTableWTS = null;
    private BCcnPointEntry[] pointEntries;
    private BFidPointConfig[] pointConfigs;
    private BCcnAddTablesJob job;
    private boolean refresh;
    private boolean upload;
    boolean isNewPOD = false;
    boolean isNewTable = false;
    boolean isNewTableGroup = false;
    boolean isPODExist;
    BFolder objPODFolder;
    Vector<BCcnPicTable> picTablesAdded;
    Vector<BCcnPocTable> pocTablesAdded;
    String tts;
    int dataTableType;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnCreateTablesRequest(BCcnNetwork netWork, BCcnDevice device, BCcnTableList tableList, BCcnAddTablesJob job) {
        this.ccnNetwork = netWork;
        this.ccnDevice = device;
        this.ccnTableList = tableList;
        this.refresh = false;
        this.upload = false;
        this.refreshedTable = null;
        this.job = job;
    }

    public CcnCreateTablesRequest(BCcnDevice device, BCcnTableList tableList, BCcnTable refreshedTable, boolean refresh, boolean upload) {
        this.ccnTableList = tableList;
        this.ccnDevice = device;
        this.ccnNetwork = device.getCcnNetwork();
        this.refreshedTable = refreshedTable;
        this.refresh = refresh;
        this.function = refresh ? "Refresh" : "Create";
        this.upload = upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnCreateTable.add");
        }
        boolean curOverwriteState = false;
        if (this.refreshedTable != null || this.upload) {
            curOverwriteState = this.refreshedTable.getCcnDevice().getOverWriteEnabled();
            this.refreshedTable.getCcnDevice().setOverWriteEnabled(true);
        }
        try {
            int blockCount;
            String tableName;
            int tableInstance;
            BCcnTableEntry table;
            int i;
            BCcnTableEntry[] tables = this.ccnTableList.getTableList();
            if (!this.ccnDevice.isDeviceFID()) {
                this.picTablesAdded = new Vector();
                this.pocTablesAdded = new Vector();
                for (i = 0; i < tables.length; ++i) {
                    table = tables[i];
                    if (!this.upload && !this.ccnDevice.isDsCcnTableEntryLicensed(table)) {
                        String tempLearnString = "-> Table " + table.getTableName() + " Skipped ... not licensed";
                        this.ccnDevice.setLearnStatus(tempLearnString);
                        continue;
                    }
                    int tableType = table.getTableType();
                    tableInstance = table.getTableInstance();
                    if (this.job != null) {
                        this.job.progress((100 * i + 1) / (tables.length + 1));
                    }
                    if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                        this.job.setJobState(BJobState.canceled);
                        break;
                    }
                    BCcnTableGroupTypeEnum tableGroupType = null;
                    BCcnTableGroup tableGroupFolder = null;
                    if (tableType == 16) {
                        tableGroupType = BCcnTableGroupTypeEnum.UserConfiguration;
                    } else if (tableType == 17) {
                        tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
                    } else if (tableType == 19 || tableType == 22) {
                        tableGroupType = BCcnTableGroupTypeEnum.ServiceConfiguration;
                    } else if (tableType == 23 || tableType == 24) {
                        tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
                    } else if (tableType == 18 || tableType == 21) {
                        tableGroupType = BCcnTableGroupTypeEnum.Maintenance;
                    } else if (tableType == 67) {
                        tableGroupType = BCcnTableGroupTypeEnum.AlarmHistory;
                    } else {
                        if (tableType != 20) continue;
                        if (table.getTableName().equalsIgnoreCase("SPSCHPOC")) {
                            tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
                        } else {
                            CcnResponseMessage tt14_rsp = this.getBlockDataFromTable(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, 6);
                            if (tt14_rsp != null) {
                                this.ccnMessageLog.trace("<CcnCreateTablesRequest: test for 0x14... responseCommand: " + tt14_rsp.getResponseCommand() + "\nresponseBuffer: " + new String(tt14_rsp.getResponseBuffer().getResponseData()));
                            }
                            if (tt14_rsp == null || tt14_rsp.getResponseCommand() != 6) continue;
                            this.dataTableType = CcnRspPocUtil.getDataTableType(tt14_rsp);
                            tableGroupType = this.dataTableType == 1556 ? BCcnTableGroupTypeEnum.TimeSchedules : BCcnTableGroupTypeEnum.UserConfiguration;
                        }
                    }
                    this.isNewTableGroup = false;
                    tableGroupFolder = CcnUtil.findCcnTableGroup((BComponent)this.ccnDevice.getPoints(), tableGroupType);
                    if (tableGroupFolder == null) {
                        this.isNewTableGroup = true;
                        tableGroupFolder = new BCcnTableGroup();
                        this.ccnDevice.getPoints().add(tableGroupType.getTag(), (BValue)tableGroupFolder);
                        tableGroupFolder.setTableGroup(tableGroupType);
                    }
                    tableName = table.getTableName().trim();
                    blockCount = table.getBlockCount();
                    this.isNewTable = false;
                    BCcnTable existingTable = null;
                    existingTable = CcnUtil.findCcnTable((BComponent)tableGroupFolder, table);
                    if (16 <= tableType && tableType <= 19 || tableType == 23) {
                        if (existingTable == null) {
                            this.isNewTable = true;
                            this.picTable = new BCcnPicTable(table);
                            if (tableName.length() == 0) {
                                tableName = "T";
                            }
                            if (!Character.isLetter(tableName.charAt(0))) {
                                tableName = "T_" + tableName;
                            }
                            tableName = CcnUtil.makeValidName(tableName);
                            tableGroupFolder.add(tableName, (BValue)this.picTable);
                            this.ccnDevice.setTableCreateCount(this.ccnDevice.getTableCreateCount() + 1);
                        } else {
                            this.picTable = (BCcnPicTable)existingTable;
                        }
                        if (!this.ccnDevice.getOverWriteEnabled() && !this.isNewTable) continue;
                        this.picTablesAdded.addElement(this.picTable);
                        this.picTable.setPreMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.picTable.setCurMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.picTable.setTableType(table.getTableType());
                        this.picTable.setTableTypeString(this.picTable.getGroup().getTableGroupDescription());
                        this.picTable.setTableInstance(table.getTableInstance());
                        this.picTable.setTableNum(table.getTableNum());
                        this.picTable.setTableName(table.getTableName().trim());
                        this.picTable.setTableBlockCount(table.getBlockCount());
                        this.picTable.setPointLearnCount(table.getPointCount());
                        CcnResponseMessage[] picBlockResponses = new CcnResponseMessage[blockCount];
                        picBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, blockCount);
                        this.pointEntries = null;
                        this.pointEntries = new BCcnPointEntry[this.picTable.getPointLearnCount()];
                        CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, null, tableType, picBlockResponses, this.picTable, 0);
                        for (int iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                            if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                            this.addLearnedPoints(this.picTable, this.pointEntries[iPointCount]);
                        }
                        this.picTable.setPointLearnCount(this.pointEntries.length);
                        continue;
                    }
                    if (20 <= tableType && tableType <= 22 || tableType == 24) {
                        if (existingTable == null) {
                            this.isNewTable = true;
                            this.pocTable = new BCcnPocTable(table);
                            if (tableName.length() == 0) {
                                tableName = "T";
                            }
                            if (!Character.isLetter(tableName.charAt(0))) {
                                tableName = "T_" + tableName;
                            }
                            tableName = CcnUtil.makeValidName(tableName);
                            tableGroupFolder.add(tableName, (BValue)this.pocTable);
                            this.ccnDevice.setTableCreateCount(this.ccnDevice.getTableCreateCount() + 1);
                        } else {
                            this.pocTable = (BCcnPocTable)existingTable;
                        }
                        if (!this.isNewTable && !this.ccnDevice.getOverWriteEnabled()) continue;
                        this.pocTablesAdded.addElement(this.pocTable);
                        this.pocTable.setPreMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.pocTable.setCurMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.pocTable.setTableType(table.getTableType());
                        this.pocTable.setTableTypeString(this.pocTable.getGroup().getTableGroupDescription());
                        this.pocTable.setTableInstance(table.getTableInstance());
                        int tableNum = table.getTableNum();
                        this.pocTable.setTableNum(table.getTableNum());
                        this.pocTable.setTableName(table.getTableName().trim());
                        this.pocTable.setTableBlockCount(table.getBlockCount());
                        this.pocTable.setPointLearnCount(table.getPointCount());
                        CcnResponseMessage[] pocBlockResponses = new CcnResponseMessage[blockCount];
                        if (tableType == 20 && tableName.equals("SPSCHPOC") && tableNum == 0) {
                            BCcnPointEntry[] specialPocPointList = this.pocTable.createDefaultTSConfigTable();
                            for (int iSplPtCount = 0; iSplPtCount < specialPocPointList.length; ++iSplPtCount) {
                                this.addSpecialPointsList(this.pocTable, specialPocPointList[iSplPtCount]);
                            }
                            this.pocTable.setDataTableBlock(2);
                            this.pocTable.setDataTableType(1556);
                            continue;
                        }
                        pocBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, blockCount);
                        this.pointEntries = new BCcnPointEntry[this.pocTable.getPointLearnCount()];
                        CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, null, tableType, pocBlockResponses, this.pocTable, 0);
                        for (int iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                            this.addSpecialPointsList(this.pocTable, this.pointEntries[iPointCount]);
                        }
                        this.pocTable.setPointLearnCount(this.pointEntries.length);
                        continue;
                    }
                    if (67 != tableType) continue;
                    if (existingTable == null) {
                        this.isNewTable = true;
                        this.ahTable = new BCcnAHTable(table);
                        tableGroupFolder.add(tableName, (BValue)this.ahTable);
                        this.ccnDevice.setTableCreateCount(this.ccnDevice.getTableCreateCount() + 1);
                    } else {
                        this.ahTable = (BCcnAHTable)existingTable;
                    }
                    if (!this.isNewTable && !this.ccnDevice.getOverWriteEnabled()) continue;
                    this.ahTable.setPreMetricDisplay(this.ccnNetwork.getDisplayMetric());
                    this.ahTable.setCurMetricDisplay(this.ccnNetwork.getDisplayMetric());
                    this.ahTable.setTableType(table.getTableType());
                    this.ahTable.setTableTypeString(this.ahTable.getGroup().getTableGroupDescription());
                    this.ahTable.setTableInstance(table.getTableInstance());
                    this.ahTable.setTableNum(table.getTableNum());
                    this.ahTable.setTableName(table.getTableName().trim());
                    this.ahTable.setTableBlockCount(table.getBlockCount());
                }
            } else {
                this.fidTablesAdded = new Vector();
                for (i = 0; i < tables.length; ++i) {
                    CcnResponseMessage[] fidBlockResponses;
                    table = tables[i];
                    int tableType = table.getTableType();
                    tableInstance = table.getTableInstance();
                    if (this.job != null) {
                        this.job.progress((100 * i + 1) / (tables.length + 1));
                    }
                    if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                        this.job.setJobState(BJobState.canceled);
                        break;
                    }
                    BCcnTableGroup tableGroupFolder = null;
                    BCcnTableGroupTypeEnum tableGroupType = null;
                    if (tableType == 1281) {
                        tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
                    } else if (tableType == 1283) {
                        tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
                    } else if (tableType == 1284) {
                        tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
                    } else {
                        if (tableType != 1285) continue;
                        tableGroupType = BCcnTableGroupTypeEnum.Holiday;
                    }
                    tableGroupFolder = this.findCcnTableGroup((BComponent)this.ccnDevice.getPoints(), tableGroupType);
                    this.isNewTableGroup = false;
                    if (tableGroupFolder == null) {
                        this.isNewTableGroup = true;
                        tableGroupFolder = new BCcnTableGroup();
                        this.ccnDevice.getPoints().add(tableGroupType.getTag(), (BValue)tableGroupFolder);
                        tableGroupFolder.setTableGroup(tableGroupType);
                    }
                    tableName = table.getTableName().trim();
                    blockCount = table.getBlockCount();
                    this.ccnDevice.setLearnStatus("Create-> Create table... name = " + tableName);
                    boolean isNewTable = false;
                    BCcnTable existingTable = null;
                    existingTable = CcnUtil.findCcnTable((BComponent)tableGroupFolder, table);
                    if (1281 > tableType || tableType > 1285) continue;
                    if (existingTable == null) {
                        isNewTable = true;
                        if (tableType != 1283) {
                            this.fidTable = new BCcnFidTable(table);
                            tableGroupFolder.add(tableName, (BValue)this.fidTable);
                        } else {
                            this.fidTableWTS = new BCcnFidTableWithTimeSchedule(table);
                            this.fidTable = this.fidTableWTS;
                            tableGroupFolder.add(tableName, (BValue)this.fidTable);
                        }
                        this.fidTablesAdded.addElement(this.fidTable);
                        this.ccnDevice.setTableCreateCount(this.ccnDevice.getTableCreateCount() + 1);
                    } else if (tableType != 1283) {
                        this.fidTable = (BCcnFidTable)existingTable;
                    } else {
                        this.fidTableWTS = (BCcnFidTableWithTimeSchedule)existingTable;
                        this.fidTable = this.fidTableWTS;
                    }
                    if (!isNewTable && !this.ccnDevice.getOverWriteEnabled()) continue;
                    this.fidTable.setPreMetricDisplay(this.ccnNetwork.getDisplayMetric());
                    this.fidTable.setCurMetricDisplay(this.ccnNetwork.getDisplayMetric());
                    this.fidTable.setTableType(table.getTableType());
                    this.fidTable.setTableTypeString(this.fidTable.getGroup().getTableGroupDescription());
                    this.fidTable.setTableInstance(table.getTableInstance());
                    this.fidTable.setTableNum(table.getTableNum());
                    this.fidTable.setTableName(table.getTableName().trim());
                    this.fidTable.setTableBlockCount(blockCount);
                    this.fidTable.setPointLearnCount(table.getPointCount());
                    if (tableType == 1281) {
                        Vector<BCcnPointEntry> fidPEsFound = new Vector<BCcnPointEntry>();
                        Vector<BFidPointConfig> fidPCsFound = new Vector<BFidPointConfig>();
                        for (int j = tableInstance; j < tableInstance + 64; ++j) {
                            fidBlockResponses = new CcnResponseMessage[2];
                            fidBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, j, 2);
                            if (fidBlockResponses == null) {
                                this.ccnMessageLog.trace("<CcnCreateTablesRequest: interrogateTableForPointData FID 0x501 unsuccessful... skipping data conversion bus|elem|tableType|instance " + this.ccnDevice.getBusNo() + "|" + this.ccnDevice.getElemNo() + "|" + Integer.toHexString(tableType) + "|" + j + " >");
                                continue;
                            }
                            this.pointEntries = new BCcnPointEntry[1];
                            this.pointConfigs = new BFidPointConfig[1];
                            CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, this.pointConfigs, tableType, fidBlockResponses, this.fidTable, j);
                            if (this.pointEntries[0] == null) continue;
                            fidPEsFound.addElement(this.pointEntries[0]);
                            fidPCsFound.addElement(this.pointConfigs[0]);
                        }
                        BCcnPointEntry[] newPointEntries = new BCcnPointEntry[fidPEsFound.size()];
                        BFidPointConfig[] newPointConfigs = new BFidPointConfig[fidPCsFound.size()];
                        fidPEsFound.copyInto((Object[])newPointEntries);
                        fidPCsFound.copyInto((Object[])newPointConfigs);
                        for (int iPointCount = 0; iPointCount < newPointEntries.length; ++iPointCount) {
                            if (newPointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                            this.addLearnedFIDPoints(this.fidTable, newPointEntries[iPointCount]);
                        }
                        for (int iFidCount = 0; iFidCount < newPointConfigs.length; ++iFidCount) {
                            this.addLearnedFidConfigs(this.fidTable, newPointConfigs[iFidCount]);
                        }
                        this.fidTable.setPointLearnCount(newPointEntries.length);
                        continue;
                    }
                    if (tableType != 1284 && tableType != 1283 && tableType != 1285) continue;
                    fidBlockResponses = new CcnResponseMessage[2];
                    this.tts = Integer.toHexString(tableType);
                    fidBlockResponses = this.interrogateTableForPointData(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, 2);
                    if (tableType == 1284) {
                        this.pointEntries = new BCcnPointEntry[4];
                    } else if (tableType == 1283) {
                        this.pointEntries = this.fidTable.createDefaultTSConfigTable();
                    } else {
                        if (tableType != 1285) continue;
                        this.pointEntries = this.fidTable.createDefaultHolConfigTable();
                    }
                    CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, null, tableType, fidBlockResponses, this.fidTable, tableInstance);
                    for (int iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                        if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                        this.addLearnedFIDPoints(this.fidTable, this.pointEntries[iPointCount]);
                    }
                    if (tableType == 1283) {
                        BCcnTimeScheduleEntry[] timeScheduleEntries = CcnRspFidUtil.buildTimeSchedules(this.pointEntries);
                        this.fidTableWTS.getTimeScheduleList().setTimeScheduleList(timeScheduleEntries);
                    }
                    this.fidTable.setPointLearnCount(this.pointEntries.length);
                }
            }
            if (this.ccnDevice.getCcnNetwork().getCreateTables() && !this.refresh && !this.upload && this.pocTablesAdded != null && this.pocTablesAdded.size() > 0) {
                BCcnPocTable[] newPocTables = new BCcnPocTable[this.pocTablesAdded.size()];
                this.pocTablesAdded.copyInto((Object[])newPocTables);
                for (int j = 0; j < newPocTables.length; ++j) {
                    BCcnPocTable newPocTable = newPocTables[j];
                    CcnLearnPocTableRequest lreq = new CcnLearnPocTableRequest(newPocTable);
                    lreq.execute();
                    BCcnTableEntry[] learnedDataTableEntries = (BCcnTableEntry[])newPocTable.getLearnedDataTables().getChildren(BCcnTableEntry.class);
                    CcnCreateDataTablesRequest dtReq = new CcnCreateDataTablesRequest(newPocTable, learnedDataTableEntries, null);
                    dtReq.execute();
                }
            }
            if (this.ccnDevice.getCcnNetwork().getAutoCreatePoints() && !this.refresh && !this.upload) {
                CcnCreatePointsRequest req;
                BCcnPointEntry[] pointList;
                if (this.picTablesAdded != null && this.picTablesAdded.size() > 0) {
                    BCcnPicTable[] newPicTables = new BCcnPicTable[this.picTablesAdded.size()];
                    this.picTablesAdded.copyInto((Object[])newPicTables);
                    for (int k = 0; k < newPicTables.length; ++k) {
                        BCcnPicTable newPicTable = newPicTables[k];
                        int newPicTableType = newPicTable.getTableType();
                        if (newPicTableType != 17) continue;
                        pointList = (BCcnPointEntry[])newPicTable.getPointList().getChildren(BCcnPointEntry.class);
                        req = new CcnCreatePointsRequest(newPicTable, pointList, null);
                        req.execute();
                    }
                    this.ccnMessageLog.trace("<CcnCreateTablesRequest: pic table autoCreatePoints extra processing complete \n");
                }
                if (this.fidTablesAdded != null && this.fidTablesAdded.size() > 0) {
                    BCcnFidTable[] newFidTables = new BCcnFidTable[this.fidTablesAdded.size()];
                    this.fidTablesAdded.copyInto((Object[])newFidTables);
                    for (int k = 0; k < newFidTables.length; ++k) {
                        BCcnFidTable newFidTable = newFidTables[k];
                        int newFidTableType = newFidTable.getTableType();
                        if (newFidTableType != 1281) continue;
                        pointList = (BCcnPointEntry[])newFidTable.getPointList().getChildren(BCcnPointEntry.class);
                        req = new CcnCreatePointsRequest(newFidTable, pointList, null);
                        req.execute();
                    }
                    this.ccnMessageLog.trace("<CcnCreateTablesRequest: fid table autoCreatePoints extra processing complete \n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.refreshedTable != null || this.upload) {
                this.refreshedTable.getCcnDevice().setOverWriteEnabled(curOverwriteState);
            }
            if (!this.upload) {
                this.ccnDevice.setLearnStatus("" + this.function + "-> Complete");
                this.ccnDevice.setLearnStatus("Idle");
            }
            this.ccnMessageLog.trace("<CcnCreateTablesRequest: finally processing complete \n");
        }
        if (this.refresh && this.refreshedTable != null) {
            this.ccnMessageLog.trace("<CcnCreateTablesRequest: updateCreatedPoints processing starting \n");
            if (this.refreshedTable instanceof BCcnPicTable || this.refreshedTable instanceof BCcnFidTable) {
                this.updateCreatedPoints(this.refreshedTable);
            }
        }
    }

    private BCcnTableGroup findCcnTableGroup(BComponent _dev, BCcnTableGroupTypeEnum _groupType) {
        BCcnTableGroup tg1 = null;
        BComponent[] childrenHandles = _dev.getChildComponents();
        boolean isTableGroupExisted = false;
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (!(nextChild instanceof BCcnTableGroup)) continue;
            tg1 = (BCcnTableGroup)nextChild;
            if (tg1.getName().equalsIgnoreCase(_groupType.getTag())) {
                isTableGroupExisted = true;
                break;
            }
            BCcnTableGroup tg2 = CcnUtil.findCcnTableGroup(nextChild, _groupType);
            if (tg2 == null) continue;
            return tg2;
        }
        if (isTableGroupExisted) {
            return tg1;
        }
        return null;
    }

    private void updateCreatedPoints(BCcnTable table) {
        BCcnPointEntry[] pointList;
        table.setLearnStatus("Update created points...");
        Vector<BCcnProxyExt> vObject = new Vector<BCcnProxyExt>();
        table.getExistingObjectArray(table, vObject);
        if (vObject.size() <= 0) {
            table.setLearnStatus("Idle");
            return;
        }
        Object[] objectArray = new BCcnProxyExt[vObject.size()];
        vObject.copyInto(objectArray);
        if (table instanceof BCcnPicTable) {
            pointList = table.getPointList().getPointList();
        } else if (table instanceof BCcnDataTable) {
            pointList = table.getPointList().getPointList();
        } else if (table instanceof BCcnFidTable) {
            pointList = table.getPointList().getPointList();
        } else {
            table.setLearnStatus("Idle");
            return;
        }
        Vector<BCcnPointEntry> vPointList = new Vector<BCcnPointEntry>();
        for (int j = 0; j < objectArray.length; ++j) {
            boolean matchFound = false;
            for (int k = 0; k < pointList.length; ++k) {
                if (pointList[k].getFieldIndex() != ((BCcnProxyExt)objectArray[j]).getFieldIndex() || !pointList[k].getName().equals(((BCcnProxyExt)objectArray[j]).getFieldName())) continue;
                vPointList.addElement(pointList[k]);
                matchFound = true;
                break;
            }
            if (j < pointList.length && matchFound) continue;
            BCcnInputProxy child = (BCcnInputProxy)objectArray[j];
            child.setFault(true);
            table.setLearnStatus("Refresh Problem-> Table " + table.getTableName() + " has a CcnObject " + ((BCcnProxyExt)objectArray[j]).getFieldName() + " with no matching pointEntry from the refresh... set the CcnObject's outOfService and Fault flags");
        }
        BCcnPointEntry[] aPointList = new BCcnPointEntry[vPointList.size()];
        vPointList.copyInto((Object[])aPointList);
        CcnCreatePointsRequest reqCreatePoints = new CcnCreatePointsRequest(table, aPointList, true, true);
        reqCreatePoints.execute();
    }

    void addLearnedFidConfigs(BCcnFidTable fidTable, BFidPointConfig panel) {
        boolean isPointLearntAlready = false;
        BFidPointConfig[] learnedFIDs = (BFidPointConfig[])fidTable.getFidPointList().getChildren(BFidPointConfig.class);
        for (int i = 0; i < learnedFIDs.length; ++i) {
            if (learnedFIDs[i].getPointIndex() != panel.getPointIndex() || learnedFIDs[i].getDeviceType() != panel.getDeviceType() || learnedFIDs[i].getCtrlSensType() != panel.getCtrlSensType() || !learnedFIDs[i].getEUC().equalsIgnoreCase(panel.getEUC())) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready) {
            fidTable.getFidPointList().add(SlotPath.escape((String)(panel.getEUC().trim() + "_" + panel.getPointIndex() + "_" + panel.getDeviceType() + "_" + panel.getCtrlSensType())), (BValue)new BFidPointConfig(panel.getPointIndex(), (byte)panel.getDeviceType(), (byte)panel.getCtrlSensType(), panel.getEUC()));
        }
    }

    void addLearnedPoints(BCcnPicTable picTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])picTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock() || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready) {
            picTable.getPointList().add(SlotPath.escape((String)(panel.getFieldIndex() + panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    void addLearnedFIDPoints(BCcnFidTable fidTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])fidTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock() || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready) {
            fidTable.getPointList().add(SlotPath.escape((String)(panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    void addSpecialPointsList(BCcnPocTable pocTable, BCcnPointEntry panel) {
        boolean isSplPointLearntAlready = false;
        BCcnPointEntry[] learnedSplPoints = (BCcnPointEntry[])pocTable.getLearnedSplPoints().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedSplPoints.length; ++i) {
            if (!learnedSplPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedSplPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedSplPoints[i].getValueBlock() != panel.getValueBlock() || learnedSplPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isSplPointLearntAlready = true;
            break;
        }
        if (!isSplPointLearntAlready) {
            pocTable.getLearnedSplPoints().add(SlotPath.escape((String)(panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())) + "_" + panel.getValueBlock() + "_" + panel.getFieldIndex(), (BValue)panel);
        }
    }

    public CcnResponseMessage[] interrogateTableForPointData(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlockCount) {
        CcnResponseMessage[] curBlockResponses = new CcnResponseMessage[curBlockCount];
        if (!this.ccnDevice.isDeviceFID()) {
            for (int j = 2; j <= curBlockCount; ++j) {
                if ((20 <= curTableType && curTableType <= 22 || curTableType == 24) && (j == 5 || j == 9)) continue;
                this.ccnNetwork.setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
            }
        } else {
            for (int j = 1; j <= curBlockCount; ++j) {
                if (j == 1 && curTableType != 1281) continue;
                this.ccnNetwork.setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
                if (curBlockResponses[j - 1] != null) continue;
                return null;
            }
        }
        return curBlockResponses;
    }

    private CcnResponseMessage getBlockDataFromTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = new CcnResponseMessage();
        BCcnNetwork ccnNetwork = this.ccnDevice.getCcnNetwork();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            this.ccnMessageLog.trace("\n****  createTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnMessageLog.trace("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }
}

