/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnAlarmHistoryEntry;
import com.tridium.ccn.components.BCcnAlarmHistoryList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAlarmHistoryJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnAlarmHistoryRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnDevice device;
    private Vector<BCcnAlarmHistoryEntry> alarmVector;
    private BCcnAHTable ccnAHTable;
    private BCcnAlarmHistoryJob job;
    private int busNo;
    private int elemNo;
    private int tableType = 67;
    private int tableInstance = 1;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnAlarmHistoryRequest(BCcnDevice ccnDevice, BCcnAHTable ahTable, BCcnAlarmHistoryJob job) {
        this.device = ccnDevice;
        this.busNo = this.device.getBusNo();
        this.elemNo = this.device.getElemNo();
        this.ccnAHTable = ahTable;
        this.job = job;
    }

    @Override
    public void execute() {
        if (!this.device.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "Device is out of service.Cannot discover the alarms");
        }
        this.ccnAHTable.setLearnStatus("Polling for table header....");
        this.busNo = this.device.getBusNo();
        this.elemNo = this.device.getElemNo();
        this.ccnMessageLog.trace("...Getting alarm count from busNo= " + this.busNo + ", elemNo= " + this.elemNo);
        int lastAlarmBlock = this.getAlarmHistoryCount();
        int alarmCount = lastAlarmBlock - 2;
        if (lastAlarmBlock == -1) {
            this.ccnAHTable.setLearnStatus("ERROR: Unable to determine number of alarms");
            this.ccnAHTable.setAlarmCount(0);
            BCcnAlarmHistoryList table = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(table);
            return;
        }
        if (alarmCount == 0) {
            this.ccnAHTable.setLearnStatus("No alarms");
            this.ccnAHTable.setAlarmCount(0);
            BCcnAlarmHistoryList table = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(table);
            return;
        }
        this.ccnAHTable.setAlarmCount(alarmCount);
        this.alarmVector = new Vector();
        for (int i = 0; i < alarmCount; ++i) {
            this.job.progress((100 * i + 1) / (alarmCount + 1));
            this.ccnAHTable.setLearnStatus("Learning alarm " + (i + 1) + " of " + alarmCount);
            BCcnAlarmHistoryEntry newAlarm = this.getAlarmHistoryEntry(i + 3);
            if (newAlarm.getAlarmTextSummary().startsWith("error") || newAlarm.getAlarmTextSummary().endsWith("error")) continue;
            this.alarmVector.addElement(newAlarm);
        }
        if (this.alarmVector.size() > 0) {
            BCcnAlarmHistoryEntry[] entries = new BCcnAlarmHistoryEntry[this.alarmVector.size()];
            this.alarmVector.copyInto((Object[])entries);
            BCcnAlarmHistoryList table = new BCcnAlarmHistoryList(entries);
            for (int iAlarmCount = 0; iAlarmCount < entries.length; ++iAlarmCount) {
                this.addLearnedAlarm(entries[iAlarmCount]);
            }
            this.ccnAHTable.setAlarmCount(this.alarmVector.size());
        } else {
            BCcnAlarmHistoryList table = new BCcnAlarmHistoryList();
            this.ccnAHTable.setAlarmHistoryList(table);
            this.ccnAHTable.setAlarmCount(0);
        }
    }

    private int getAlarmHistoryCount() {
        CcnResponseMessage rsp = this.getBlockDataFromAlarmTable(1);
        if (rsp == null) {
            this.ccnAHTable.setLearnStatus("ERROR: no response to alarm count request...");
            return -1;
        }
        if ((rsp.getResponseCommand() & 0xFF) == 21) {
            int rspCode = rsp.getResponseCode() & 0xFF;
            if (rspCode == 1) {
                this.ccnAHTable.setLearnStatus("ERROR: command not implemented");
            } else if (rspCode == 4) {
                this.ccnAHTable.setLearnStatus("ERROR: table does not exist");
            } else if (rspCode == 10) {
                this.ccnAHTable.setLearnStatus("ERROR: block not defined");
            } else if (rspCode == 16) {
                this.ccnAHTable.setLearnStatus("ERROR: access denied");
            } else {
                this.ccnAHTable.setLearnStatus("ERROR: unknown error " + rspCode);
            }
            return -1;
        }
        try {
            return CcnRspTableUtil.getBlockCount(rsp) & 0xFF;
        }
        catch (CcnException e) {
            this.ccnMessageLog.error("error parsing alarm history table header");
            this.ccnAHTable.setLearnStatus("ERROR Learn: error in response to alarm count request...");
            return -1;
        }
    }

    private BCcnAlarmHistoryEntry getAlarmHistoryEntry(int block) throws CcnRuntimeException {
        CcnResponseMessage rsp = this.getBlockDataFromAlarmTable(block);
        if (rsp == null) {
            this.ccnAHTable.setLearnStatus("ERROR Learn: no response to alarm history entry " + block);
            return new BCcnAlarmHistoryEntry("error, block " + block, "no response");
        }
        if ((rsp.getResponseCommand() & 0xFF) == 21) {
            int rspCode = rsp.getResponseCode() & 0xFF;
            if (rspCode == 1) {
                return new BCcnAlarmHistoryEntry("error, block " + block, "command not implemented");
            }
            if (rspCode == 4) {
                return new BCcnAlarmHistoryEntry("error, block " + block, "table does not exist");
            }
            if (rspCode == 10) {
                return new BCcnAlarmHistoryEntry("error, block " + block, "block not defined");
            }
            if (rspCode == 16) {
                return new BCcnAlarmHistoryEntry("error, block " + block, "access denied");
            }
            return new BCcnAlarmHistoryEntry("error, block " + block, "unknown error");
        }
        if (this.isEmptyAlarmMsgDataArray(rsp)) {
            return new BCcnAlarmHistoryEntry("block " + block + " error", "no data");
        }
        try {
            boolean isDisplayMetric = this.device.getCcnNetwork().getDisplayMetric();
            return new BCcnAlarmHistoryEntry(CcnAlarmUtil.getAlarmTextSummary(rsp, this.elemNo, this.busNo), CcnAlarmUtil.getAlarmTextDetail(rsp, isDisplayMetric));
        }
        catch (CcnException e) {
            this.ccnMessageLog.error("error parsing alarm history table entry");
            String displayString = "ERROR Learn: error parsing alarm table entry";
            this.ccnAHTable.setLearnStatus(displayString);
            return new BCcnAlarmHistoryEntry("block " + block + " error", displayString);
        }
    }

    private CcnResponseMessage getBlockDataFromAlarmTable(int block) {
        CcnTableDef tableDef = new CcnTableDef((byte)this.elemNo, (byte)this.busNo, null, (short)this.tableType, (byte)this.tableInstance, (byte)block, 0, 0);
        CcnReadTableRequest req = new CcnReadTableRequest(tableDef);
        CcnResponseMessage rsp = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        return rsp;
    }

    private boolean isEmptyAlarmMsgDataArray(CcnResponseMessage alarmMsg) {
        byte[] alarmMsgDataArray = alarmMsg.getData();
        int dataLength = alarmMsgDataArray.length;
        for (int i = 3; i < dataLength; ++i) {
            if (!(4 <= i && i <= 11 || 15 <= i && i <= 22 || 44 <= i && i <= 51 ? alarmMsgDataArray[i] != 0 && alarmMsgDataArray[i] != 32 : alarmMsgDataArray[i] != 0)) continue;
            return false;
        }
        return true;
    }

    void addLearnedAlarm(BCcnAlarmHistoryEntry panel) {
        boolean isAlarmLearntAlready = false;
        BCcnAlarmHistoryEntry[] learnedAlarms = (BCcnAlarmHistoryEntry[])this.ccnAHTable.getLearnedAlarms().getChildren(BCcnAlarmHistoryEntry.class);
        for (int i = 0; i < learnedAlarms.length; ++i) {
            if (!learnedAlarms[i].getAlarmTextSummary().trim().equalsIgnoreCase(panel.getAlarmTextSummary().trim())) continue;
            isAlarmLearntAlready = true;
            break;
        }
        if (!isAlarmLearntAlready) {
            this.ccnAHTable.getLearnedAlarms().add(SlotPath.escape((String)(panel.getAlarm().trim() + "_" + panel.getAlarmTextSummary())), (BValue)panel);
        }
    }
}

