/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.CcnTunnelProcess;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.UDPRoutingTableEntry;

class CcnRoutingTableManager
extends CcnTunnelProcess {
    protected CcnTunnelBack iTunnelBack;
    private int iJaceElem = 0;
    private static final int ONE_MINUTE = 60000;

    public CcnRoutingTableManager(BCcnTunnelHelper lCcnTunnelHelper, CcnUdpRoutingTable lRoutingTable, CcnTunnelBack lTunnelBack) {
        super(lCcnTunnelHelper, lRoutingTable, "CCNRtMan", -1, 'R');
        this.iTunnelBack = lTunnelBack;
        this.iJaceElem = lCcnTunnelHelper.ccnNetwork.getElemAddress();
    }

    @Override
    public void pleaseStop() {
        super.pleaseStop();
        this.interrupt();
    }

    @Override
    protected boolean isDebugOn() {
        return false;
    }

    @Override
    protected boolean isDisplayDots() {
        return false;
    }

    private void purgeStaleEntries() {
        this.iRoutingTable.purgeStaleEntries();
    }

    private void ifUpdatedThenTransmitRoutingTableToAll() {
        if (this.iRoutingTable.isUpdatedButNotTransmitted()) {
            this.debugLn("Routing table has been modified and needs to be transmitted");
            this.iRoutingTable.sendToAll(this.iTunnelBack, 0, this.iCcnTunnelHelper.ccnNetwork.getElemAddress());
            this.iRoutingTable.resetUpdatedButNotTransmitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ifNecessaryThenUpdateJaceEntry() {
        int[] jaceIp = BCcnTunnelHelper.getIpAddrBytes();
        int jaceNewElem = this.iCcnTunnelHelper.ccnNetwork.getElemAddress();
        if (this.iJaceElem != this.iCcnTunnelHelper.ccnNetwork.getElemAddress()) {
            CcnUdpRoutingTable ccnUdpRoutingTable = this.iRoutingTable;
            synchronized (ccnUdpRoutingTable) {
                this.iRoutingTable.remove(this.iJaceElem);
                this.iRoutingTable.giveEntry(new UDPRoutingTableEntry(jaceIp, jaceNewElem, 50005, 3));
            }
            this.iJaceElem = jaceNewElem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void cycle() {
        try {
            this.debugLn("Entered Method cycle - waiting one minute");
            this.debugLn("CcnRoutingTableManager debug dump:");
            CcnUdpRoutingTable ccnUdpRoutingTable = this.iRoutingTable;
            synchronized (ccnUdpRoutingTable) {
                ((Object)((Object)this.iRoutingTable)).wait(60000L);
            }
            this.debugLn("Entered Method cycle - finished waiting one minute");
            this.ifNecessaryThenUpdateJaceEntry();
            this.purgeStaleEntries();
            this.ifUpdatedThenTransmitRoutingTableToAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

