/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.util.MessageException;
import com.tridiumx.analytics.util.StringUtils;
import com.tridiumx.analytics.util.WrapperException;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.Encoder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

class QueryMessage
extends ApiMessage {
    public QueryMessage(Amap request, Context cx) {
        super(request, cx);
    }

    @Override
    protected Amap doGetResponse() {
        Amap map = this.getRequest().copy().toMap();
        String query = this.getRequiredString(map, "query");
        if (query.contains("sql:")) {
            throw new UnsupportedOperationException("SQL Operation not supported!");
        }
        String node = map.get("node", "slot:/");
        OrdTarget ot = this.resolveForRead(node);
        ot = BOrd.make((String)query).resolve(ot.get(), this.getContext());
        Encoder.encodeQuery(ot, map);
        return map;
    }

    private static BValue decode(Amap arg, BComplex parent, Property prop, BValue value, BFacets f) {
        try {
            if (Encoder.getPrimitiveType(value) != null) {
                if (prop == null) {
                    return parent;
                }
                String name = parent.getDisplayName((Slot)prop, null);
                String argStr = arg.getString(name);
                BValue decoded = (BValue)QueryMessage.decodeProto(argStr, value, f);
                if (decoded != null) {
                    parent.set(prop, decoded);
                }
            } else if (parent.isComplex()) {
                SlotCursor c = parent.getProperties();
                BValue child = null;
                BFacets tmp = null;
                while (c.next()) {
                    child = c.get();
                    prop = c.property();
                    if (Flags.isReadonly((BComplex)parent, (Slot)prop) || Flags.isHidden((BComplex)parent, (Slot)prop) || !child.isValue()) continue;
                    tmp = parent.getSlotFacets((Slot)prop);
                    QueryMessage.decode(arg, parent, prop, child.asValue(), BFacets.make((BFacets)f, (BFacets)tmp));
                }
            }
        }
        catch (Exception x) {
            WrapperException.throwRuntime(x);
        }
        return parent;
    }

    private static BEnum decodeEnum(String val, BFacets facets) {
        BEnumRange r = (BEnumRange)facets.get("range");
        if (r != null) {
            BEnum e = null;
            int[] ints = r.getOrdinals();
            int i = ints.length;
            while (--i >= 0) {
                e = r.get(ints[i]);
                if (!e.getDisplayTag(null).equals(val)) continue;
                return e;
            }
            if (r.isTag(val)) {
                return r.get(val);
            }
            i = ints.length;
            while (--i >= 0) {
                e = r.get(ints[i]);
                if (e.getDisplayTag(null).equalsIgnoreCase(val)) {
                    return e;
                }
                if (!e.getTag().equalsIgnoreCase(val)) continue;
                return e;
            }
        }
        try {
            return BDynamicEnum.make((int)Integer.parseInt(val));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object decodeProto(String val, Object proto, BFacets facets) throws Exception {
        if (proto instanceof BStatusValue) {
            return QueryMessage.decodeStatusValue(val, (BStatusValue)proto, facets);
        }
        if (val == null) {
            if (proto instanceof BSimple) {
                return proto;
            }
            return null;
        }
        Class<?> c = proto.getClass();
        if (val.equalsIgnoreCase("null")) {
            Object ret;
            Field f2;
            try {
                f2 = c.getField("null");
                if (f2 != null && Modifier.isPublic(f2.getModifiers()) && (ret = f2.get(proto)) != null) {
                    return ret;
                }
            }
            catch (Exception f2) {
                // empty catch block
            }
            try {
                f2 = c.getField("NULL");
                if (f2 != null && Modifier.isPublic(f2.getModifiers()) && (ret = f2.get(proto)) != null) {
                    return ret;
                }
            }
            catch (Exception f3) {}
        } else {
            Object ret;
            try {
                Method m = c.getMethod("make", String.class);
                if (m != null && (ret = m.invoke(proto, val)) != null) {
                    return ret;
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            try {
                Constructor<?> init = c.getConstructor(String.class);
                if (init != null && (ret = init.newInstance(val)) != null) {
                    return ret;
                }
            }
            catch (Exception init) {
                // empty catch block
            }
        }
        if (proto instanceof BEnum) {
            BEnum ret = QueryMessage.decodeEnum(val, facets);
            if (ret == null) {
                ret = QueryMessage.decodeEnum(val, ((BEnum)proto).getEnumFacets());
            }
            if (ret != null) {
                if (proto instanceof BDynamicEnum) {
                    ret = BDynamicEnum.make((BEnum)ret);
                }
                return ret;
            }
        }
        if (proto instanceof BBoolean) {
            String txt = facets.gets("trueText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return BBoolean.TRUE;
            }
            txt = facets.gets("falseText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return BBoolean.FALSE;
            }
        }
        if (proto instanceof BSimple) {
            return ((BSimple)proto).decodeFromString(val);
        }
        throw new MessageException("Could not decode: " + val);
    }

    private static BStatusValue decodeStatusValue(String val, BStatusValue proto, BFacets facets) {
        if (val == null || val.equalsIgnoreCase("null")) {
            BStatusValue b = (BStatusValue)proto.newCopy(true);
            b.setStatus(BStatus.nullStatus);
            return b;
        }
        if (proto instanceof BStatusBoolean) {
            if (val.equalsIgnoreCase("true")) {
                return new BStatusBoolean(true);
            }
            if (val.equalsIgnoreCase("false")) {
                return new BStatusBoolean(false);
            }
            String txt = facets.gets("trueText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return new BStatusBoolean(true);
            }
            txt = facets.gets("falseText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return new BStatusBoolean(false);
            }
            throw new IllegalArgumentException("Could not parse boolean: " + val);
        }
        if (proto instanceof BStatusNumeric) {
            double v;
            double d = Double.parseDouble(val = StringUtils.getNumber(val));
            if (d < (v = facets.getd("min", Double.MIN_VALUE))) {
                throw new IllegalArgumentException(d + " is less than " + v);
            }
            v = facets.getd("max", Double.MAX_VALUE);
            if (d > v) {
                throw new IllegalArgumentException(d + " is greater than " + v);
            }
            return new BStatusNumeric(d);
        }
        if (proto instanceof BStatusEnum) {
            BEnum e = QueryMessage.decodeEnum(val, facets);
            if (e == null) {
                throw new IllegalArgumentException("Unrecognized enum tag: " + val);
            }
            if (((BStatusEnum)proto).getEnum() instanceof BDynamicEnum) {
                e = BDynamicEnum.make((BEnum)e);
            }
            return new BStatusEnum(e);
        }
        return new BStatusString(val);
    }
}

