/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import java.util.ArrayList;
import java.util.Vector;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;

public class StringUtils {
    public static String concatUris(String base, String path) {
        if (path == null || path.length() == 0) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                return base + path.substring(1);
            }
        } else if (!path.startsWith("/")) {
            return base + "/" + path;
        }
        return base + path;
    }

    public static String csvCell(String s) {
        return StringUtils.csvCell(s, false);
    }

    public static String csvCell(String s, boolean forceQuotes) {
        if (s.indexOf(34) >= 0) {
            int len = s.length();
            StringBuilder buf = new StringBuilder(len * 2);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    buf.append(c);
                }
                buf.append(c);
            }
            s = buf.toString();
        }
        if (forceQuotes) {
            s = '\"' + s + '\"';
        } else if (s.indexOf(44) >= 0) {
            if (!s.startsWith("\"")) {
                s = "\"" + s;
            }
            if (!s.endsWith("\"")) {
                s = s + "\"";
            }
        }
        return s;
    }

    public static String escapePath(String path) {
        StringBuilder buf = new StringBuilder(path.length() * 2);
        String[] names = StringUtils.fields(path, '/');
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            buf.append('/');
            names[i] = SlotPath.escape((String)names[i]);
            buf.append(names[i]);
        }
        return buf.toString();
    }

    public static final String[] fields(String row) {
        StringBuilder buf = new StringBuilder(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch < '!' || ch > '~') {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static final String[] fields(String row, char delim) {
        StringBuilder buf = new StringBuilder(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch == delim) {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static final String getNumber(String src) {
        int len = src.length();
        StringBuilder buf = new StringBuilder();
        boolean hasDec = false;
        boolean hasDigits = false;
        boolean hasMinus = false;
        boolean hasExp = false;
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch == '-' && !hasMinus) {
                buf.append('-');
                hasMinus = true;
                continue;
            }
            if (ch == '.' && !hasDec) {
                buf.append(ch);
                hasDec = true;
                continue;
            }
            if (Character.isDigit(ch)) {
                buf.append(ch);
                hasDigits = true;
                continue;
            }
            if (!(ch != 'e' && ch != 'E' || hasExp)) {
                if (!hasDigits) continue;
                String sciNot = "e";
                if (i + 1 >= len) continue;
                char nextChar = src.charAt(i + 1);
                if (nextChar == '-' || nextChar == '+') {
                    if (i + 2 >= len) break;
                    sciNot = sciNot + nextChar;
                    nextChar = src.charAt(i + 2);
                    ++i;
                }
                if (!Character.isDigit(nextChar)) break;
                buf.append(sciNot);
                hasExp = true;
                continue;
            }
            if (hasDigits) break;
        }
        src = buf.toString();
        return src;
    }

    public static String makeCsvRow(String[] row) {
        if (row == null) {
            return "";
        }
        int len = row.length;
        StringBuilder buf = new StringBuilder(len * 15);
        boolean comma = false;
        for (int i = 0; i < len; ++i) {
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            buf.append(StringUtils.csvCell(row[i]));
        }
        return buf.toString();
    }

    public static String parseCsvCell(String s) {
        if ((s = s.trim()).indexOf(34) < 0) {
            return s;
        }
        int len = s.length() - 1;
        if (len > 1) {
            if (s.charAt(0) == '\"' && s.charAt(len) == '\"') {
                s = s.substring(1, len);
            }
            s = TextUtil.replace((String)s, (String)"\"\"", (String)"\"");
        }
        return s;
    }

    public static String[] readCsvLine(char[] row, char delim) {
        int len = row.length;
        if (len == 0) {
            return new String[0];
        }
        boolean inquote = false;
        ArrayList<String> cells = new ArrayList<String>();
        StringBuilder cell = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = row[i];
            if (ch == delim) {
                if (inquote) {
                    cell.append(ch);
                    continue;
                }
                cells.add(StringUtils.parseCsvCell(cell.toString()));
                cell.setLength(0);
                continue;
            }
            if (ch == '\"') {
                inquote = !inquote;
                cell.append(ch);
                continue;
            }
            cell.append(ch);
        }
        cells.add(StringUtils.parseCsvCell(cell.toString()));
        return cells.toArray(new String[0]);
    }

    public static String[] readCsvLine(String s, char delim) {
        return StringUtils.readCsvLine(s.trim().toCharArray(), delim);
    }

    public static String unescapePath(String path) {
        StringBuilder buf = new StringBuilder(path.length() * 2);
        String[] names = StringUtils.fields(path, '/');
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            buf.append('/');
            names[i] = SlotPath.unescape((String)names[i]);
            buf.append(names[i]);
        }
        return buf.toString();
    }
}

