/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=11)})
public class BConfigurableObject
extends BComponent
implements BIStatus {
    @Generated
    public static final Property enabled = BConfigurableObject.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property status = BConfigurableObject.newProperty((int)11, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BConfigurableObject.newProperty((int)11, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConfigurableObject.class);
    private static int inoperational = 87;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(enabled)) {
                this.updateConfig();
            } else {
                super.changed(p, cx);
            }
        }
    }

    public void enqueue(Runnable arg) {
        BAnalyticService.getInstance().enqueue(arg);
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (this.isRunning()) {
            this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        }
        return null;
    }

    protected void configOk() {
        this.updateConfig(0, null);
    }

    protected void configFault(String reason) {
        this.updateConfig(2, reason);
    }

    protected boolean isOperational() {
        if ((this.getStatus().getBits() & inoperational) != 0) {
            return false;
        }
        try {
            return BAnalyticService.getInstance().isOperational();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void updateConfig() {
        this.updateConfig(this.getEnabled() ? 0 : 1, null);
    }

    protected void updateConfig(int bits, String faultCause) {
        if (this.getStatus().getBits() != bits) {
            this.setStatus(BStatus.make((int)bits));
        }
        if (faultCause == null || faultCause.length() == 0) {
            if (this.getFaultCause().length() > 0) {
                this.setFaultCause("");
            }
        } else if (!this.getFaultCause().equals(faultCause)) {
            this.setFaultCause(faultCause);
            if ((bits & 2) != 0) {
                Utils.log().severe(() -> this.toPathString() + ": " + faultCause);
            }
        }
    }
}

