/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.algorithm.outlier.BOutlierHandling;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.trend.NiagaraTrend;
import javax.baja.status.BStatus;
import javax.baja.sys.BRelTime;
import javax.bajax.analytics.data.AnalyticValue;

public class StatusFilterTrend
extends AbstractTrendWrapper {
    private BStatus status = BOutlierHandling.DEFAULT.getStatus();
    protected AnalyticValue row;

    public StatusFilterTrend(NiagaraTrend trend) {
        super(trend);
        if (trend.getContext() != null) {
            this.status = trend.getContext().getStatusFilter();
        }
    }

    @Override
    protected AnalyticValue getNext() {
        if (!this.trend.hasNext()) {
            return null;
        }
        this.row = this.trend.next();
        int rowStatus = this.row.getStatus();
        while (this.row != null && !Values.isValid(rowStatus, this.status.getBits())) {
            this.row = null;
            if (!this.trend.hasNext()) break;
            this.row = this.trend.next();
            rowStatus = this.row.getStatus();
        }
        return this.row;
    }

    public BRelTime getInterval() {
        return ((NiagaraTrend)this.trend).getInterval();
    }
}

