/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.util.Utils;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.Interval;

public class IntervalTrend
extends AbstractTrendWrapper {
    private boolean cov = false;
    private long curTs;
    private Interval interval;
    private AnalyticValue nextIvl;
    private long nextTs;
    private Combiner rollup;

    public IntervalTrend(AnalyticTrend trend, AnalyticContext cx) {
        super(trend);
        if (cx == null) {
            cx = trend.getContext();
        }
        this.setContext(cx);
        this.rollup = cx.getRollup(true).makeCombiner();
        this.interval = cx.getInterval(true);
        if (this.interval.getOrdinal() == 0) {
            throw new IllegalStateException(Utils.lex("intervalNone"));
        }
        if (trend.hasNext()) {
            this.nextIvl = trend.next().newCopy();
            this.curTs = this.nextIvl.getTimestamp();
            long startTime = cx.getStartTime();
            long itvl = cx.getInterval(true).millis();
            this.curTs = Math.max(((BAnalyticTimeRange)cx.getTimeRange(true)).alignStart(this.curTs, itvl), startTime);
            this.nextTs = this.interval.next(this.curTs);
        } else {
            this.nextTs = this.curTs = cx.getEndTime();
        }
    }

    public IntervalTrend setCov(boolean arg) {
        this.cov = arg;
        return this;
    }

    @Override
    protected AnalyticValue getNext() {
        if (this.nextIvl == null) {
            return null;
        }
        long rowTs = this.nextIvl.getTimestamp();
        AnalyticValue ret = null;
        if (this.nextTs <= rowTs) {
            if (this.cov) {
                ret = this.rollup.getValue().setTimestamp(this.curTs);
                this.curTs = this.nextTs;
                this.nextTs = this.interval.next(this.nextTs);
                return ret;
            }
            while (this.nextTs <= rowTs) {
                this.curTs = this.nextTs;
                this.nextTs = this.interval.next(this.nextTs);
            }
        }
        this.rollup.reset();
        while (this.nextIvl.getTimestamp() < this.nextTs) {
            this.rollup.update(this.nextIvl);
            if (this.trend.hasNext()) {
                this.nextIvl.copy(this.trend.next());
                continue;
            }
            this.nextIvl = null;
            break;
        }
        ret = this.rollup.getValue().setTimestamp(this.curTs);
        if (this.nextIvl != null) {
            this.curTs = this.nextTs;
            this.nextTs = this.interval.next(this.nextTs);
        }
        return ret;
    }
}

