/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticTrendResolver;
import com.tridiumx.analytics.naming.BTrendOrdScheme;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.MergeTrend;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.BaselineAnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

@NiagaraType(ordScheme="analyticBaselineTrend")
@NiagaraSingleton
public class BBaselineTrendOrdScheme
extends BTrendOrdScheme {
    @Generated
    public static final BBaselineTrendOrdScheme INSTANCE = new BBaselineTrendOrdScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BBaselineTrendOrdScheme.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BBaselineTrendOrdScheme() {
        super("analyticBaselineTrend");
    }

    @Override
    public AnalyticContext getAnalyticContext(OrdTarget base, Map<String, String> args) {
        return BaselineAnalyticContext.make(args, (Context)base);
    }

    @Override
    protected BObject resolve(AnalyticContext cx) {
        AbstractTrend trend = new EmptyTrend(cx);
        try {
            AnalyticTrend notBaselineTrend;
            if (((BaselineAnalyticContext)cx).getBaselineTimeRange() == null) {
                return super.resolve(cx);
            }
            AnalyticContext originalContext = cx.newCopy();
            BaselineAnalyticContext baselineAnalyticContext = (BaselineAnalyticContext)cx;
            baselineAnalyticContext.setIsBaseline(BBoolean.TRUE);
            baselineAnalyticContext.setTimeRange(baselineAnalyticContext.getBaselineTimeRange());
            List<CompletableFuture> trendFutures = Stream.of(baselineAnalyticContext, originalContext).map(context -> Analytics.getTrendAsync(context)).collect(Collectors.toList());
            Map trendMap = (Map)((CompletableFuture)CompletableFuture.allOf(trendFutures.toArray(trendFutures.toArray(new CompletableFuture[0]))).thenApply(f -> trendFutures.stream().map(fu -> (Optional)fu.join()).filter(tr -> tr.isPresent()).map(tr -> (AnalyticTrend)tr.get()).collect(Collectors.toMap(p -> p.getContext().getClass() == BaselineAnalyticContext.class ? "baseline" : "not-baseline", Function.identity())))).get();
            AnalyticTrend baselineTrend = (AnalyticTrend)trendMap.get("baseline");
            if (baselineTrend == null) {
                baselineTrend = new EmptyTrend(cx);
            }
            if ((notBaselineTrend = (AnalyticTrend)trendMap.get("not-baseline")) == null) {
                notBaselineTrend = new EmptyTrend(cx);
            }
            baselineTrend.setContext(baselineAnalyticContext);
            notBaselineTrend.setContext(originalContext);
            trend = new MergeTrend(baselineTrend, notBaselineTrend, cx);
        }
        catch (Exception e) {
            Logger.getLogger("analytics").log(Level.SEVERE, "Error processing baseline trend", e);
        }
        return this.getResolver(cx, trend);
    }

    @Override
    protected BAbstractTrendResolver getResolver(AnalyticContext cx, AnalyticTrend trend) {
        return new BAnalyticTrendResolver(trend, cx);
    }
}

