/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.data.BDataTable;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.alert.AlertEntry;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="alerts")
@NiagaraSingleton
public class BAlertsOrdScheme
extends BOrdScheme {
    @Generated
    public static final BAlertsOrdScheme INSTANCE = new BAlertsOrdScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BAlertsOrdScheme.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BAlertsOrdScheme() {
        super("alerts");
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        int currPrio = Thread.currentThread().getPriority();
        try {
            BISession session;
            if (Sys.isStation()) {
                Thread.currentThread().setPriority(BAnalyticService.getInstance().getThreadPriority());
                if (!BAnalyticService.getInstance().isSteady()) {
                    OrdTarget ordTarget = base;
                    return ordTarget;
                }
            }
            if ((session = this.toSession(base)) instanceof BFoxSession) {
                OrdTarget ordTarget = this.resolveFox((BFoxSession)session, base, query);
                return ordTarget;
            }
            Object node = base.get() instanceof BINavNode ? (BINavNode)base.get() : (base.getComponent() != null ? base.getComponent() : Sys.getStation());
            BDataTable ret = new BDataTable();
            ret.addColumn("alert", Utils.lex("alert"), BOrd.DEFAULT.getType(), 0, BFacets.NULL);
            ret.addColumn("node", Utils.lex("node"), BOrd.DEFAULT.getType(), 0, BFacets.NULL);
            ret.addColumn("state", Utils.lex("state"), BBoolean.TRUE.toDataValue().getType(), 0, BFacets.makeBoolean((String)Utils.lex("alert"), (String)Utils.lex("normal")));
            ret.addColumn("cost", Utils.lex("cost"), BDouble.DEFAULT.toDataValue().getType(), 0, BFacets.makeNumeric((int)2));
            ret.startRows();
            ArrayList<AlertEntry> alerts = BAlertsOrdScheme.getAlerts(node, new ArrayList<AlertEntry>(), true, (Context)base);
            if (alerts != null) {
                for (AlertEntry e : alerts) {
                    ret.startRow();
                    ret.set((BIDataValue)e.getAlert().getSlotPathOrd(), BFacets.NULL);
                    node = e.getNode();
                    ret.set((BIDataValue)Utils.getNodeOrd(node), BFacets.NULL);
                    ret.set(BBoolean.make((boolean)e.isInAlert()).toDataValue(), BFacets.NULL);
                    ret.set(BDouble.make((double)e.getTotalCost()).toDataValue(), BFacets.NULL);
                    ret.endRow();
                }
            }
            ret.endRows();
            OrdTarget ordTarget = new OrdTarget(base, (BObject)ret);
            return ordTarget;
        }
        catch (Exception x) {
            x.printStackTrace();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
        finally {
            Thread.currentThread().setPriority(currPrio);
        }
    }

    public static ArrayList<AlertEntry> getAlerts(BINavNode node, ArrayList<AlertEntry> list, boolean tree, Context cx) {
        if (!BAnalyticService.getInstance().isValidNodeType(node)) {
            return list;
        }
        NodeInfo info = NodeInfo.get(node, false);
        if (info != null) {
            if (list == null) {
                list = new ArrayList();
            }
            info.getEntries(list, cx);
        }
        if (!tree) {
            return list;
        }
        if (!node.hasNavChildren()) {
            return list;
        }
        if (list == null) {
            list = new ArrayList();
        }
        BINavNode[] kids = node.getNavChildren();
        kids = Utils.filter(kids, cx);
        int len = kids.length;
        for (int i = 0; i < len; ++i) {
            list = BAlertsOrdScheme.getAlerts(kids[i], list, true, cx);
        }
        return list;
    }

    private OrdTarget resolveFox(BFoxSession session, OrdTarget base, OrdQuery query) throws Exception {
        BObject baseObject = base.get();
        BOrd ord = Utils.getNodeOrd((BINavNode)baseObject);
        ord = BOrd.make((BOrd)ord, (OrdQuery)query).normalize();
        ord = BOrd.make((String)(ord.toString(null) + "&remoteFox=true"));
        ord = BOrd.make((BOrd)BOrd.make((String)"station:"), (BOrd)ord);
        BFoxClientConnection conn = session.getConnection();
        BDataChannel channel = (BDataChannel)conn.getChannels().get("data");
        BObject res = channel.resolve(ord, new String[0]);
        return new OrdTarget(base, res);
    }

    private BISession toSession(OrdTarget baseTarget) {
        if (baseTarget == null) {
            throw new InvalidOrdBaseException("null");
        }
        BISession session = null;
        for (OrdTarget target = baseTarget; target != null && (session = BOrd.toSession((BObject)target.get())) == null; target = target.getBaseOrdTarget()) {
        }
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + baseTarget.get());
    }
}

