/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.substitute.AbstractInterpolator;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.trend.NiagaraTrend;
import com.tridiumx.analytics.util.Utils;
import java.util.logging.Level;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class LinearInterpolator
extends AbstractInterpolator {
    protected AnalyticValue previousVal;
    protected AnalyticValue ret;
    private double slope = Double.NaN;
    private boolean isFirst = true;
    private boolean isLast = false;
    private boolean isWrongTypewarningLogged = false;

    public LinearInterpolator(AnalyticTrend trend) {
        super(trend);
    }

    @Override
    public AnalyticValue getCurrentValue() {
        return this.ret;
    }

    @Override
    public boolean interpolate() {
        long nextTimeStamp = 0L;
        if (this.isInterpolateApplicable() && this.historyInterval != 0L) {
            nextTimeStamp = this.currentTimestamp + this.historyInterval;
            if (this.currentVal == null) {
                if (this.previousVal != null && this.currentTimestamp < this.trendEndTime) {
                    this.ret = this.previousVal.newCopy();
                    this.ret.setTimestamp(this.currentTimestamp);
                    if (this.ret instanceof NumericValue) {
                        ((NumericValue)this.ret).setTrendFlags(BInterpolationTrendFlags.linearInterpolated);
                    }
                } else {
                    this.ret = null;
                }
            } else {
                long recTimeStamp = this.currentVal.getTimestamp();
                if (recTimeStamp < nextTimeStamp && this.timeStampsInVicinity(this.currentTimestamp, recTimeStamp, this.historyInterval)) {
                    this.ret = this.currentVal.newCopy();
                    this.previousVal = this.currentVal;
                    this.currentVal = this.trend.hasNext() ? this.trend.next() : null;
                    this.currentVal = this.currentVal != null && this.currentVal.getTimestamp() < this.trendEndTime ? this.currentVal.newCopy() : this.previousVal;
                    this.slope = Double.NaN;
                } else {
                    if (this.previousVal != null && this.currentVal != null) {
                        this.ret = this.previousVal.newCopy();
                        if (this.ret instanceof NumericValue) {
                            double previousY = this.previousVal.toNumeric();
                            double nextY = this.currentVal.toNumeric();
                            long nextX = recTimeStamp;
                            long previousX = this.previousVal.getTimestamp();
                            if (nextX > previousX) {
                                if (Double.isNaN(this.slope)) {
                                    this.slope = (nextY - previousY) / (double)(nextX - previousX);
                                }
                                double currentValue = previousY + this.slope * (double)(this.currentTimestamp - previousX);
                                ((NumericValue)this.ret).setValue(currentValue);
                            }
                        } else if (Utils.log().isLoggable(Level.WARNING) && !this.isWrongTypewarningLogged) {
                            Utils.log().warning("Cannot apply linear interpolation for the history : " + ((NiagaraTrend)this.trend).getHistoryName());
                        }
                    } else {
                        this.ret = this.previousVal == null && this.currentVal == null ? null : (this.previousVal != null ? this.previousVal.newCopy() : this.currentVal.newCopy());
                    }
                    if (this.ret != null && this.ret instanceof NumericValue) {
                        this.ret.setTimestamp(this.currentTimestamp);
                        ((NumericValue)this.ret).setTrendFlags(BInterpolationTrendFlags.linearInterpolated);
                    }
                }
            }
            this.currentTimestamp = nextTimeStamp;
        } else if (this.isFirst && this.currentVal != null) {
            this.ret = this.currentVal.newCopy();
            this.currentTimestamp = this.ret.getTimestamp();
            this.isFirst = false;
        } else if (this.trend.hasNext()) {
            this.ret = this.trend.next();
            this.currentTimestamp = this.ret.getTimestamp();
            this.isLast = !this.trend.hasNext();
        } else {
            this.currentTimestamp = this.trendEndTime;
            this.ret = null;
        }
        return this.ret != null;
    }

    private boolean timeStampsInVicinity(long ts1, long ts2, long interval) {
        long diff = Math.abs(ts1 - ts2);
        return diff <= interval * (long)this.vicinityTolerance / 100L;
    }

    protected boolean isInterpolateApplicable() {
        boolean flag = this.currentVal != null && this.currentVal instanceof NumericValue;
        return flag;
    }

    @Override
    public boolean complete() {
        return this.isLast || super.complete();
    }
}

