/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.substitute.Interpolator;
import com.tridiumx.analytics.data.substitute.KNNInterpolator;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BDaysOfWeekBits;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class KNNAnalyticTrend
implements AnalyticTrend {
    private final AnalyticTrend intervalTrend;
    private Interpolator interpolator;
    private BDaysOfWeekBits daysToInclude;

    public KNNAnalyticTrend(AnalyticTrend intervalTrend, BMissingDataStrategy strategy) {
        this(intervalTrend, strategy, BDaysOfWeekBits.ALL);
    }

    public KNNAnalyticTrend(AnalyticTrend intervalTrend, BMissingDataStrategy strategy, BDaysOfWeekBits daysToInclude) {
        this.intervalTrend = intervalTrend;
        this.interpolator = new KNNInterpolator(intervalTrend, strategy.getKValue());
        this.daysToInclude = daysToInclude;
    }

    @Override
    public AnalyticContext getContext() {
        return this.intervalTrend.getContext();
    }

    @Override
    public boolean hasNext() {
        return !this.interpolator.complete() && this.interpolator.interpolate();
    }

    @Override
    public AnalyticValue next() {
        AnalyticValue ret = this.interpolator.getCurrentValue();
        if (ret == null) {
            return null;
        }
        BAbsTime ts = BAbsTime.make((long)ret.getTimestamp());
        while (!this.include(ts)) {
            ret = null;
            if (!this.hasNext() || (ret = this.interpolator.getCurrentValue()) == null) break;
            ts = BAbsTime.make((long)ret.getTimestamp());
        }
        return ret;
    }

    @Override
    public AnalyticTrend setContext(AnalyticContext cx) {
        return this;
    }

    @Override
    public void close() {
        if (this.intervalTrend != null) {
            this.intervalTrend.close();
        }
    }

    private boolean include(BAbsTime timestamp) {
        if (this.daysToInclude != null && this.daysToInclude != BDaysOfWeekBits.DEFAULT) {
            return this.daysToInclude.includes(timestamp);
        }
        return true;
    }
}

