/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.substitute.AbstractInterpolator;
import com.tridiumx.analytics.data.substitute.Interpolator;
import com.tridiumx.analytics.data.substitute.KNNInterpolator;
import com.tridiumx.analytics.data.substitute.LinearInterpolator;
import com.tridiumx.analytics.trend.NiagaraTrend;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

public class InterpolatorFactory {
    public static Interpolator getInterpolator(AnalyticTrend trend) {
        AnalyticContext ctx = trend.getContext();
        BMissingDataStrategy strategy = ctx.getMissingDataStrategy(true);
        String intpAlg = strategy.getInterpolationAlgorithm().getTag();
        AbstractInterpolator interpolator = null;
        if ("linearInterpolation".equals(intpAlg) && trend instanceof NiagaraTrend) {
            interpolator = new LinearInterpolator((NiagaraTrend)trend);
            return interpolator;
        }
        if ("kNearestNeighbour".equals(intpAlg)) {
            int knnValue = strategy.getKValue();
            knnValue = knnValue < 1 ? 1 : knnValue;
            interpolator = new KNNInterpolator(trend, knnValue);
        }
        return interpolator;
    }

    public static Interpolator getDefault(NiagaraTrend trend) {
        return new LinearInterpolator(trend);
    }
}

