/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import java.util.TreeMap;
import javax.bajax.analytics.data.AnalyticValue;

public final class ModeCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private int curCnt;
    private double curVal;
    private TreeMap<Double, Integer> map = new TreeMap();

    public ModeCombiner() {
        super(8);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        if (this.getCount() > 0) {
            this.analytic.setValue(this.curVal);
        }
        return this.analytic;
    }

    @Override
    protected void doReset() {
        this.map.clear();
        this.curCnt = 0;
        this.curVal = 0.0;
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        if (this.getCount() == 0) {
            this.curCnt = 1;
            this.curVal = arg.toNumeric();
            this.map.put(this.curVal, this.curCnt);
            this.analytic.setStatus(arg.getStatus());
        } else {
            int cnt = 1;
            double val = arg.toNumeric();
            Integer i = this.map.get(val);
            if (i != null) {
                cnt += i.intValue();
            }
            this.map.put(val, cnt);
            if (cnt > this.curCnt) {
                this.curCnt = cnt;
                this.curVal = val;
            }
            this.analytic.orStatus(arg);
        }
        this.analytic.copyTimestamp(arg);
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

