/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import java.util.Arrays;
import javax.bajax.analytics.data.AnalyticValue;

public final class MedianCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private double[] vals = new double[100];

    public MedianCombiner() {
        super(6);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        int len = this.getCount();
        double res = 0.0;
        if (len == 1) {
            res = this.vals[0];
        } else if (len > 1) {
            Arrays.sort(this.vals, 0, len);
            res = this.vals[(int)(((double)len + 0.5) / 2.0)];
        }
        return this.analytic.setValue(res);
    }

    @Override
    protected void doReset() {
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        int len = this.getCount();
        if (this.getCount() == 0) {
            this.vals[0] = arg.toNumeric();
            this.analytic.setStatus(arg.getStatus());
        } else {
            if (len == this.vals.length) {
                double[] ary = new double[len * 2];
                System.arraycopy(this.vals, 0, ary, 0, len);
                this.vals = ary;
            }
            this.vals[len] = arg.toNumeric();
            this.analytic.orStatus(arg);
        }
        this.analytic.setTimestamp(arg.getTimestamp());
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

