/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.bajax.analytics.data.AnalyticValue;

public final class AvgCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private double value;

    public AvgCombiner() {
        super(1);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        double avg = 0.0;
        int count = this.getCount();
        if (count != 0) {
            avg = this.value / (double)count;
        }
        this.analytic.setValue(avg);
        return this.analytic;
    }

    @Override
    protected void doReset() {
        this.value = 0.0;
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        if (this.getCount() == 0) {
            this.value = arg.toNumeric();
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.setStatus(arg.getStatus());
        } else {
            this.value += arg.toNumeric();
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.orStatus(arg);
        }
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

