/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.data.Values;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.Combiner;

public abstract class AbstractCombiner
implements Combiner {
    private int count = 0;
    private int combination;
    private boolean resetOnValid = false;

    protected AbstractCombiner(int type) {
        this.combination = type;
    }

    @Override
    public void accept(AnalyticValue arg) {
        this.update(arg);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getCombination() {
        return this.combination;
    }

    @Override
    public Combiner reset() {
        this.count = 0;
        this.resetOnValid = false;
        this.doReset();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean update(AnalyticValue arg) {
        if (!Values.isValid(arg.getStatus())) {
            if (this.count != 0) return false;
            this.resetOnValid = true;
        } else if (this.resetOnValid) {
            this.reset();
        }
        if (!this.doUpdate(arg)) {
            return false;
        }
        ++this.count;
        return true;
    }

    protected abstract void doReset();

    protected abstract boolean doUpdate(AnalyticValue var1);
}

