/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm.outlier;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BValueBits
extends BBitString {
    public static final int NaN = 1;
    public static final BValueBits DEFAULT = new BValueBits(1);
    public static final Type TYPE = Sys.loadType(BValueBits.class);
    private static BValueBits[] nullLookupTable = new BValueBits[256];
    public static final BValueBits ok = BValueBits.make(0, BFacets.NULL);
    public static final String SHOW_NaN = "SHOW_NaN";
    public static final BValueBits EMPTY = new BValueBits(0);
    public static final BValueBits ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    private BFacets facets;
    private int bits;

    public Type getType() {
        return TYPE;
    }

    public static BValueBits make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BValueBits make(int bits, BFacets facets) {
        if ((facets == null || facets.isNull()) && bits < 256) {
            if (nullLookupTable[bits] == null) {
                BValueBits.nullLookupTable[bits] = new BValueBits(bits, BFacets.NULL);
            }
            return nullLookupTable[bits];
        }
        return (BValueBits)new BValueBits(bits, facets).intern();
    }

    public static BValueBits make(int bits) {
        if (bits == BValueBits.ALL.bits) {
            return ALL;
        }
        if (bits == BValueBits.EMPTY.bits) {
            return EMPTY;
        }
        return new BValueBits(bits);
    }

    public static BValueBits make(BValueBits old, BValueBits nBits, boolean set) {
        if (set) {
            return new BValueBits(old.getBits() | nBits.getBits());
        }
        return new BValueBits(old.getBits() & ~nBits.getBits());
    }

    private BValueBits(int bits) {
        this.bits = bits;
    }

    private BValueBits(int bits, BFacets facets) {
        this.bits = bits;
        this.facets = facets != null ? facets : BFacets.NULL;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean isNaN() {
        return (this.bits & 1) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BValueBits.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    public boolean isNull() {
        return this.bits == 0;
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BValueBits) {
            return ((BValueBits)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public String toString(Context context) {
        BFacets facets = null;
        if (context != null) {
            facets = context.getFacets();
        }
        if (this.bits == 0) {
            return "{}";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        if (this.isNaN() && (facets == null || facets.getb(SHOW_NaN, true))) {
            s.append("NaN ");
        }
        s.setCharAt(s.length() - 1, '}');
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BValueBits.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BValueBits.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    static {
        support.add(1, "NaN");
    }
}

