/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.BValueMapEntry;
import com.tridiumx.analytics.algorithm.BValueMapMode;
import com.tridiumx.analytics.data.Values;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="in", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="unmappedMode", type="BValueMapMode", defaultValue="BValueMapMode.passThrough", flags=8), @NiagaraProperty(name="defaultKeyFacets", type="BFacets", defaultValue="facets()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:AnalyticFacetsFe\"))")}), @NiagaraProperty(name="defaultValueFacets", type="BFacets", defaultValue="facets()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:AnalyticFacetsFe\"))")}), @NiagaraProperty(name="defaultEntry", type="BValueMapEntry", defaultValue="BValueMapEntry.makeDefault()")})
@NiagaraActions(value={@NiagaraAction(name="configureUnmappedMode", parameterType="BValueMapMode", defaultValue="BValueMapMode.passThrough"), @NiagaraAction(name="addEntry", flags=4)})
public class BValueMapBlock
extends BOutputBlock {
    @Generated
    public static final Property in = BValueMapBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property unmappedMode = BValueMapBlock.newProperty((int)8, (BValue)BValueMapMode.passThrough, null);
    @Generated
    public static final Property defaultKeyFacets = BValueMapBlock.newProperty((int)0, (BValue)BValueMapBlock.facets(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:AnalyticFacetsFe")));
    @Generated
    public static final Property defaultValueFacets = BValueMapBlock.newProperty((int)0, (BValue)BValueMapBlock.facets(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:AnalyticFacetsFe")));
    @Generated
    public static final Property defaultEntry = BValueMapBlock.newProperty((int)0, (BValue)BValueMapEntry.makeDefault(), null);
    @Generated
    public static final Action configureUnmappedMode = BValueMapBlock.newAction((int)0, (BValue)BValueMapMode.passThrough, null);
    @Generated
    public static final Action addEntry = BValueMapBlock.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BValueMapBlock.class);
    private Map<BSimple, BSimple> myMap = null;

    @Generated
    public BBlockPin getIn() {
        return (BBlockPin)this.get(in);
    }

    @Generated
    public void setIn(BBlockPin v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public BValueMapMode getUnmappedMode() {
        return (BValueMapMode)this.get(unmappedMode);
    }

    @Generated
    public void setUnmappedMode(BValueMapMode v) {
        this.set(unmappedMode, (BValue)v, null);
    }

    @Generated
    public BFacets getDefaultKeyFacets() {
        return (BFacets)this.get(defaultKeyFacets);
    }

    @Generated
    public void setDefaultKeyFacets(BFacets v) {
        this.set(defaultKeyFacets, (BValue)v, null);
    }

    @Generated
    public BFacets getDefaultValueFacets() {
        return (BFacets)this.get(defaultValueFacets);
    }

    @Generated
    public void setDefaultValueFacets(BFacets v) {
        this.set(defaultValueFacets, (BValue)v, null);
    }

    @Generated
    public BValueMapEntry getDefaultEntry() {
        return (BValueMapEntry)this.get(defaultEntry);
    }

    @Generated
    public void setDefaultEntry(BValueMapEntry v) {
        this.set(defaultEntry, (BValue)v, null);
    }

    @Generated
    public void configureUnmappedMode(BValueMapMode parameter) {
        this.invoke(configureUnmappedMode, (BValue)parameter, null);
    }

    @Generated
    public void addEntry() {
        this.invoke(addEntry, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void added(Property p, Context cx) {
        this.myMap = null;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && this.get(p) instanceof BValueMapEntry) {
            this.myMap = null;
        }
        super.changed(p, cx);
    }

    public void doAddEntry(Context cx) {
        this.add("entry?", (BValue)new BValueMapEntry());
    }

    public void doConfigureUnmappedMode(BValueMapMode mode) {
        this.setUnmappedMode(mode);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue key = this.getInput(0).getValue(cx);
        Map<BSimple, BSimple> map = this.getMap();
        BSimple val = map.get(key);
        if (val == null) {
            switch (this.getUnmappedMode().getOrdinal()) {
                case 2: {
                    return key.setStatus(64);
                }
                case 0: {
                    return key;
                }
            }
            val = this.getDefaultEntry().getValue();
        }
        return Values.make(val).copyTimestamp(key).copyStatus(key);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    public void removed(Property p, BValue old, Context cx) {
        this.myMap = null;
    }

    private static BFacets facets() {
        BFacets ret = BFacets.makeEnum();
        ret = BFacets.make((BFacets)ret, (String)"precision", (BIDataValue)BInteger.make((int)2));
        return ret;
    }

    private Map<BSimple, BSimple> getMap() {
        if (this.myMap == null) {
            TreeMap<Object, BSimple> tmp = new TreeMap<Object, BSimple>(new MyComparator());
            BValueMapEntry[] entries = (BValueMapEntry[])this.getChildren(BValueMapEntry.class);
            int i = entries.length;
            while (--i > 0) {
                tmp.put(entries[i].getKey(), entries[i].getValue());
            }
            this.myMap = tmp;
        }
        return this.myMap;
    }

    private static class MyTrend
    extends BlockTrend {
        private BSimple defaultValue;
        private Map<BSimple, BSimple> map;
        private BValueMapMode mode;

        MyTrend(BValueMapBlock block, AnalyticContext cx) {
            super(block, cx);
            this.defaultValue = block.getDefaultEntry().getValue();
            this.map = block.getMap();
            this.mode = block.getUnmappedMode();
        }

        @Override
        public AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue key = this.getValue(0);
                BSimple val = this.map.get(key);
                if (val == null) {
                    switch (this.mode.getOrdinal()) {
                        case 0: {
                            return key;
                        }
                        case 1: {
                            return Values.make(this.defaultValue).copyTimestamp(key).copyStatus(key);
                        }
                    }
                    continue;
                }
                return Values.make(val).copyTimestamp(key).copyStatus(key);
            }
            return null;
        }
    }

    public static class MyComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (this.isNum(o1) && this.isNum(o2)) {
                double n1 = Values.getNumeric(o1);
                double n2 = Values.getNumeric(o2);
                if (Double.isNaN(n1)) {
                    if (Double.isNaN(n2)) {
                        return 0;
                    }
                    return 1;
                }
                if (Double.isNaN(n2)) {
                    return -1;
                }
                if (Double.isInfinite(n1)) {
                    if (Double.isInfinite(n2)) {
                        return 0;
                    }
                    return 1;
                }
                if (Double.isInfinite(n2)) {
                    return -1;
                }
                return (int)(n1 - n2);
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o1.toString());
        }

        private boolean isNum(Object o) {
            if (Values.isNumeric(o)) {
                return true;
            }
            if (Values.isBoolean(o)) {
                return true;
            }
            return Values.isEnum(o);
        }
    }
}

