/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="abs"), @Range(value="acos"), @Range(value="asin"), @Range(value="ceil"), @Range(value="cos"), @Range(value="exp"), @Range(value="floor"), @Range(value="log"), @Range(value="negate"), @Range(value="round"), @Range(value="sin"), @Range(value="sqrt"), @Range(value="tan"), @Range(value="toDegrees"), @Range(value="toRadians")})
public final class BUniMathOperator
extends BFrozenEnum {
    @Generated
    public static final int ABS = 0;
    @Generated
    public static final int ACOS = 1;
    @Generated
    public static final int ASIN = 2;
    @Generated
    public static final int CEIL = 3;
    @Generated
    public static final int COS = 4;
    @Generated
    public static final int EXP = 5;
    @Generated
    public static final int FLOOR = 6;
    @Generated
    public static final int LOG = 7;
    @Generated
    public static final int NEGATE = 8;
    @Generated
    public static final int ROUND = 9;
    @Generated
    public static final int SIN = 10;
    @Generated
    public static final int SQRT = 11;
    @Generated
    public static final int TAN = 12;
    @Generated
    public static final int TO_DEGREES = 13;
    @Generated
    public static final int TO_RADIANS = 14;
    @Generated
    public static final BUniMathOperator abs = new BUniMathOperator(0);
    @Generated
    public static final BUniMathOperator acos = new BUniMathOperator(1);
    @Generated
    public static final BUniMathOperator asin = new BUniMathOperator(2);
    @Generated
    public static final BUniMathOperator ceil = new BUniMathOperator(3);
    @Generated
    public static final BUniMathOperator cos = new BUniMathOperator(4);
    @Generated
    public static final BUniMathOperator exp = new BUniMathOperator(5);
    @Generated
    public static final BUniMathOperator floor = new BUniMathOperator(6);
    @Generated
    public static final BUniMathOperator log = new BUniMathOperator(7);
    @Generated
    public static final BUniMathOperator negate = new BUniMathOperator(8);
    @Generated
    public static final BUniMathOperator round = new BUniMathOperator(9);
    @Generated
    public static final BUniMathOperator sin = new BUniMathOperator(10);
    @Generated
    public static final BUniMathOperator sqrt = new BUniMathOperator(11);
    @Generated
    public static final BUniMathOperator tan = new BUniMathOperator(12);
    @Generated
    public static final BUniMathOperator toDegrees = new BUniMathOperator(13);
    @Generated
    public static final BUniMathOperator toRadians = new BUniMathOperator(14);
    @Generated
    public static final BUniMathOperator DEFAULT = abs;
    @Generated
    public static final Type TYPE = Sys.loadType(BUniMathOperator.class);

    @Generated
    public static BUniMathOperator make(int ordinal) {
        return (BUniMathOperator)abs.getRange().get(ordinal, false);
    }

    @Generated
    public static BUniMathOperator make(String tag) {
        return (BUniMathOperator)abs.getRange().get(tag);
    }

    @Generated
    private BUniMathOperator(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public double evaluate(double val) {
        double res = val;
        switch (this.getOrdinal()) {
            case 0: {
                res = Math.abs(val);
                break;
            }
            case 1: {
                res = Math.acos(val);
                break;
            }
            case 2: {
                res = Math.asin(val);
                break;
            }
            case 3: {
                res = Math.ceil(val);
                break;
            }
            case 4: {
                res = Math.cos(val);
                break;
            }
            case 5: {
                res = Math.exp(val);
                break;
            }
            case 6: {
                res = Math.floor(val);
                break;
            }
            case 7: {
                res = Math.log(val);
                break;
            }
            case 8: {
                res = -val;
                break;
            }
            case 9: {
                res = Math.rint(val);
                break;
            }
            case 10: {
                res = Math.sin(val);
                break;
            }
            case 11: {
                res = Math.sqrt(val);
                break;
            }
            case 12: {
                res = Math.tan(val);
                break;
            }
            case 13: {
                res = Math.toDegrees(val);
                break;
            }
            case 14: {
                res = Math.toRadians(val);
            }
        }
        return res;
    }
}

