/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.util.Utils;
import java.util.LinkedList;
import java.util.List;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="rollup", type="BCombination", defaultValue="BCombination.first", flags=8), @NiagaraProperty(name="useRequestRollup", type="boolean", defaultValue="false"), @NiagaraProperty(name="window", type="BRelTime", defaultValue="BRelTime.HOUR", flags=8)})
public class BSlidingWindowBlock
extends BOutputBlock {
    @Generated
    public static final Property trendIn = BSlidingWindowBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property rollup = BSlidingWindowBlock.newProperty((int)8, (BValue)BCombination.first, null);
    @Generated
    public static final Property useRequestRollup = BSlidingWindowBlock.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property window = BSlidingWindowBlock.newProperty((int)8, (BValue)BRelTime.HOUR, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSlidingWindowBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Generated
    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    @Generated
    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    @Generated
    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    @Generated
    public BRelTime getWindow() {
        return (BRelTime)this.get(window);
    }

    @Generated
    public void setWindow(BRelTime v) {
        this.set(window, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        Combiner roll = this.getRollup().makeCombiner();
        if (!this.getInput(0).hasTrend(cx)) {
            roll.update(this.getInput(0).getValue(cx));
            return roll.getValue();
        }
        cx = new AnalyticContextWrapper(cx);
        BAbsTime end = Clock.time();
        BAbsTime start = end.subtract(this.getWindow());
        cx.setTimeRange(BAnalyticTimeRange.make(start, end));
        try (AnalyticTrend trend = this.getInput(0).getTrend(cx);){
            AnalyticValue val;
            long endTs = cx.getEndTime();
            while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), endTs)) {
                roll.update(val);
            }
            AnalyticValue analyticValue = roll.getValue();
            return analyticValue;
        }
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return this.getInput(0).hasTrend(cx);
    }

    private static class MyTrend
    extends BlockTrend {
        private List<AnalyticValue> rows = new LinkedList<AnalyticValue>();
        private Combiner roll;
        private long windowMillis;

        public MyTrend(BSlidingWindowBlock block, AnalyticContext cx) {
            super(block, cx);
            this.roll = block.getUseRequestRollup() ? cx.getRollup(true).makeCombiner() : block.getRollup().makeCombiner();
            this.windowMillis = block.getWindow().getMillis() - 1L;
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue val = this.getValue(0);
            this.rows.add(val.newCopy());
            long oldest = val.getTimestamp() - this.windowMillis;
            val = this.rows.get(0);
            while (val.getTimestamp() < oldest) {
                this.rows.remove(0);
                val = this.rows.get(0);
            }
            this.roll.reset();
            this.rows.forEach(this.roll);
            this.roll.getValue().setTimestamp(this.getValue(0).getTimestamp());
            return this.roll.getValue();
        }
    }
}

