/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.BDebugMode;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="in", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="debugMode", type="BDebugMode", defaultValue="BDebugMode.nextRequest", flags=8), @NiagaraProperty(name="printTrendsToConsole", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="result", type="String", defaultValue="", flags=11, facets={@Facet(value="makeTextFacets()")})})
@NiagaraActions(value={@NiagaraAction(name="enable"), @NiagaraAction(name="disable")})
public class BDebugBlock
extends BOutputBlock {
    @Generated
    public static final Property in = BDebugBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property enabled = BDebugBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property debugMode = BDebugBlock.newProperty((int)8, (BValue)BDebugMode.nextRequest, null);
    @Generated
    public static final Property printTrendsToConsole = BDebugBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property result = BDebugBlock.newProperty((int)11, (String)"", (BFacets)BDebugBlock.makeTextFacets());
    @Generated
    public static final Action enable = BDebugBlock.newAction((int)0, null);
    @Generated
    public static final Action disable = BDebugBlock.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDebugBlock.class);
    private static final BFacets showSeconds = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);

    @Generated
    public BBlockPin getIn() {
        return (BBlockPin)this.get(in);
    }

    @Generated
    public void setIn(BBlockPin v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BDebugMode getDebugMode() {
        return (BDebugMode)this.get(debugMode);
    }

    @Generated
    public void setDebugMode(BDebugMode v) {
        this.set(debugMode, (BValue)v, null);
    }

    @Generated
    public boolean getPrintTrendsToConsole() {
        return this.getBoolean(printTrendsToConsole);
    }

    @Generated
    public void setPrintTrendsToConsole(boolean v) {
        this.setBoolean(printTrendsToConsole, v, null);
    }

    @Generated
    public String getResult() {
        return this.getString(result);
    }

    @Generated
    public void setResult(String v) {
        this.setString(result, v, null);
    }

    @Generated
    public void enable() {
        this.invoke(enable, null, null);
    }

    @Generated
    public void disable() {
        this.invoke(disable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doDisable() {
        this.setEnabled(false);
    }

    public void doEnable() {
        this.setEnabled(true);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        AnalyticTrend res = this.getInput(0).getTrend(cx);
        if (this.getEnabled() && this.getDebugMode().debugTrendRequests()) {
            StringBuilder buf = new StringBuilder();
            buf.append(Utils.lex("trendRequest")).append(": ");
            this.encode(cx, buf);
            buf.append('\n');
            this.setResult(buf.toString());
            if (this.getPrintTrendsToConsole()) {
                System.out.println("##### Analytics Debug for algorithm " + this.getSlotPath());
                System.out.println("##### Node " + cx.getNodeTarget());
                res = new MyTrend(res, this.getName());
            }
            if (this.getDebugMode().isNextRequest()) {
                this.setEnabled(false);
            }
        }
        return res;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue res = this.getInputValue(0, cx);
        if (this.getEnabled() && this.getDebugMode().debugValueRequests()) {
            StringBuilder buf = new StringBuilder();
            buf.append(Utils.lex("valueRequest")).append(": ");
            this.encode(cx, buf);
            buf.append("\n  [").append(Utils.lex("result")).append("] ");
            buf.append(res.toString(cx)).append('\n');
            this.setResult(buf.toString());
            if (this.getDebugMode().isNextRequest()) {
                this.setEnabled(false);
            }
        }
        return res;
    }

    private void encode(AnalyticContext cx, StringBuilder buf) {
        buf.append(Clock.time().toString((Context)showSeconds)).append('\n');
        Map<String, String> map = Strings.decodeQueryString(cx.toString());
        boolean first = true;
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append("\n");
            }
            buf.append("  ");
            buf.append(e.getKey());
            buf.append(" = ");
            buf.append(e.getValue());
        }
    }

    private static BFacets makeTextFacets() {
        BFacets ret = BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE);
        ret = BFacets.make((BFacets)ret, (String)"fieldWidth", (BIDataValue)BInteger.make((int)100));
        return ret;
    }

    private static class MyTrend
    extends AbstractTrendWrapper {
        String blockName;

        public MyTrend(AnalyticTrend trend) {
            super(trend);
        }

        public MyTrend(AnalyticTrend trend, String name) {
            super(trend);
            this.blockName = name;
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.trend.hasNext()) {
                return null;
            }
            AnalyticValue next = this.trend.next();
            System.out.println(this.blockName + "," + BAbsTime.make((long)next.getTimestamp()) + "," + next.getValue());
            return next;
        }
    }
}

