/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="baselineIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="deadbandIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="deadbandMode", type="boolean", defaultValue="true", flags=8, facets={@Facet(value="BFacets.makeBoolean(Utils.lex(\"absolute\"),Utils.lex(\"percent\"))")}), @NiagaraProperty(name="percentMode", type="boolean", defaultValue="true", flags=8, facets={@Facet(value="BFacets.makeBoolean(Utils.lex(\"percent\"),Utils.lex(\"decimal\"))")})})
public class BDeadbandFilterBlock
extends BOutputBlock {
    @Generated
    public static final Property trendIn = BDeadbandFilterBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property baselineIn = BDeadbandFilterBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property deadbandIn = BDeadbandFilterBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property deadbandMode = BDeadbandFilterBlock.newProperty((int)8, (boolean)true, (BFacets)BFacets.makeBoolean((String)Utils.lex("absolute"), (String)Utils.lex("percent")));
    @Generated
    public static final Property percentMode = BDeadbandFilterBlock.newProperty((int)8, (boolean)true, (BFacets)BFacets.makeBoolean((String)Utils.lex("percent"), (String)Utils.lex("decimal")));
    @Generated
    public static final Type TYPE = Sys.loadType(BDeadbandFilterBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Generated
    public BBlockPin getBaselineIn() {
        return (BBlockPin)this.get(baselineIn);
    }

    @Generated
    public void setBaselineIn(BBlockPin v) {
        this.set(baselineIn, (BValue)v, null);
    }

    @Generated
    public BBlockPin getDeadbandIn() {
        return (BBlockPin)this.get(deadbandIn);
    }

    @Generated
    public void setDeadbandIn(BBlockPin v) {
        this.set(deadbandIn, (BValue)v, null);
    }

    @Generated
    public boolean getDeadbandMode() {
        return this.getBoolean(deadbandMode);
    }

    @Generated
    public void setDeadbandMode(boolean v) {
        this.setBoolean(deadbandMode, v, null);
    }

    @Generated
    public boolean getPercentMode() {
        return this.getBoolean(percentMode);
    }

    @Generated
    public void setPercentMode(boolean v) {
        this.setBoolean(percentMode, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    public boolean isAbsolute() {
        return this.getDeadbandMode();
    }

    public boolean isDecimal() {
        return !this.getPercentMode();
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return this.getInput(0).getValue(cx).setStatus(64);
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue base = this.getValue(1);
                AnalyticValue dead = this.getValue(2);
                double val = base.toNumeric();
                double band = 0.0;
                band = BDeadbandFilterBlock.this.isAbsolute() ? dead.toNumeric() : (BDeadbandFilterBlock.this.isDecimal() ? val * dead.toNumeric() : val * (dead.toNumeric() / 100.0));
                double min = val - band;
                double max = val + band;
                AnalyticValue in = this.getValue(0);
                val = in.toNumeric();
                if (!(val < min) && !(val > max)) continue;
                return in;
            }
            return null;
        }
    }
}

