/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.FunctionTrend;
import com.tridiumx.analytics.util.BOptionalSimple;
import com.tridiumx.analytics.util.Utils;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fallbackIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="data", type="String", defaultValue="", flags=8, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:DataFe\"))")}), @NiagaraProperty(name="useRequestAggregation", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="useRequestDataFilter", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="useRequestRollup", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="useRequestTotalize", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="aggregation", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)", flags=8), @NiagaraProperty(name="dataFilter", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BString.DEFAULT)", flags=8), @NiagaraProperty(name="relationId", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BString.DEFAULT)", flags=4), @NiagaraProperty(name="rollup", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)", flags=8), @NiagaraProperty(name="totalize", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.TRUE)", flags=8), @NiagaraProperty(name="unitConversion", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BUnit.NULL)", flags=8)})
public class BDataSourceBlock
extends BOutputBlock {
    @Generated
    public static final Property fallbackIn = BDataSourceBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property data = BDataSourceBlock.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")));
    @Generated
    public static final Property useRequestAggregation = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property useRequestDataFilter = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property useRequestRollup = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property useRequestTotalize = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property aggregation = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    @Generated
    public static final Property dataFilter = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BString.DEFAULT), null);
    @Generated
    public static final Property relationId = BDataSourceBlock.newProperty((int)4, (BValue)new BOptionalSimple(false, (BSimple)BString.DEFAULT), null);
    @Generated
    public static final Property rollup = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    @Generated
    public static final Property totalize = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.TRUE), null);
    @Generated
    public static final Property unitConversion = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BUnit.NULL), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDataSourceBlock.class);
    private static AcceptAll acceptAll = new AcceptAll();
    private Id id;

    @Generated
    public BBlockPin getFallbackIn() {
        return (BBlockPin)this.get(fallbackIn);
    }

    @Generated
    public void setFallbackIn(BBlockPin v) {
        this.set(fallbackIn, (BValue)v, null);
    }

    @Generated
    public String getData() {
        return this.getString(data);
    }

    @Generated
    public void setData(String v) {
        this.setString(data, v, null);
    }

    @Generated
    public boolean getUseRequestAggregation() {
        return this.getBoolean(useRequestAggregation);
    }

    @Generated
    public void setUseRequestAggregation(boolean v) {
        this.setBoolean(useRequestAggregation, v, null);
    }

    @Generated
    public boolean getUseRequestDataFilter() {
        return this.getBoolean(useRequestDataFilter);
    }

    @Generated
    public void setUseRequestDataFilter(boolean v) {
        this.setBoolean(useRequestDataFilter, v, null);
    }

    @Generated
    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    @Generated
    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    @Generated
    public boolean getUseRequestTotalize() {
        return this.getBoolean(useRequestTotalize);
    }

    @Generated
    public void setUseRequestTotalize(boolean v) {
        this.setBoolean(useRequestTotalize, v, null);
    }

    @Generated
    public BOptionalSimple getAggregation() {
        return (BOptionalSimple)this.get(aggregation);
    }

    @Generated
    public void setAggregation(BOptionalSimple v) {
        this.set(aggregation, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getDataFilter() {
        return (BOptionalSimple)this.get(dataFilter);
    }

    @Generated
    public void setDataFilter(BOptionalSimple v) {
        this.set(dataFilter, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getRelationId() {
        return (BOptionalSimple)this.get(relationId);
    }

    @Generated
    public void setRelationId(BOptionalSimple v) {
        this.set(relationId, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getRollup() {
        return (BOptionalSimple)this.get(rollup);
    }

    @Generated
    public void setRollup(BOptionalSimple v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getTotalize() {
        return (BOptionalSimple)this.get(totalize);
    }

    @Generated
    public void setTotalize(BOptionalSimple v) {
        this.set(totalize, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getUnitConversion() {
        return (BOptionalSimple)this.get(unitConversion);
    }

    @Generated
    public void setUnitConversion(BOptionalSimple v) {
        this.set(unitConversion, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (p.equals(data)) {
            this.id = null;
        }
        super.changed(p, cx);
    }

    public Id getDataId() {
        if (this.id == null) {
            this.id = Id.newId((String)this.getData());
        }
        return this.id;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        if (source == null || !source.hasTrend(cx) || Values.isNull(source.getValue(cx).getStatus())) {
            AlgorithmBlock fb = this.getInput(0);
            if (Utils.log().isLoggable(Level.FINER) && fb == null) {
                BINavNode parent = this.getNavParent();
                String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
                if (debugTrace != null && !debugTrace.isEmpty()) {
                    BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
                }
            }
            if (fb != null) {
                Utils.log().log(Level.INFO, "Using Fallback for trend request as data source " + this.getData() + " is not available");
                return fb.getTrend(cx);
            }
            return new EmptyTrend(cx);
        }
        AnalyticTrend trend = source.getTrend(this.prepare(cx));
        UnitConverter conv = this.getConverter(trend.getContext());
        if (conv == null) {
            return trend;
        }
        return new FunctionTrend(conv, trend);
    }

    protected static String prepareLogMessage(BINavNode node, Id id, BINavNode parent) {
        AnalyticContext oCx;
        String nodeName = null;
        String dataStr = null;
        String algName = null;
        String aSource = null;
        if (parent != null) {
            algName = parent.getNavName();
        }
        if (node != null && node.getNavOrd() != null) {
            nodeName = node.getNavOrd().toString();
        }
        if (id != null) {
            dataStr = id.getQName();
        }
        if (BAnalyticService.RequestContext.getReqOrigin() != null) {
            aSource = BAnalyticService.RequestContext.getReqOrigin().get();
        }
        if ((oCx = BAnalyticService.RequestContext.getReqAnalyticContext().get()) != null && oCx.getNode() != null && oCx.getNode().equals(node)) {
            return Utils.prepareDebugMessage(aSource, dataStr, nodeName, algName, null);
        }
        return null;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        if (source == null || Values.isNull(source.getValue(cx).getStatus())) {
            AlgorithmBlock fb = this.getInput(0);
            if (Utils.log().isLoggable(Level.FINER) && fb == null) {
                BINavNode parent = this.getNavParent();
                String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
                if (debugTrace != null && !debugTrace.isEmpty()) {
                    BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
                }
            }
            if (fb != null) {
                Utils.log().log(Level.INFO, "Using Fallback for value request as data source " + this.getData() + " is not available");
                return fb.getValue(cx);
            }
            return new NumericValue(0.0, 64);
        }
        UnitConverter conv = this.getConverter(cx = this.prepare(cx));
        if (conv != null) {
            return conv.apply(source.getValue(cx));
        }
        return source.getValue(cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        cx = this.prepare(cx);
        if (source != null && source.hasTrend(cx)) {
            return true;
        }
        int len = this.getInputCount();
        for (int i = 0; i < len; ++i) {
            AlgorithmBlock input = this.getInput(i);
            if (input == null || !input.hasTrend(cx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable(BINavNode node) {
        Id id = this.getDataId();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(id, true, null);
        if (source != null) {
            return true;
        }
        AlgorithmBlock fb = this.getInput(0);
        if (fb != null) {
            return fb.isAvailable(node);
        }
        if (Utils.log().isLoggable(Level.FINER)) {
            BINavNode parent = this.getNavParent();
            String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
            if (debugTrace != null && !debugTrace.isEmpty()) {
                BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
            }
        }
        return false;
    }

    @Override
    public boolean isInputRequired(int idx) {
        return false;
    }

    protected AnalyticContext prepare(AnalyticContext cx) {
        String idStr;
        AnalyticContextWrapper ret = new AnalyticContextWrapper(cx);
        ret.setData(this.getDataId());
        if (this.getRelationId().getHasValue() && (idStr = this.getRelationId().getValue().toString(null)).length() > 0) {
            Entity tmp;
            Optional rel;
            Id id = Id.newId((String)idStr);
            BINavNode node = cx.getNode();
            if (node instanceof Entity && (rel = ((Entity)node).relations().get(id)).isPresent() && (tmp = ((Relation)rel.get()).getEndpoint()) instanceof BINavNode) {
                ret.setNode((BINavNode)tmp);
            }
        }
        if (!this.getUseRequestDataFilter()) {
            if (this.getDataFilter().getHasValue()) {
                String neql = this.getDataFilter().getValue().toString(null);
                if (neql.length() > 0) {
                    ret.setDataFilter(neql);
                } else {
                    ret.setDataFilter(acceptAll);
                }
            } else {
                ret.setDataFilter(acceptAll);
            }
        }
        if (this.getUseRequestAggregation()) {
            ret.setAggregation(cx.getAggregation(true));
        } else if (this.getAggregation().getHasValue()) {
            ret.setAggregation((BCombination)this.getAggregation().getValue());
        } else {
            ret.setAggregation(ret.getDataPolicy().getDefaultAggregation());
        }
        if (this.getUseRequestRollup()) {
            ret.setRollup(cx.getRollup(true));
        } else if (this.getRollup().getHasValue()) {
            ret.setRollup((BCombination)this.getRollup().getValue());
        } else {
            ret.setRollup(ret.getDataPolicy().getDefaultRollup());
        }
        ret.setUseCache(false);
        if (this.getUnitConversion().getHasValue()) {
            ret.setUnit((BUnit)this.getUnitConversion().getValue());
        }
        if (this.getUseRequestTotalize()) {
            ret.setHisTotEnabled(cx.getHisTotEnabled());
        } else if (this.getTotalize().getHasValue()) {
            ret.setHisTotEnabled(((BBoolean)this.getTotalize().getValue()).getBoolean());
        } else {
            ret.setHisTotEnabled(true);
        }
        return ret;
    }

    private UnitConverter getConverter(AnalyticContext cx) {
        if (!this.getUnitConversion().getHasValue()) {
            return null;
        }
        BUnit to = (BUnit)this.getUnitConversion().getValue();
        return UnitConverter.make(cx.getUnit(true), to);
    }

    private static class AcceptAll
    implements Predicate<Entity> {
        private AcceptAll() {
        }

        @Override
        public boolean test(Entity e) {
            return true;
        }

        public String toString() {
            return "";
        }
    }
}

