/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.alert;

import com.tridiumx.analytics.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;

@NiagaraType
public final class BAlertMode
extends BSimple
implements AnalyticConstants {
    public static final String STR_HOURS = "hours";
    @Deprecated
    public static final String STR_MILLIS = "millis";
    public static final String STR_MINUTES = "minutes";
    public static final String STR_OCCURRENCES = "occurrences";
    public static final String STR_SECONDS = "seconds";
    public static final int MODE_HOURS = 0;
    @Deprecated
    public static final int MODE_MILLIS = 1;
    public static final int MODE_MINUTES = 2;
    public static final int MODE_OCCURRENCES = 3;
    public static final int MODE_SECONDS = 4;
    public static final BAlertMode DEFAULT = new BAlertMode("1", 3, "default");
    public static final BAlertMode NULL = new BAlertMode("0", 3, "null");
    public static final Type TYPE = Sys.loadType(BAlertMode.class);
    private int mode = 3;
    private String value;
    private String quantity;

    public Type getType() {
        return TYPE;
    }

    private BAlertMode() {
    }

    private BAlertMode(String quantity, int mode, String value) {
        this.quantity = quantity;
        this.mode = mode;
        this.value = value;
    }

    public double convertMillis(long millis) {
        double ms = millis;
        switch (this.mode) {
            case 4: {
                return ms / 1000.0;
            }
            case 2: {
                return ms / 60000.0;
            }
            case 0: {
                return ms / 3600000.0;
            }
        }
        return ms;
    }

    public BObject decode(DataInput in) throws IOException {
        return BAlertMode.make(in.readUTF());
    }

    public BObject decodeFromString(String s) {
        return BAlertMode.make(s);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    public String encodeToString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAlertMode) {
            BAlertMode other = (BAlertMode)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeString() {
        switch (this.mode) {
            case 0: {
                return STR_HOURS;
            }
            case 1: {
                return STR_MILLIS;
            }
            case 2: {
                return STR_MINUTES;
            }
            case 3: {
                return STR_OCCURRENCES;
            }
            case 4: {
                return STR_SECONDS;
            }
        }
        throw new IllegalStateException(Utils.lex("unknownMode") + ": " + this.mode);
    }

    public String getQuantity() {
        return this.quantity;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isAlert(double arg) {
        return arg >= Double.valueOf(this.quantity);
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isRuntime() {
        return this.mode != 3;
    }

    public static BAlertMode make(String s) {
        if (s.equals("null")) {
            return NULL;
        }
        if (s.equals("default")) {
            return DEFAULT;
        }
        s = s.toLowerCase();
        int idx = BAlertMode.getIdx(s);
        int mode = BAlertMode.getMode(s);
        String code = s.substring(0, idx).trim();
        String value = s.substring(idx, s.length());
        String codeValue = code + " " + value;
        if (mode == 0) {
            return new BAlertMode(code, 0, codeValue);
        }
        if (mode == 1) {
            return new BAlertMode(code, 1, codeValue);
        }
        if (mode == 2) {
            return new BAlertMode(code, 2, codeValue);
        }
        if (mode == 3) {
            if (codeValue.contains(".")) {
                String occurrencesValue = "";
                occurrencesValue = codeValue.substring(0, s.indexOf("."));
                occurrencesValue = occurrencesValue + " " + value;
                return new BAlertMode(code, 3, occurrencesValue);
            }
            return new BAlertMode(code, 3, codeValue);
        }
        if (mode == 4) {
            return new BAlertMode(code, 4, codeValue);
        }
        throw new IllegalArgumentException(codeValue);
    }

    private static int getIdx(String s) {
        int idx;
        block7: {
            idx = -1;
            idx = s.indexOf(STR_HOURS.trim().toLowerCase());
            if (idx == -1) {
                idx = s.indexOf(STR_MINUTES.trim().toLowerCase());
            }
            if (idx == -1) {
                idx = s.indexOf(STR_OCCURRENCES.trim().toLowerCase());
            }
            if (idx == -1) {
                idx = s.indexOf(STR_SECONDS.trim().toLowerCase());
            }
            if (idx == -1) {
                idx = s.indexOf(STR_MILLIS.trim().toLowerCase());
            }
            String index = "";
            int code = 0;
            if (s.substring(0, idx).toString().trim().contains(".")) {
                index = s.substring(0, idx).toString().trim();
                for (int i = 0; i <= index.length(); ++i) {
                    ++code;
                }
            } else {
                code = Integer.valueOf(s.substring(0, idx).toString().trim());
            }
            if (idx <= -1 || code < 10 || !s.contains(" ")) break block7;
            --idx;
        }
        return idx;
    }

    public static int getMode(String s) {
        if (s.indexOf(STR_HOURS.trim().toLowerCase()) > 0) {
            return 0;
        }
        if (s.indexOf(STR_MINUTES.trim().toLowerCase()) > 0) {
            return 2;
        }
        if (s.indexOf(STR_OCCURRENCES.trim().toLowerCase()) > 0) {
            return 3;
        }
        if (s.indexOf(STR_SECONDS.trim().toLowerCase()) > 0) {
            return 4;
        }
        return 1;
    }

    public String toString(Context cx) {
        return this.value;
    }
}

