/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BOrFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BOrFunction.class);
    private static final Lexicon lex = Lexicon.make(BOrFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.or");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.or");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BBoolean result = BBoolean.make((boolean)false);
        for (int i = 0; i < srcProps.length; ++i) {
            String name = srcProps[i];
            List records = this.getSeriesRecords(series, BOrFunction.getSeriesName((String)name));
            if (records == null) continue;
            for (BComplex record : records) {
                Property field = record.getProperty(BOrFunction.getFieldName((String)name));
                BValue value = record.get(field);
                try {
                    BBoolean bool = (BBoolean)value;
                    if (!bool.isActive()) continue;
                    result = BBoolean.make((boolean)true);
                }
                catch (Exception e) {
                    System.out.println("Failed to determine value for field " + field);
                    e.printStackTrace();
                }
            }
        }
        BOrFunction.setRecordValue((BComplex)resultRecord, (Property)destProp, (BValue)result);
    }

    public Type[] getArgumentTypes() {
        Type[] types = new Type[]{BBoolean.TYPE};
        return types;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public Type getReturnType() {
        return BBoolean.TYPE;
    }
}

