/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class BMultiplyFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BMultiplyFunction.class);
    private static final Lexicon lex = Lexicon.make(BMultiplyFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.multiply");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.multiply");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BNumber[] multiply = new BNumber[srcProps.length];
        int i = 0;
        BNumber product = null;
        BUnit dstUnits = BMultiplyFunction.getUnits((Property)dstSlot);
        Object srcUnits = null;
        BFacets srcFacets = null;
        for (String name : srcProps) {
            String seriesName = BMultiplyFunction.getSeriesName((String)name);
            String fieldName = BMultiplyFunction.getFieldName((String)name);
            List records = this.getSeriesRecords(series, seriesName);
            for (BComplex record : records) {
                Property srcProp = record.getProperty(fieldName);
                srcFacets = srcProp.getFacets();
                try {
                    BNumber check = this.sumValues(multiply[i], record, srcProp, dstUnits);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    multiply[i] = check;
                }
                catch (SourceException e) {
                    multiply[i] = BDouble.NaN;
                }
            }
            ++i;
        }
        if (multiply[0] != null && !multiply[0].equals((Object)BDouble.NaN)) {
            product = multiply[0];
            for (int j = 1; j < i; ++j) {
                try {
                    BNumber check = this.multiplyValues(product, multiply[j]);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    product = check;
                    continue;
                }
                catch (Exception e) {
                    product = BDouble.NaN;
                }
            }
        }
        BMultiplyFunction.setRecordValue((BComplex)resultRecord, (Property)dstSlot, product);
    }

    protected BNumber sumValues(BNumber curSum, BComplex source, Property field, BUnit dstUnits) throws SourceException {
        BUnit origUnits;
        BValue value = source.get(field);
        BFacets facets = field.getFacets();
        BUnit bUnit = origUnits = facets != null ? (BUnit)facets.get("units") : BUnit.NULL;
        if (value instanceof BNumber) {
            BNumber number = BMultiplyFunction.convertToUnits((BNumber)((BNumber)value), (BUnit)origUnits, (BUnit)dstUnits);
            curSum = null == curSum ? number : this.addValues(number, curSum);
        }
        return curSum;
    }

    protected BNumber addValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() + b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() + b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() + b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() + b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() + b.getDouble()));
    }

    protected BNumber multiplyValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() * b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() * b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() * b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() * b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() * b.getDouble()));
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public Type getReturnType() {
        return BNumber.TYPE;
    }

    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }
}

