/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform;

import com.vykon.vykonPro.util.BVykonProService;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BTableToHistory
extends BComponent {
    public static final Property ord = BTableToHistory.newProperty((int)256, (BValue)BOrd.NULL, null);
    public static final Property lastExecutionTime = BTableToHistory.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property faultCause = BTableToHistory.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)120)));
    public static final Property status = BTableToHistory.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property historyConfig = BTableToHistory.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    public static final Property interval = BTableToHistory.newProperty((int)256, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property deleteRecordsOnSplit = BTableToHistory.newProperty((int)256, (boolean)false, null);
    public static final Property deleteRecordsOnExecute = BTableToHistory.newProperty((int)256, (boolean)false, null);
    public static final Property historyDeviceName = BTableToHistory.newProperty((int)256, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%"), null);
    public static final Property useComponentOrd = BTableToHistory.newProperty((int)256, (boolean)false, null);
    public static final Action execute = BTableToHistory.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BTableToHistory.class);
    private BITable result = null;
    private TableCursor c = null;
    int colCount = -1;
    Column[] cols = null;
    BFacets[] colFacets = null;
    int statusCol = -1;
    int flagsCol = -1;
    int recordType = -1;

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BAbsTime getLastExecutionTime() {
        return (BAbsTime)this.get(lastExecutionTime);
    }

    public void setLastExecutionTime(BAbsTime v) {
        this.set(lastExecutionTime, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    public boolean getDeleteRecordsOnSplit() {
        return this.getBoolean(deleteRecordsOnSplit);
    }

    public void setDeleteRecordsOnSplit(boolean v) {
        this.setBoolean(deleteRecordsOnSplit, v, null);
    }

    public boolean getDeleteRecordsOnExecute() {
        return this.getBoolean(deleteRecordsOnExecute);
    }

    public void setDeleteRecordsOnExecute(boolean v) {
        this.setBoolean(deleteRecordsOnExecute, v, null);
    }

    public BFormat getHistoryDeviceName() {
        return (BFormat)this.get(historyDeviceName);
    }

    public void setHistoryDeviceName(BFormat v) {
        this.set(historyDeviceName, (BValue)v, null);
    }

    public boolean getUseComponentOrd() {
        return this.getBoolean(useComponentOrd);
    }

    public void setUseComponentOrd(boolean v) {
        this.setBoolean(useComponentOrd, v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkForService();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(interval)) {
            this.getHistoryConfig().setInterval(BCollectionInterval.make((BRelTime)this.getInterval()));
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == execute) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.updateFault("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.updateFault("The vykonPro service is disabled");
        } else {
            this.updateFault("");
        }
    }

    public void doExecute() throws Exception {
        block68: {
            if (!this.isRunning()) {
                return;
            }
            if (this.getStatus().isFault()) {
                this.checkForService();
                if (this.getStatus().isFault()) {
                    return;
                }
            }
            this.updateFault("");
            this.setLastExecutionTime(Clock.time());
            try {
                this.result = (BITable)this.getOrd().resolve((BObject)this).get();
                if (this.result != null) {
                    this.cols = this.result.getColumns().list();
                    this.colFacets = new BFacets[this.cols.length];
                    BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                    try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                        BIHistory history = null;
                        BTimeZone tzone = null;
                        String station = SlotPath.escape((String)SlotPath.unescape((String)this.getHistoryDeviceName().format((Object)this)));
                        if (localDb == null) {
                            this.updateFault("Local history database not available.");
                            return;
                        }
                        if (!this.cols[0].getType().is(BAbsTime.TYPE)) {
                            this.updateFault("The first column in the result set must be a timestamp");
                            return;
                        }
                        tzone = (BTimeZone)this.cols[0].getFacets().get("TimeZone");
                        for (int j = 1; j < this.cols.length; ++j) {
                            int statusCol = -1;
                            int flagsCol = -1;
                            int recordType = -1;
                            this.colFacets[j] = this.cols[j].getFacets();
                            BObject sName = this.colFacets[j].get("SERIES_NAME");
                            String name = this.cols[j].getDisplayName(null);
                            if (sName != null) {
                                name = sName.toString(null);
                            }
                            BHistoryConfig config = this.getHistoryConfig();
                            BOrdList source = null;
                            source = this.getUseComponentOrd() ? BOrdList.make((BOrd)this.getSourceOrd()) : BOrdList.make((BOrd)this.getOrd());
                            config.setSource(source);
                            if (tzone != null) {
                                config.setTimeZone(tzone);
                            }
                            BHistoryId id = BHistoryId.make((String)station, (String)name);
                            config.setId(id);
                            if (config.get("valueFacets") == null) {
                                config.add("valueFacets", (BValue)this.colFacets[j]);
                            } else {
                                config.set("valueFacets", (BValue)this.colFacets[j]);
                            }
                            if (this.cols[j].getType().is(BBoolean.TYPE)) {
                                config.setRecordType(BTypeSpec.make((String)"history", (String)"BooleanTrendRecord"));
                                recordType = 1;
                            } else if (this.cols[j].getType().is(BNumber.TYPE)) {
                                config.setRecordType(BTypeSpec.make((String)"history", (String)"NumericTrendRecord"));
                                recordType = 2;
                            } else if (this.cols[j].getType().is(BEnum.TYPE)) {
                                config.setRecordType(BTypeSpec.make((String)"history", (String)"EnumTrendRecord"));
                                recordType = 3;
                            } else if (this.cols[j].getType().is(BString.TYPE)) {
                                config.setRecordType(BTypeSpec.make((String)"history", (String)"StringTrendRecord"));
                                recordType = 4;
                            } else if (this.cols[j].getType().is(BStatus.TYPE)) {
                                statusCol = j;
                            } else if (this.cols[j].getType().is(BTrendFlags.TYPE)) {
                                flagsCol = j;
                            }
                            config.setInterval(BCollectionInterval.make((BRelTime)this.getInterval()));
                            if (!conn.exists(id)) {
                                conn.createHistory(config);
                                history = conn.getHistory(id);
                            } else {
                                history = conn.getHistory(id);
                                if (this.getDeleteRecordsOnExecute()) {
                                    conn.clearAllRecords(id);
                                } else if (!history.getConfig().equivalent((Object)config)) {
                                    if (this.getDeleteRecordsOnSplit()) {
                                        conn.clearAllRecords(id);
                                        conn.reconfigureHistory(config);
                                    } else {
                                        conn.recreateHistory(config, true);
                                    }
                                }
                            }
                            BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                            try (TableCursor c = this.result.cursor();){
                                BBooleanTrendRecord rec;
                                BAbsTime timestamp;
                                if (recordType == 1) {
                                    while (c.next()) {
                                        timestamp = (BAbsTime)c.cell(this.cols[0]);
                                        if (lastTimestamp == null || !timestamp.isAfter(lastTimestamp)) continue;
                                        rec = new BBooleanTrendRecord();
                                        rec.setValue(((BBoolean)c.cell(this.cols[j])).getBoolean());
                                        rec.setTimestamp(timestamp);
                                        conn.append(history, (BIHistoryRecordSet)rec);
                                    }
                                    continue;
                                }
                                if (recordType == 2) {
                                    while (c.next()) {
                                        timestamp = (BAbsTime)c.cell(this.cols[0]);
                                        if (lastTimestamp == null || !timestamp.isAfter(lastTimestamp)) continue;
                                        rec = new BNumericTrendRecord();
                                        rec.setValue(((BDouble)c.cell(this.cols[j])).getDouble());
                                        rec.setTimestamp(timestamp);
                                        conn.append(history, (BIHistoryRecordSet)rec);
                                    }
                                    continue;
                                }
                                if (recordType == 3) {
                                    while (c.next()) {
                                        timestamp = (BAbsTime)c.cell(this.cols[0]);
                                        if (lastTimestamp == null || !timestamp.isAfter(lastTimestamp)) continue;
                                        rec = new BEnumTrendRecord();
                                        rec.setValue(BDynamicEnum.make((int)((BInteger)c.cell(this.cols[j])).getInt()));
                                        rec.setTimestamp(timestamp);
                                        conn.append(history, (BIHistoryRecordSet)rec);
                                    }
                                    continue;
                                }
                                if (recordType != 4) continue;
                                while (c.next()) {
                                    timestamp = (BAbsTime)c.cell(this.cols[0]);
                                    if (lastTimestamp == null || !timestamp.isAfter(lastTimestamp)) continue;
                                    rec = new BStringTrendRecord();
                                    rec.setValue(c.cell(this.cols[j]).toString(null));
                                    rec.setTimestamp(timestamp);
                                    conn.append(history, (BIHistoryRecordSet)rec);
                                }
                                continue;
                            }
                        }
                        break block68;
                    }
                }
                this.updateFault("Result set does not contain any records.");
            }
            catch (Exception e) {
                this.updateFault("Failed to generate report.");
                System.out.println(this.getSlotPath() + " , failed to generate report");
                e.printStackTrace();
            }
        }
    }

    private void updateFault(String faults) {
        if (faults.length() > 0) {
            this.setFaultCause(faults);
            this.setStatus(BStatus.fault);
        } else {
            this.setFaultCause("");
            this.setStatus(BStatus.ok);
        }
    }

    public BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }
}

