/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.condition.BAlways;
import com.tridium.tagdictionary.tag.BTagGroupNameTag;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIDataPolicy;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.data.BDataPolicy;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ICoalesceable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="validity", type="BTagRuleCondition", defaultValue="new BAlways()"), @NiagaraProperty(name="tagList", type="BTagInfoList", defaultValue="new BTagInfoList()")})
@NiagaraAction(name="addDataPolicy", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT")
public class BTagGroupInfo
extends BComponent
implements TagGroupInfo,
BIDataPolicy,
BIRestrictedComponent {
    @Generated
    public static final Property validity = BTagGroupInfo.newProperty((int)0, (BValue)new BAlways(), null);
    @Generated
    public static final Property tagList = BTagGroupInfo.newProperty((int)0, (BValue)new BTagInfoList(), null);
    @Generated
    public static final Action addDataPolicy = BTagGroupInfo.newAction((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTagGroupInfo.class);
    private static final BIcon icon = BIcon.std((String)"tag.png");
    private static final String TAG_GROUP_RELATION_STR = BNiagaraTagDictionary.TAG_GROUP_RELATION.toString();
    private Id groupId;

    @Generated
    public BTagRuleCondition getValidity() {
        return (BTagRuleCondition)this.get(validity);
    }

    @Generated
    public void setValidity(BTagRuleCondition v) {
        this.set(validity, (BValue)v, null);
    }

    @Generated
    public BTagInfoList getTagList() {
        return (BTagInfoList)this.get(tagList);
    }

    @Generated
    public void setTagList(BTagInfoList v) {
        this.set(tagList, (BValue)v, null);
    }

    @Generated
    public void addDataPolicy(BDynamicEnum parameter) {
        this.invoke(addDataPolicy, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.updateAddDataPolicyActionFlags();
    }

    public Optional<TagDictionary> getDictionary() {
        return BTagDictionary.getParentDictionary(this);
    }

    public Id getGroupId() {
        if (this.isRunning() && this.groupId != null) {
            return this.groupId;
        }
        this.groupId = TagDictionaryUtil.generateId(this, this::getDictionary);
        return this.groupId;
    }

    public void groupRenamed() {
        this.groupId = null;
        this.groupId = this.getGroupId();
    }

    public boolean isIdealFor(Type type) {
        return this.getValidity().testIdealMatch(type);
    }

    public boolean isValidFor(Entity entity) {
        return this.getValidity().test(entity);
    }

    public Iterator<TagInfo> getTags() {
        return this.getTagList().iterator();
    }

    public static ArrayList<TagGroupInfo> getValidTagGroups(TagDictionary dictionary, BComponent parent, Type childType) {
        BObject childTypeInstance = childType.getInstance();
        ArrayList<TagGroupInfo> list = new ArrayList<TagGroupInfo>();
        if (childTypeInstance instanceof BComponent) {
            BComponent childComp = childTypeInstance.asComponent();
            BRelation relation = new BRelation(BNiagaraTagDictionary.PARENT, parent);
            childComp.relations().add((Relation)relation);
            Iterator tagGroups = dictionary.getTagGroups();
            while (tagGroups.hasNext()) {
                TagGroupInfo tagGroup = (TagGroupInfo)tagGroups.next();
                if (!tagGroup.isValidFor((Entity)childComp)) continue;
                list.add(tagGroup);
            }
        }
        return list;
    }

    public Optional<TagInfo> getNameTagInfo() {
        return Optional.of(new BTagGroupNameTag(this));
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context context) {
        if (!(parent instanceof BTagGroupInfoList)) {
            TagDictionaryUtil.handleIllegalParent(parent, this, context);
        }
    }

    public Optional<DataPolicy> getDataPolicy() {
        BDataPolicy[] children = (BDataPolicy[])this.getChildren(BDataPolicy.class);
        if (children == null || children.length == 0) {
            return Optional.empty();
        }
        return Optional.of(children[0]);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (Context.commit.equals(context)) {
            return;
        }
        if (this.getDataPolicy().isPresent()) {
            throw new LocalizableRuntimeException("tagdictionary", "tagGroupInfo.oneDataPolicy");
        }
    }

    public void added(Property p, Context cx) {
        if (this.get(p).getType().is(BDataPolicy.TYPE)) {
            this.updateAddDataPolicyActionFlags();
        }
    }

    public void relationKnobAdded(RelationKnob knob, Context context) {
        TagDictionaryService service;
        BOrd slotPathOrd;
        if (BTagGroupInfo.isTagGroupRelationKnob(knob) && !BTagGroupInfo.doesEndpointOrdMatch(knob, slotPathOrd = this.getSlotPathOrd()) && (service = this.getTagDictionaryService()) instanceof BTagDictionaryService) {
            ((BTagDictionaryService)service).addTask(new FixEndpointOrdTask(knob.getRelation(), slotPathOrd));
        }
    }

    static boolean isTagGroupRelationKnob(RelationKnob knob) {
        return TAG_GROUP_RELATION_STR.equals(knob.getRelationId());
    }

    private static boolean doesEndpointOrdMatch(RelationKnob knob, BOrd slotPathOrd) {
        return knob.getRelation().getEndpointOrd().equals((Object)slotPathOrd);
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        if (oldValue.getType().is(BDataPolicy.TYPE)) {
            this.updateAddDataPolicyActionFlags();
        }
    }

    private void updateAddDataPolicyActionFlags() {
        if (this.getDataPolicy().isPresent()) {
            this.setFlags((Slot)addDataPolicy, this.getFlags((Slot)addDataPolicy) | 4);
        } else {
            this.setFlags((Slot)addDataPolicy, this.getFlags((Slot)addDataPolicy) & 0xFFFFFFFB);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(addDataPolicy)) {
            TypeInfo[] concreteTypes = Sys.getRegistry().getConcreteTypes(BDataPolicy.TYPE.getTypeInfo());
            String[] tags = new String[concreteTypes.length];
            for (int i = 0; i < concreteTypes.length; ++i) {
                tags[i] = SlotPath.escape((String)concreteTypes[i].getTypeSpec().toString());
            }
            BEnumRange range = BEnumRange.make((String[])tags);
            return BDynamicEnum.make((int)0, (BEnumRange)range);
        }
        return super.getActionParameterDefault(action);
    }

    public void doAddDataPolicy(BDynamicEnum selected) {
        BTypeSpec typeSpec = BTypeSpec.make((String)SlotPath.unescape((String)selected.getTag()));
        this.add("dp_" + this.getName(), typeSpec.getInstance().asValue());
    }

    public synchronized boolean equivalent(Object obj) {
        if (!(obj instanceof BTagGroupInfo)) {
            return false;
        }
        try {
            this.updateAddDataPolicyActionFlags();
            ((BTagGroupInfo)((Object)obj)).updateAddDataPolicyActionFlags();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.equivalent(obj);
    }

    public void encodeToJson(JSONWriter writer) {
        if (!this.getValidity().getType().is(BAlways.TYPE)) {
            writer.key("validity");
            writer.object();
            BTagRuleCondition tagRuleCondition = this.getValidity();
            writer.key("type").value((Object)tagRuleCondition.getType());
            tagRuleCondition.encodeToJson(writer);
            writer.endObject();
        }
        writer.key("tags");
        this.getTagList().encodeToJson(writer);
    }

    public void decodeFromJson(JSONObject tagGroupJson) {
        JSONObject validityJson = tagGroupJson.optJSONObject("validity", null);
        if (validityJson != null) {
            TypeInfo validityType = ImportUtil.decodeType(validityJson.getString("type"), BTagRuleCondition.TYPE);
            BTagRuleCondition tagRuleCondition = (BTagRuleCondition)validityType.getInstance();
            tagRuleCondition.decodeFromJson(validityJson);
            this.setValidity(tagRuleCondition);
        }
        BTagInfoList tagInfoList = new BTagInfoList();
        tagInfoList.decodeFromJson(tagGroupJson.getJSONArray("tags"));
        this.setTagList(tagInfoList);
    }

    public BIcon getIcon() {
        return icon;
    }

    private static final class FixEndpointOrdTask
    implements ICoalesceable,
    Runnable {
        private final BRelation relation;
        private final BOrd slotPathOrd;

        public FixEndpointOrdTask(BRelation relation, BOrd slotPathOrd) {
            this.relation = relation;
            this.slotPathOrd = slotPathOrd;
        }

        @Override
        public void run() {
            this.relation.setEndpointOrd(this.slotPathOrd);
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixEndpointOrdTask that = (FixEndpointOrdTask)o;
            return Objects.equals(this.relation, that.relation);
        }

        public int hashCode() {
            return this.relation.hashCode();
        }
    }
}

