/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.sys.tag.ComponentRelations;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.tagdictionary.TagRuleIndex;
import com.tridium.tagdictionary.neqlize.BNeqlizeOptions;
import com.tridium.tagdictionary.util.EntityTagIndex;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.SmartTagDictionary;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.tagdictionary.TagRule;
import javax.baja.tagdictionary.data.BTagGroupMonitor;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Worker;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultNamespaceId", type="String", defaultValue=""), @NiagaraProperty(name="tagRuleIndexEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="indexedTags", type="String", defaultValue=""), @NiagaraProperty(name="neqlizeOptions", type="BNeqlizeOptions", defaultValue="BNeqlizeOptions.DEFAULT"), @NiagaraProperty(name="Niagara", type="BNiagaraTagDictionary", defaultValue="new BNiagaraTagDictionary()"), @NiagaraProperty(name="schemaVersion", type="int", defaultValue="0", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="clearTagRuleIndex"), @NiagaraAction(name="invalidateAllTagIndexes"), @NiagaraAction(name="invalidateSingleTagIndex", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="query", parameterType="BString", defaultValue="BString.make(\"\")", flags=20, deprecated=true), @NiagaraAction(name="tagsToTagGroup", returnType="BComponent", flags=4)})
public class BTagDictionaryService
extends BAbstractService
implements TagDictionaryService,
BIRestrictedComponent,
NavListener {
    @Generated
    public static final Property defaultNamespaceId = BTagDictionaryService.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property tagRuleIndexEnabled = BTagDictionaryService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property indexedTags = BTagDictionaryService.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property neqlizeOptions = BTagDictionaryService.newProperty((int)0, (BValue)BNeqlizeOptions.DEFAULT, null);
    @Generated
    public static final Property Niagara = BTagDictionaryService.newProperty((int)0, (BValue)new BNiagaraTagDictionary(), null);
    @Generated
    public static final Property schemaVersion = BTagDictionaryService.newProperty((int)5, (int)0, null);
    @Generated
    public static final Action clearTagRuleIndex = BTagDictionaryService.newAction((int)0, null);
    @Generated
    public static final Action invalidateAllTagIndexes = BTagDictionaryService.newAction((int)0, null);
    @Generated
    public static final Action invalidateSingleTagIndex = BTagDictionaryService.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Deprecated
    @Generated
    public static final Action query = BTagDictionaryService.newAction((int)20, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action tagsToTagGroup = BTagDictionaryService.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTagDictionaryService.class);
    private static final Type[] TYPES = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"navOnly/tagDictionaryService.png");
    private final AtomicReference<List<SmartTagDictionary>> plainSmartDictionaries = new AtomicReference();
    private final TagRuleIndex tagRuleIndex = new TagRuleIndex();
    private final TagRuleIndex relationRuleIndex = new TagRuleIndex();
    private TagRuleIndexTypeSubscriber tagRuleIndexTypeSubscriber;
    private NeqlizeOptionsTypeSubscriber neqlizeOptionsTypeSubscriber;
    private final EntityTagIndex impliedTagIndex = new EntityTagIndex();
    private static final String DISABLE_TAG_INDEXING_SYS_PROP = "niagara.tagdictionary.disableTagIndexing";
    private final boolean disableTagIndexing = AccessController.doPrivileged(() -> Boolean.getBoolean(DISABLE_TAG_INDEXING_SYS_PROP));
    public static final String LOGGER_NAME = "tagdictionary";
    private static final Logger logger = Logger.getLogger("tagdictionary");
    private static final Logger neqlLogger = Logger.getLogger("tagdictionary.neqlize");
    private static Map<String, Optional<SmartTagDictionary>> smartTagDictionaryCache;
    private Worker worker;
    private final CoalesceQueue taskQueue = new CoalesceQueue();

    @Generated
    public String getDefaultNamespaceId() {
        return this.getString(defaultNamespaceId);
    }

    @Generated
    public void setDefaultNamespaceId(String v) {
        this.setString(defaultNamespaceId, v, null);
    }

    @Generated
    public boolean getTagRuleIndexEnabled() {
        return this.getBoolean(tagRuleIndexEnabled);
    }

    @Generated
    public void setTagRuleIndexEnabled(boolean v) {
        this.setBoolean(tagRuleIndexEnabled, v, null);
    }

    @Generated
    public String getIndexedTags() {
        return this.getString(indexedTags);
    }

    @Generated
    public void setIndexedTags(String v) {
        this.setString(indexedTags, v, null);
    }

    @Generated
    public BNeqlizeOptions getNeqlizeOptions() {
        return (BNeqlizeOptions)this.get(neqlizeOptions);
    }

    @Generated
    public void setNeqlizeOptions(BNeqlizeOptions v) {
        this.set(neqlizeOptions, (BValue)v, null);
    }

    @Generated
    public BNiagaraTagDictionary getNiagara() {
        return (BNiagaraTagDictionary)this.get(Niagara);
    }

    @Generated
    public void setNiagara(BNiagaraTagDictionary v) {
        this.set(Niagara, (BValue)v, null);
    }

    @Generated
    public int getSchemaVersion() {
        return this.getInt(schemaVersion);
    }

    @Generated
    public void setSchemaVersion(int v) {
        this.setInt(schemaVersion, v, null);
    }

    @Generated
    public void clearTagRuleIndex() {
        this.invoke(clearTagRuleIndex, null, null);
    }

    @Generated
    public void invalidateAllTagIndexes() {
        this.invoke(invalidateAllTagIndexes, null, null);
    }

    @Generated
    public void invalidateSingleTagIndex(BString parameter) {
        this.invoke(invalidateSingleTagIndex, (BValue)parameter, null);
    }

    @Deprecated
    @Generated
    public void query(BString parameter) {
        this.invoke(query, (BValue)parameter, null);
    }

    @Generated
    public BComponent tagsToTagGroup() {
        return (BComponent)this.invoke(tagsToTagGroup, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning()) {
            this.rebuildPlainSmartDictionaryList();
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (this.isRunning()) {
            this.rebuildPlainSmartDictionaryList();
        }
    }

    private void rebuildPlainSmartDictionaryList() {
        ArrayList<SmartTagDictionary> plainDictionaries = new ArrayList<SmartTagDictionary>();
        for (SmartTagDictionary smart : this.getSmartTagDictionaries()) {
            if (smart instanceof BSmartTagDictionary) continue;
            plainDictionaries.add(smart);
        }
        this.plainSmartDictionaries.set(plainDictionaries);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(enabled)) {
            if (this.getEnabled()) {
                this.fwServiceStarted();
            } else {
                this.fwServiceStopped();
            }
        } else if (this.isRunning() && property.equals(tagRuleIndexEnabled)) {
            this.doClearTagRuleIndex();
        } else if (property.equals(indexedTags)) {
            this.updateIndexedTags();
        }
    }

    private void fwServiceStarted() {
        if (this.isOperational()) {
            BComponentSpace space = this.getComponentSpace();
            if (space != null) {
                if (this.getEnabled()) {
                    space.setTagDictionaryService((TagDictionaryService)this);
                    smartTagDictionaryCache = new ConcurrentHashMap<String, Optional<SmartTagDictionary>>();
                    this.initTagRuleIndexTypeSubscriber(space);
                    this.initNeqlizeOptionsTypeSubscriber(space);
                } else {
                    space.removeTagDictionaryService((TagDictionaryService)this);
                    smartTagDictionaryCache = null;
                }
            }
            if (this.worker == null) {
                this.worker = new Worker((Worker.ITodo)this.taskQueue);
                this.worker.start("TagDictionary:ServiceWorker");
            }
        }
        if (this.getSchemaVersion() < 2) {
            this.removeTagGroupMonitor();
            this.setSchemaVersion(2);
        }
    }

    private void removeTagGroupMonitor() {
        BTagGroupMonitor[] tagGroupMonitors;
        for (BTagGroupMonitor tagGroupMonitor : tagGroupMonitors = (BTagGroupMonitor[])CompUtil.getDescendants((BComponent)this, BTagGroupMonitor.class)) {
            this.remove((BComplex)tagGroupMonitor);
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.rebuildPlainSmartDictionaryList();
        if (!this.disableTagIndexing) {
            this.updateIndexedTags();
            this.setFlags((Slot)invalidateAllTagIndexes, this.getFlags((Slot)invalidateAllTagIndexes) & 0xFFFFFFFB);
            this.setFlags((Slot)invalidateSingleTagIndex, this.getFlags((Slot)invalidateSingleTagIndex) & 0xFFFFFFFB);
        } else {
            this.setFlags((Slot)invalidateAllTagIndexes, this.getFlags((Slot)invalidateAllTagIndexes) | 4);
            this.setFlags((Slot)invalidateSingleTagIndex, this.getFlags((Slot)invalidateSingleTagIndex) | 4);
            String message = this.getLexicon().getText("tagIndexing.disabled.message", new Object[]{DISABLE_TAG_INDEXING_SYS_PROP});
            if (this.get("TagIndexingDisabled") == null) {
                this.add("TagIndexingDisabled", (BValue)BString.make((String)message), 3);
            }
            logger.info(message);
        }
    }

    private void fwStarted() {
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    private void fwServiceStopped() {
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.removeTagDictionaryService((TagDictionaryService)this);
            smartTagDictionaryCache = null;
            this.doClearTagRuleIndex();
            this.removeTagRuleIndexTypeSubscriber();
            this.removeNeqlizeOptionsTypeSubscriber();
            this.impliedTagIndex.invalidateAllIds();
        }
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "tags");
    }

    protected void enabled() {
        this.fwServiceStarted();
    }

    protected void disabled() {
        this.fwServiceStopped();
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 16: {
                this.fwServiceStopped();
                break;
            }
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public String getDefaultNamespace() {
        String ns = this.getDefaultNamespaceId();
        return ns.isEmpty() ? null : ns;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        if (defaultNamespace == null) {
            this.setDefaultNamespaceId("");
        } else {
            this.setDefaultNamespaceId(defaultNamespace);
        }
    }

    public Collection<TagDictionary> getTagDictionaries() {
        ArrayList<TagDictionary> result = new ArrayList<TagDictionary>();
        SlotCursor c = this.getProperties();
        while (c.next(TagDictionary.class)) {
            TagDictionary dictionary = (TagDictionary)c.get();
            if (dictionary instanceof BIStatus) {
                if (!((BIStatus)dictionary).getStatus().isValid()) continue;
                result.add(dictionary);
                continue;
            }
            result.add(dictionary);
        }
        return result;
    }

    public Optional<TagDictionary> getTagDictionary(String namespace) {
        SlotCursor c = this.getProperties();
        while (c.next(TagDictionary.class)) {
            TagDictionary dictionary = (TagDictionary)c.get();
            if (!dictionary.getNamespace().equals(namespace)) continue;
            if (dictionary instanceof BIStatus) {
                if (!((BIStatus)dictionary).getStatus().isValid()) continue;
                return Optional.of(dictionary);
            }
            return Optional.of(dictionary);
        }
        return Optional.empty();
    }

    public Collection<SmartTagDictionary> getSmartTagDictionaries() {
        ArrayList<SmartTagDictionary> result = new ArrayList<SmartTagDictionary>();
        SlotCursor c = this.getProperties();
        while (c.next(SmartTagDictionary.class)) {
            SmartTagDictionary dictionary = (SmartTagDictionary)c.get();
            if (dictionary instanceof BIStatus) {
                if (!((BIStatus)dictionary).getStatus().isValid()) continue;
                result.add(dictionary);
                continue;
            }
            result.add(dictionary);
        }
        return result;
    }

    public Optional<SmartTagDictionary> getSmartTagDictionary(String namespace) {
        if (smartTagDictionaryCache == null) {
            return this.getSmartTagDictionary2(namespace);
        }
        Optional<SmartTagDictionary> smartDictionary = smartTagDictionaryCache.getOrDefault(namespace, Optional.empty());
        if (!smartDictionary.isPresent()) {
            return smartDictionary;
        }
        SmartTagDictionary d = smartDictionary.get();
        if (!(d instanceof BIStatus) || ((BIStatus)d).getStatus().isValid()) {
            return smartDictionary;
        }
        return Optional.empty();
    }

    Map<String, Optional<SmartTagDictionary>> getSmartTagDictionaryCache() {
        return smartTagDictionaryCache;
    }

    private Optional<SmartTagDictionary> getSmartTagDictionary2(String namespace) {
        SlotCursor c = this.getProperties();
        while (c.next(SmartTagDictionary.class)) {
            SmartTagDictionary d = (SmartTagDictionary)c.get();
            if (!d.getNamespace().equals(namespace)) continue;
            if (d instanceof BIStatus) {
                if (!((BIStatus)d).getStatus().isValid()) continue;
                return Optional.of(d);
            }
            return Optional.of(d);
        }
        return Optional.empty();
    }

    public Optional<Tag> getImpliedTag(Id id, Entity entity) {
        Optional<TagInfo> tagInfo;
        boolean indexingTag;
        boolean bl = indexingTag = this.impliedTagIndex.isIndexed(id) && !this.disableTagIndexing;
        if (indexingTag && (tagInfo = this.impliedTagIndex.getTagInfo(id, entity)) != null) {
            return BTagDictionaryService.mapTagInfoToTag(tagInfo, entity);
        }
        tagInfo = this.searchSmartDictionariesForTag(id, entity);
        if (!tagInfo.isPresent()) {
            tagInfo = BTagDictionaryService.searchDirectTagGroups(id, entity);
        }
        if (indexingTag) {
            this.impliedTagIndex.setTagInfo(id, entity, tagInfo);
        }
        return BTagDictionaryService.mapTagInfoToTag(tagInfo, entity);
    }

    private static Optional<Tag> mapTagInfoToTag(Optional<TagInfo> tagInfo, Entity entity) {
        Tag tag;
        if (tagInfo.isPresent() && (tag = tagInfo.get().getTag(entity)) != null) {
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    private Optional<TagInfo> searchSmartDictionariesForTag(Id id, Entity entity) {
        if (this.canUseTagRuleIndex()) {
            Set<TagRule> rules = this.getCachedTagRules(id);
            Optional<TagInfo> tagInfo = BTagDictionaryService.testRulesForImpliedTagInfo(id, entity, rules);
            if (tagInfo.isPresent()) {
                return tagInfo;
            }
            return this.searchPlainSmartDictionariesForTag(id, entity);
        }
        return this.searchAllSmartDictionariesForTag(id, entity);
    }

    private boolean canUseTagRuleIndex() {
        return this.getTagRuleIndexEnabled() && this.plainSmartDictionaries.get() != null;
    }

    private Set<TagRule> getCachedTagRules(Id id) {
        Optional<Set<TagRule>> rulesMaybe = this.tagRuleIndex.get(id);
        if (rulesMaybe.isPresent()) {
            return rulesMaybe.get();
        }
        HashSet<TagRule> rules = new HashSet<TagRule>();
        SlotCursor smartDictionaries = this.getProperties();
        while (smartDictionaries.next(BSmartTagDictionary.class)) {
            BSmartTagDictionary smartDictionary = (BSmartTagDictionary)smartDictionaries.get();
            if (!smartDictionary.getEnabled()) continue;
            Iterator<TagRule> dictionaryRules = smartDictionary.getRulesForTagId(id);
            while (dictionaryRules.hasNext()) {
                rules.add(dictionaryRules.next());
            }
        }
        this.tagRuleIndex.put(id, rules);
        return rules;
    }

    private static Optional<TagInfo> testRulesForImpliedTagInfo(Id id, Entity entity, Collection<TagRule> rules) {
        Iterator<TagRule> iterator = rules.iterator();
        while (iterator.hasNext()) {
            TagRule rule = iterator.next();
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, entity)) continue;
            Optional<TagInfo> tagInfo = rule.getTag(id);
            if (tagInfo.isPresent()) {
                return tagInfo;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Id " + id + " not found in tag rule " + rule + " retrieved from the tag rule index or using getRulesForId");
            }
            iterator.remove();
        }
        return Optional.empty();
    }

    private Optional<TagInfo> searchPlainSmartDictionariesForTag(Id id, Entity entity) {
        List<SmartTagDictionary> plainDictionaries = this.plainSmartDictionaries.get();
        for (SmartTagDictionary dictionary : plainDictionaries) {
            Optional tagInfo;
            if (!dictionary.getEnabled() || !(tagInfo = dictionary.getImpliedTagInfo(id, entity)).isPresent()) continue;
            return tagInfo;
        }
        return Optional.empty();
    }

    private Optional<TagInfo> searchAllSmartDictionariesForTag(Id id, Entity entity) {
        SlotCursor smartDictionaries = this.getProperties();
        while (smartDictionaries.next(SmartTagDictionary.class)) {
            Optional tagInfo;
            SmartTagDictionary smartDictionary = (SmartTagDictionary)smartDictionaries.get();
            if (!smartDictionary.getEnabled() || !(tagInfo = smartDictionary.getImpliedTagInfo(id, entity)).isPresent()) continue;
            return tagInfo;
        }
        return Optional.empty();
    }

    private static Optional<TagInfo> searchDirectTagGroups(Id id, Entity entity) {
        for (Relation tagGroupRelation : BTagDictionaryService.getTagGroupRelations(entity)) {
            Optional<TagInfo> tagInfo;
            Entity endpoint = BTagDictionaryService.getTagGroupEndpoint(entity, tagGroupRelation);
            if (!(endpoint instanceof TagGroupInfo) || !(tagInfo = BTagDictionaryService.searchTagGroup(id, (TagGroupInfo)endpoint)).isPresent()) continue;
            return tagInfo;
        }
        return Optional.empty();
    }

    private static Optional<TagInfo> searchTagGroup(Id id, TagGroupInfo tagGroupInfo) {
        if (BTagDictionaryService.isDictionaryValid(tagGroupInfo)) {
            Optional nameTagInfo = tagGroupInfo.getNameTagInfo();
            if (nameTagInfo.isPresent() && ((TagInfo)nameTagInfo.get()).getTagId().equals((Object)id)) {
                return nameTagInfo;
            }
            Iterator groupTagInfos = tagGroupInfo.getTags();
            while (groupTagInfos.hasNext()) {
                TagInfo groupTagInfo = (TagInfo)groupTagInfos.next();
                if (!groupTagInfo.getTagId().equals((Object)id)) continue;
                return Optional.of(groupTagInfo);
            }
        }
        return Optional.empty();
    }

    private static boolean isDictionaryValid(TagGroupInfo tagGroup) {
        Optional dictionary = tagGroup.getDictionary();
        return dictionary.isPresent() && (!(dictionary.get() instanceof BIStatus) || ((BIStatus)dictionary.get()).getStatus().isValid());
    }

    public Collection<Tag> getImpliedTags(Entity entity) {
        LinkedHashSet<Tag> related = new LinkedHashSet<Tag>();
        BTagDictionaryService.getDirectTagGroupImpliedTags(entity, related);
        ArrayList<Tag> result = new ArrayList<Tag>(related);
        for (SmartTagDictionary smartTagDictionary : this.getSmartTagDictionaries()) {
            if (!smartTagDictionary.getEnabled()) continue;
            smartTagDictionary.addAllImpliedTags(entity, result);
        }
        return result;
    }

    private static void getDirectTagGroupImpliedTags(Entity entity, Collection<Tag> tags) {
        for (Relation tagGroupRelation : BTagDictionaryService.getTagGroupRelations(entity)) {
            TagGroupInfo tagGroup;
            Entity endpoint = BTagDictionaryService.getTagGroupEndpoint(entity, tagGroupRelation);
            if (!(endpoint instanceof TagGroupInfo) || !BTagDictionaryService.isDictionaryValid(tagGroup = (TagGroupInfo)endpoint)) continue;
            tagGroup.addAllImpliedTags(entity, tags);
        }
    }

    private static Collection<Relation> getTagGroupRelations(Entity entity) {
        if (entity instanceof BVirtualComponent) {
            return Collections.emptyList();
        }
        try {
            ComponentRelations relations = entity instanceof BComponent ? new ComponentRelations((BComponent)entity) : entity.relations();
            return relations.getAll(BNiagaraTagDictionary.TAG_GROUP_RELATION, 2);
        }
        catch (IllegalStateException | UnresolvedException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not retrieve the tag group relations for entity " + entity.getOrdToEntity().orElse(BOrd.NULL), e);
            }
            return Collections.emptyList();
        }
    }

    private static Entity getTagGroupEndpoint(Entity entity, Relation tagGroupRelation) {
        try {
            return tagGroupRelation.getEndpoint();
        }
        catch (IllegalStateException | UnresolvedException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not resolve the endpoint of the tag group relation " + tagGroupRelation + " for entity " + entity.getOrdToEntity().orElse(BOrd.NULL), e);
            }
            return null;
        }
    }

    public void doClearTagRuleIndex() {
        this.tagRuleIndex.clear();
        this.relationRuleIndex.clear();
    }

    public void doInvalidateAllTagIndexes() throws LocalizableException {
        try {
            logger.fine("Invalidating all tag indexes");
            this.impliedTagIndex.invalidateAllIds();
        }
        catch (Exception e) {
            UUID uuid = UUID.randomUUID();
            logger.warning("Error attempting to invalidate all tag indexes (" + uuid + "): " + e);
            logger.log(Level.FINE, e, uuid::toString);
            throw new LocalizableException(LOGGER_NAME, "invalidateAllTagIndexes.error", new Object[]{uuid});
        }
    }

    public void doInvalidateSingleTagIndex(BString qName) throws LocalizableException {
        Id id;
        try {
            id = TagDictionaryUtil.prependDefaultIfMissingNamespace(qName.getString(), this.getDefaultNamespace());
        }
        catch (Exception e) {
            UUID uuid = UUID.randomUUID();
            logger.warning("Error converting supplied tag id string \"" + qName + "\" to ID (" + uuid + "): " + e);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, uuid.toString(), e);
            }
            throw new LocalizableException(LOGGER_NAME, "invalidateSingleTagIndex.badQNameFormat", new Object[]{qName, e.getLocalizedMessage()});
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Reset the implied tag index for " + id);
            }
            this.impliedTagIndex.invalidateSingleId(id);
        }
        catch (Exception e) {
            UUID uuid = UUID.randomUUID();
            logger.warning("Error attempting to reset the index for tag id " + qName + " (" + uuid + "): " + e);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, uuid.toString(), e);
            }
            throw new LocalizableException(LOGGER_NAME, "invalidateSingleTagIndex.error", new Object[]{qName, uuid});
        }
    }

    private void updateIndexedTags() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.disableTagIndexing) {
            Set<Id> ids = TagDictionaryUtil.parseIndexedTags(this.getIndexedTags(), this);
            this.impliedTagIndex.setIndexedIds(ids);
        }
    }

    public void addImpliedRelations(Id id, Entity source, Collection<Relation> relations) {
        if (this.canUseTagRuleIndex()) {
            Iterator<TagRule> rules = this.getCachedRelationRules(id).iterator();
            while (rules.hasNext()) {
                TagRule rule = rules.next();
                if (!BTagDictionaryService.evaluateRuleOnEntity(rule, source)) continue;
                Iterator<RelationInfo> relationInfos = rule.getRelations(id);
                if (relationInfos.hasNext()) {
                    while (relationInfos.hasNext()) {
                        relationInfos.next().addRelations(source, relations);
                    }
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Id " + id + " not found in tag rule " + rule + " retrieved from the relation rule index or using getRulesForRelationId");
                }
                rules.remove();
            }
            List<SmartTagDictionary> plainDictionaries = this.plainSmartDictionaries.get();
            for (SmartTagDictionary dictionary : plainDictionaries) {
                if (!dictionary.getEnabled()) continue;
                relations.addAll(dictionary.getImpliedRelations(id, source));
            }
        } else {
            SlotCursor smartDictionaries = this.getProperties();
            while (smartDictionaries.next(SmartTagDictionary.class)) {
                SmartTagDictionary smartDictionary = (SmartTagDictionary)smartDictionaries.get();
                if (!smartDictionary.getEnabled()) continue;
                relations.addAll(smartDictionary.getImpliedRelations(id, source));
            }
        }
    }

    public Optional<Relation> getImpliedRelation(Id id, Entity source) {
        if (this.canUseTagRuleIndex()) {
            Set<TagRule> rules = this.getCachedRelationRules(id);
            Optional<Relation> relation = BTagDictionaryService.testRulesForImpliedRelation(id, source, rules);
            if (relation.isPresent()) {
                return relation;
            }
            return this.searchPlainSmartDictionariesForRelation(id, source);
        }
        return this.searchAllSmartDictionariesForRelation(id, source);
    }

    private Set<TagRule> getCachedRelationRules(Id id) {
        Optional<Set<TagRule>> rulesMaybe = this.relationRuleIndex.get(id);
        if (rulesMaybe.isPresent()) {
            return rulesMaybe.get();
        }
        HashSet<TagRule> rules = new HashSet<TagRule>();
        SlotCursor smartDictionaries = this.getProperties();
        while (smartDictionaries.next(BSmartTagDictionary.class)) {
            BSmartTagDictionary smartDictionary = (BSmartTagDictionary)smartDictionaries.get();
            if (!smartDictionary.getEnabled()) continue;
            Iterator<TagRule> dictionaryRules = smartDictionary.getRulesForRelationId(id);
            while (dictionaryRules.hasNext()) {
                rules.add(dictionaryRules.next());
            }
        }
        this.relationRuleIndex.put(id, rules);
        return rules;
    }

    private static Optional<Relation> testRulesForImpliedRelation(Id id, Entity source, Iterable<TagRule> rules) {
        Iterator<TagRule> iterator = rules.iterator();
        while (iterator.hasNext()) {
            TagRule rule = iterator.next();
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, source)) continue;
            Iterator<RelationInfo> relationInfos = rule.getRelations(id);
            if (relationInfos.hasNext()) {
                while (relationInfos.hasNext()) {
                    RelationInfo relationInfo = relationInfos.next();
                    Optional relation = relationInfo.getRelation(source);
                    if (!relation.isPresent()) continue;
                    return relation;
                }
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Id " + id + " not found in tag rule " + rule + " retrieved from the relation rule index or using getRulesForRelationId");
            }
            iterator.remove();
        }
        return Optional.empty();
    }

    private Optional<Relation> searchPlainSmartDictionariesForRelation(Id id, Entity source) {
        List<SmartTagDictionary> plainDictionaries = this.plainSmartDictionaries.get();
        for (SmartTagDictionary dictionary : plainDictionaries) {
            Optional relation;
            if (!dictionary.getEnabled() || !(relation = dictionary.getImpliedRelation(id, source)).isPresent()) continue;
            return relation;
        }
        return Optional.empty();
    }

    private Optional<Relation> searchAllSmartDictionariesForRelation(Id id, Entity source) {
        SlotCursor smartDictionaries = this.getProperties();
        while (smartDictionaries.next(SmartTagDictionary.class)) {
            Optional relation;
            SmartTagDictionary smartDictionary = (SmartTagDictionary)smartDictionaries.get();
            if (!smartDictionary.getEnabled() || !(relation = smartDictionary.getImpliedRelation(id, source)).isPresent()) continue;
            return relation;
        }
        return Optional.empty();
    }

    public void addAllImpliedRelations(Entity source, Collection<Relation> relations) {
        SlotCursor c = this.getProperties();
        while (c.next(SmartTagDictionary.class)) {
            SmartTagDictionary td = (SmartTagDictionary)c.get();
            if (!td.getEnabled()) continue;
            td.addAllImpliedRelations(source, relations);
        }
    }

    static boolean evaluateRuleOnEntity(TagRule rule, Entity entity) {
        try {
            return rule.evaluate(entity);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unexpected error evaluating tag rule: " + rule, logger.isLoggable(Level.FINE) ? t : null);
            return false;
        }
    }

    public Optional<DataPolicy> getDataPolicyForTag(Id tagId) {
        Optional<TagDictionary> optional = this.getTagDictionary(tagId.getDictionary());
        if (optional.isPresent()) {
            Iterator tags = optional.get().getTags();
            while (tags.hasNext()) {
                BTagInfo tagInfo = (BTagInfo)((Object)tags.next());
                if (!tagInfo.getTagId().equals((Object)tagId)) continue;
                return tagInfo.getDataPolicy();
            }
        }
        return Optional.empty();
    }

    public void tagAdded(Entity target, Id tagId) {
    }

    public void tagRemoved(Entity target, Id tagId) {
    }

    @Deprecated
    public void doQuery(BString query) {
        throw new UnsupportedOperationException();
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            Set<Id> idsBeingIndexed;
            int numIndexedTags = 0;
            int numTagRules = 0;
            int numIndexedRelations = 0;
            int numRelationRules = 0;
            if (this.getTagRuleIndexEnabled()) {
                numIndexedTags = this.tagRuleIndex.getIndexedIds().size();
                numTagRules = BTagDictionaryService.getNumIndexedTagRules(this.tagRuleIndex);
                numIndexedRelations = this.relationRuleIndex.getIndexedIds().size();
                numRelationRules = BTagDictionaryService.getNumIndexedTagRules(this.relationRuleIndex);
            }
            out.startProps();
            out.trTitle((Object)"Tag rule index info", 2);
            out.prop((Object)"# of indexed tags", numIndexedTags);
            out.prop((Object)"# of tag rules", numTagRules);
            out.prop((Object)"# of indexed relations", numIndexedRelations);
            out.prop((Object)"# of relation rules", numRelationRules);
            out.endProps();
            out.startProps();
            out.trTitle((Object)"Implied tag index info", 2);
            if (this.disableTagIndexing) {
                out.prop((Object)"tag indexing disabled; system property niagara.tagdictionary.disableTagIndexing is true", (Object)"");
            }
            if (!(idsBeingIndexed = this.impliedTagIndex.getIndexedIds()).isEmpty()) {
                out.prop((Object)"# of tags being indexed", idsBeingIndexed.size());
                out.prop((Object)"tags being indexed", (Object)idsBeingIndexed.toString());
            } else {
                out.prop((Object)"no tags being indexed", (Object)"");
            }
            out.endProps();
            out.startProps();
            out.trTitle((Object)"Service Worker Queue", 2);
            out.prop((Object)"workInQueue", this.taskQueue.size());
            out.endProps();
            if (this.worker != null) {
                this.worker.spy(out);
            }
        }
        super.spy(out);
    }

    private static int getNumIndexedTagRules(TagRuleIndex tagRuleIndex) {
        int numTagRules = 0;
        for (Id id : tagRuleIndex.getIndexedIds()) {
            Optional<Set<TagRule>> tagRules = tagRuleIndex.get(id);
            if (!tagRules.isPresent()) continue;
            numTagRules += tagRules.get().size();
        }
        return numTagRules;
    }

    public Type[] getServiceTypes() {
        return TYPES;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public final void navEvent(NavEvent event) {
        if (event.getId() == 3 && event.getParent() instanceof BComponent) {
            BComponent parent = (BComponent)event.getParent();
            if (parent instanceof BTagDictionaryService) {
                BValue child = parent.get(event.getNewChildName());
                if (child instanceof BTagDictionary) {
                    BTagDictionaryService.fixDictionaryTagGroups((BTagDictionary)child);
                }
            } else if (parent instanceof BTagGroupInfoList && parent.getParent() instanceof BTagDictionary) {
                BValue child = parent.get(event.getNewChildName());
                if (child instanceof BTagGroupInfo) {
                    BTagDictionaryService.fixTagGroup((BTagGroupInfo)child);
                }
            } else {
                String childNewSlotPath = parent.getSlotPath().toString() + '/' + event.getNewChildName();
                SlotPath serviceSlotPath = this.getSlotPath();
                if (serviceSlotPath != null && serviceSlotPath.toString().startsWith(childNewSlotPath)) {
                    for (BTagDictionary dictionary : (BTagDictionary[])this.getChildren(BTagDictionary.class)) {
                        BTagDictionaryService.fixDictionaryTagGroups(dictionary);
                    }
                }
            }
        }
    }

    private static void fixDictionaryTagGroups(BTagDictionary dictionary) {
        for (BTagGroupInfo tagGroup : (BTagGroupInfo[])dictionary.getTagGroupDefinitions().getChildren(BTagGroupInfo.class)) {
            BTagDictionaryService.fixTagGroup(tagGroup);
        }
    }

    private static void fixTagGroup(BTagGroupInfo tagGroup) {
        BOrd slotPathOrd = tagGroup.getSlotPathOrd();
        for (RelationKnob knob : tagGroup.getRelationKnobs()) {
            if (!BTagGroupInfo.isTagGroupRelationKnob(knob)) continue;
            try {
                knob.getRelation().setEndpointOrd(slotPathOrd);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update endpoint ord for tag group " + slotPathOrd, e);
            }
        }
    }

    private void initTagRuleIndexTypeSubscriber(BComponentSpace space) {
        if (this.tagRuleIndexTypeSubscriber == null) {
            logger.fine("TypeSubscriber: initializing type subscriber to keep tag rule index current");
            this.tagRuleIndexTypeSubscriber = new TagRuleIndexTypeSubscriber(space);
            this.tagRuleIndexTypeSubscriber.setMask(BComponentEventMask.make((int[])new int[]{11, 12, 13, 19, 20, 0}));
            this.tagRuleIndexTypeSubscriber.subscribe(new Type[]{TYPE, BSmartTagDictionary.TYPE, BTagInfo.TYPE, BTagInfoList.TYPE, BTagGroupInfo.TYPE, BTagGroupInfoList.TYPE, BRelationInfo.TYPE, BRelationInfoList.TYPE, BTagRule.TYPE, BTagRuleList.TYPE}, null);
        }
    }

    private void removeTagRuleIndexTypeSubscriber() {
        if (this.tagRuleIndexTypeSubscriber != null) {
            logger.fine("TypeSubscriber: removing tag rule index type subscriber");
            this.tagRuleIndexTypeSubscriber.unsubscribeAll();
            this.tagRuleIndexTypeSubscriber = null;
        }
    }

    private void initNeqlizeOptionsTypeSubscriber(BComponentSpace space) {
        if (this.neqlizeOptionsTypeSubscriber == null) {
            neqlLogger.fine("TypeSubscriber: initializing type subscriber to update neqlize default exclusions");
            this.neqlizeOptionsTypeSubscriber = new NeqlizeOptionsTypeSubscriber(space);
            this.neqlizeOptionsTypeSubscriber.setMask(BComponentEventMask.make((int[])new int[]{11, 12, 19, 0}));
            this.neqlizeOptionsTypeSubscriber.subscribe(new Type[]{BTagDictionary.TYPE}, null);
        }
    }

    private void removeNeqlizeOptionsTypeSubscriber() {
        if (this.neqlizeOptionsTypeSubscriber != null) {
            neqlLogger.fine("TypeSubscriber: removing type subscriber to update neqlize default exclusions");
            this.neqlizeOptionsTypeSubscriber.unsubscribeAll();
            this.neqlizeOptionsTypeSubscriber = null;
        }
    }

    <T extends ICoalesceable & Runnable> void addTask(T task) {
        this.taskQueue.enqueue(task);
    }

    public BComponent doTagsToTagGroup() {
        ArrayList<TagDictionaryUtil.ComponentTagGroupChoices> retList = new ArrayList<TagDictionaryUtil.ComponentTagGroupChoices>();
        BComponent root = this.getComponentSpace().getRootComponent();
        List<BComponent> entities = TagDictionaryUtil.getComponents(root);
        List<BTagGroupInfo> tagGroups = TagDictionaryUtil.getTagGroups(this);
        TagDictionaryUtil.listPotentialTagGroupsFromTags(entities, tagGroups, retList);
        BComponent rtnComp = new BComponent();
        if (!retList.isEmpty()) {
            TagDictionaryUtil.ComponentTagGroupChoices.encodeToComponent(retList, rtnComp);
        }
        return rtnComp;
    }

    public BIcon getIcon() {
        return icon;
    }

    private class NeqlizeOptionsTypeSubscriber
    extends TypeSubscriber {
        NeqlizeOptionsTypeSubscriber(BComponentSpace space) {
            super(space);
        }

        public void event(BComponentEvent event) {
            boolean isNeqlizeOptionChanged;
            int id = event.getId();
            Type type = event.getSourceComponent().getType();
            boolean bl = isNeqlizeOptionChanged = id == 0 && (BTagDictionary.neqlizeExcludedTags.equals(event.getSlot()) || BTagDictionary.neqlizeExcludedRelations.equals(event.getSlot()));
            if (type.is(BTagDictionary.TYPE) && (id == 11 || id == 12 || id == 19 || isNeqlizeOptionChanged)) {
                this.updateNeqlizeOptions();
            }
        }

        private void updateNeqlizeOptions() {
            neqlLogger.fine("Regenerating cached default exclusions");
            StringJoiner newExcludedTags = new StringJoiner("\n");
            StringJoiner newExcludedRelations = new StringJoiner("\n");
            SlotCursor c = BTagDictionaryService.this.getProperties();
            while (c.next(BTagDictionary.class)) {
                String dictionaryExcludedRelations;
                BTagDictionary dictionary = (BTagDictionary)c.get();
                String dictionaryExcludedTags = dictionary.getNeqlizeExcludedTags().trim();
                if (!dictionaryExcludedTags.isEmpty()) {
                    newExcludedTags.add(dictionaryExcludedTags);
                }
                if ((dictionaryExcludedRelations = dictionary.getNeqlizeExcludedRelations().trim()).isEmpty()) continue;
                newExcludedRelations.add(dictionaryExcludedRelations);
            }
            BNeqlizeOptions options = BTagDictionaryService.this.getNeqlizeOptions();
            options.setDefaultExcludedTags(newExcludedTags.toString());
            options.setDefaultExcludedRelations(newExcludedRelations.toString());
        }
    }

    private class TagRuleIndexTypeSubscriber
    extends TypeSubscriber {
        TagRuleIndexTypeSubscriber(BComponentSpace space) {
            super(space);
        }

        public void event(BComponentEvent event) {
            if (!BTagDictionaryService.this.getTagRuleIndexEnabled()) {
                return;
            }
            int id = event.getId();
            Type type = event.getSourceComponent().getType();
            if (id == 13 ? type.is(TYPE) || type.is(BSmartTagDictionary.TYPE) || type.is(BTagInfoList.TYPE) || type.is(BTagGroupInfoList.TYPE) || type.is(BRelationInfoList.TYPE) || type.is(BTagRule.TYPE) || type.is(BTagRuleList.TYPE) : (id == 0 ? type.is(BTagInfo.TYPE) || type.is(BTagInfoList.TYPE) || type.is(BTagGroupInfo.TYPE) || type.is(BTagGroupInfoList.TYPE) || type.is(BRelationInfo.TYPE) || type.is(BRelationInfoList.TYPE) || type.is(BTagRule.TYPE) || type.is(BTagRuleList.TYPE) : !(id != 19 && id != 11 || !type.is(BTagInfo.TYPE) && !type.is(BTagInfoList.TYPE) && !type.is(BTagGroupInfo.TYPE) && !type.is(BTagGroupInfoList.TYPE) && !type.is(BRelationInfo.TYPE) && !type.is(BRelationInfoList.TYPE) || this.hasTagRuleAncestor(event.getSourceComponent())))) {
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("TypeSubscriber: clearing tag rule index on event " + event + " for type " + type);
            }
            BTagDictionaryService.this.clearTagRuleIndex();
        }

        private boolean hasTagRuleAncestor(BComponent comp) {
            for (BComponent parent = comp; parent != null; parent = (BComponent)parent.getParent()) {
                if (!(parent instanceof TagRule)) continue;
                return true;
            }
            return false;
        }
    }
}

