/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.collection.FilteredIterator;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.SmartTagDictionary;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.tagdictionary.TagRule;

@NiagaraType
@NiagaraProperty(name="tagRules", type="BTagRuleList", defaultValue="new BTagRuleList()")
public class BSmartTagDictionary
extends BTagDictionary
implements SmartTagDictionary {
    @Generated
    public static final Property tagRules = BSmartTagDictionary.newProperty((int)0, (BValue)new BTagRuleList(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSmartTagDictionary.class);

    @Generated
    public BTagRuleList getTagRules() {
        return (BTagRuleList)this.get(tagRules);
    }

    @Generated
    public void setTagRules(BTagRuleList v) {
        this.set(tagRules, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSmartTagDictionary() {
    }

    public BSmartTagDictionary(String namespace) {
        super(namespace);
    }

    public Iterator<TagRule> getRulesForTagId(Id id) {
        Predicate<TagRule> test = rule -> rule.containsTagId(id);
        return new FilteredIterator(test, SlotCursorIterator.iterator((SlotCursor)this.getTagRules().getProperties(), TagRule.class));
    }

    public Iterator<TagRule> getRulesForRelationId(Id id) {
        Predicate<TagRule> test = rule -> rule.containsRelationId(id);
        return new FilteredIterator(test, SlotCursorIterator.iterator((SlotCursor)this.getTagRules().getProperties(), TagRule.class));
    }

    public Optional<Tag> getImpliedTag(Id id, Entity entity) {
        return this.getImpliedTagInfo(id, entity).map(tagInfo -> tagInfo.getTag(entity));
    }

    public Optional<TagInfo> getImpliedTagInfo(Id id, Entity entity) {
        if (this.getStatus().isValid()) {
            for (TagRule rule : this.getTagRules()) {
                Optional<TagInfo> tagInfo = rule.getTag(id);
                if (!tagInfo.isPresent() || !BTagDictionaryService.evaluateRuleOnEntity(rule, entity)) continue;
                return tagInfo;
            }
        }
        return Optional.empty();
    }

    public void addAllImpliedTags(Entity entity, Collection<Tag> tags) {
        SlotCursor c = this.getTagRules().getProperties();
        while (c.next(TagRule.class)) {
            TagRule rule = (TagRule)c.get();
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, entity)) continue;
            for (TagInfo tagInfo : rule.getTags()) {
                Tag tag = tagInfo.getTag(entity);
                if (tag == null) continue;
                tags.add(tag);
            }
            for (TagGroupInfo tagGroupInfo : rule.getTagGroups()) {
                tagGroupInfo.addAllImpliedTags(entity, tags);
            }
        }
    }

    public Optional<Relation> getImpliedRelation(Id id, Entity source) {
        Iterator<TagRule> rules = this.getRulesForRelationId(id);
        while (rules.hasNext()) {
            Optional rel;
            Iterator<RelationInfo> relations;
            TagRule rule = rules.next();
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, source) || !(relations = rule.getRelations(id)).hasNext() || !(rel = relations.next().getRelation(source)).isPresent()) continue;
            return rel;
        }
        return Optional.empty();
    }

    public void addAllImpliedRelations(Entity source, Collection<Relation> relations) {
        for (TagRule rule : this.getTagRules()) {
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, source)) continue;
            for (RelationInfo rel : rule.getRelations()) {
                rel.addRelations(source, relations);
            }
            for (TagGroupInfo tagGroupInfo : rule.getTagGroups()) {
                if (!(tagGroupInfo instanceof Entity)) continue;
                relations.add((Relation)new BasicRelation(BNiagaraTagDictionary.TAG_GROUP_RELATION, (Entity)tagGroupInfo, false));
            }
        }
    }

    public void addImpliedRelations(Id id, Entity source, Collection<Relation> relations) {
        Iterator<TagRule> rules = this.getRulesForRelationId(id);
        while (rules.hasNext()) {
            TagRule rule = rules.next();
            if (!BTagDictionaryService.evaluateRuleOnEntity(rule, source)) continue;
            Iterator<RelationInfo> rr = rule.getRelations(id);
            while (rr.hasNext()) {
                rr.next().addRelations(source, relations);
            }
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (this.isRunning()) {
            Map<String, Optional<SmartTagDictionary>> cache = null;
            TagDictionaryService tagDictionaryService = this.getTagDictionaryService();
            if (tagDictionaryService instanceof BTagDictionaryService) {
                cache = ((BTagDictionaryService)tagDictionaryService).getSmartTagDictionaryCache();
            }
            if (cache != null) {
                switch (x) {
                    case 11: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Adding SmartTagDictionary " + this.toString() + " (" + this.getNamespace() + ") to cache");
                        }
                        cache.put(this.getNamespace(), Optional.of(this));
                        break;
                    }
                    case 12: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(String.format("Removing SmartTagDictionary %s (%s) from cache", this.toString(), this.getNamespaceFromCache(cache)));
                        }
                        cache.remove(this.getNamespace());
                        break;
                    }
                    case 2: {
                        if (!this.isRunning() || !((Property)a).getName().equals("namespace")) break;
                        String oldNs = this.getNamespaceFromCache(cache);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Updating SmartTagDictionary " + this.toString() + " (" + oldNs + ") to namespace " + this.getNamespace());
                        }
                        cache.remove(oldNs);
                        cache.put(this.getNamespace(), Optional.of(this));
                    }
                }
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private String getNamespaceFromCache(Map<String, Optional<SmartTagDictionary>> cache) {
        Objects.requireNonNull(cache, "cache");
        Optional<Map.Entry> entry = cache.entrySet().stream().filter(e -> ((Optional)e.getValue()).get() == this).findFirst();
        return entry.map(Map.Entry::getKey).orElse("");
    }

    @Override
    public void encodeToJson(JSONWriter writer) {
        super.encodeToJson(writer);
        writer.key("rules");
        this.getTagRules().encodeToJson(writer);
    }

    @Override
    public void decodeFromJson(JSONObject dictionaryJson) {
        super.decodeFromJson(dictionaryJson);
        BTagRuleList tagRuleList = new BTagRuleList();
        tagRuleList.decodeFromJson(dictionaryJson.getJSONArray("rules"));
        this.setTagRules(tagRuleList);
    }
}

