/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.util.ImportUtil;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BMarker;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BTagInfo;

@NiagaraType
@NiagaraProperty(name="defValue", type="BValue", defaultValue="BMarker.MARKER")
public class BSimpleTagInfo
extends BTagInfo {
    @Generated
    public static final Property defValue = BSimpleTagInfo.newProperty((int)0, (BValue)BMarker.MARKER, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSimpleTagInfo.class);

    @Generated
    public BValue getDefValue() {
        return this.get(defValue);
    }

    @Generated
    public void setDefValue(BValue v) {
        this.set(defValue, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSimpleTagInfo() {
    }

    public BSimpleTagInfo(BIDataValue defaultValue) {
        this.setDefValue((BValue)defaultValue);
    }

    public void setDefaultValue(BIDataValue value) {
        this.setDefValue((BValue)value);
    }

    public BIDataValue getDefaultValue() {
        BValue def = this.getDefValue();
        if (def instanceof BIDataValue) {
            return (BIDataValue)def;
        }
        throw new IllegalStateException("defValue is not a valid data value.");
    }

    @Override
    public void encodeToJson(JSONWriter writer) {
        if (!this.getDefaultValue().getType().is(BMarker.TYPE)) {
            BIDataValue tagValue = this.getDefaultValue();
            writer.key("valueType").value((Object)tagValue.getType());
            try {
                writer.key("default").value((Object)tagValue.encodeToString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.encodeToJson(writer);
    }

    @Override
    public void decodeFromJson(JSONObject tagJson) {
        super.decodeFromJson(tagJson);
        String valueTypeString = tagJson.optString("valueType", "");
        if (!valueTypeString.isEmpty()) {
            TypeInfo valueType = ImportUtil.decodeType(valueTypeString, BIDataValue.TYPE);
            try {
                BIDataValue dataValue = (BIDataValue)valueType.getInstance();
                BValue value = (BValue)dataValue.decodeFromString(tagJson.getString("default"));
                this.setDefValue(value);
            }
            catch (IOException e) {
                throw new LocalizableRuntimeException("tagdictionary", "decodeJson.defaultValueError", new Object[]{tagJson.optString("name", "")});
            }
        }
    }

    public String toString(Context cx) {
        return this.getDefaultValue().getType().getTypeName();
    }
}

