/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.util.ExportUtil;
import com.tridium.tagdictionary.util.ImportUtil;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tagdictionary.BInfoList;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BTagDictionary;

@NiagaraType
public class BRelationInfoList
extends BInfoList
implements Iterable<RelationInfo> {
    @Generated
    public static final Type TYPE = Sys.loadType(BRelationInfoList.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!(value instanceof RelationInfo)) {
            TagDictionaryUtil.handleIllegalChild(this, value, context);
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    public Optional<TagDictionary> getDictionary() {
        return BTagDictionary.getParentDictionary(this);
    }

    public boolean containsRelationId(Id id) {
        return this.getRelation(id).isPresent();
    }

    public Optional<RelationInfo> getRelation(Id id) {
        for (BRelationInfo relationInfo : (BRelationInfo[])this.getChildren(BRelationInfo.class)) {
            if (!relationInfo.getRelationId().equals((Object)id)) continue;
            return Optional.of(relationInfo);
        }
        return Optional.empty();
    }

    public void renamed(Property property, String oldName, Context context) {
        BValue value = this.get(property);
        if (value instanceof BRelationInfo) {
            ((BRelationInfo)value).relationRenamed();
        }
    }

    public void encodeToJson(JSONWriter writer) {
        writer.array();
        for (RelationInfo relation : this) {
            BRelationInfo relationInfo = (BRelationInfo)relation;
            writer.object();
            ExportUtil.encodeName(relationInfo.getName(), writer);
            if (!relationInfo.getType().equals(BRelationInfo.TYPE)) {
                writer.key("type").value((Object)relationInfo.getType());
            }
            relationInfo.encodeToJson(writer);
            writer.endObject();
        }
        writer.endArray();
    }

    public void decodeFromJson(JSONArray relationsJson) {
        for (Object o : relationsJson) {
            JSONObject relationJson = (JSONObject)o;
            TypeInfo type = BRelationInfo.TYPE.getTypeInfo();
            if (relationJson.has("type")) {
                type = ImportUtil.decodeType(relationJson.getString("type"), BRelationInfo.TYPE);
            }
            BRelationInfo relationInfo = (BRelationInfo)type.getInstance();
            relationInfo.decodeFromJson(relationJson);
            String namespace = relationJson.optString("namespace", "");
            if (!namespace.isEmpty()) {
                this.add(SlotPath.escape((String)(namespace + ':' + relationJson.getString("name"))), (BValue)relationInfo);
                continue;
            }
            this.add(SlotPath.escape((String)relationJson.getString("name")), (BValue)relationInfo);
        }
    }

    @Override
    public Iterator<RelationInfo> iterator() {
        return SlotCursorIterator.iterator((SlotCursor)this.getProperties(), RelationInfo.class);
    }
}

