/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.neqlize;

import com.tridium.tagdictionary.neqlize.FilteredTagsMap;
import com.tridium.tagdictionary.neqlize.TagsCandidateIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.tag.Tag;

public final class TagSetSearch {
    private final Collection<BComponent> searchSet;
    private final FilteredTagsMap filteredTagsMap;
    private static final Logger logger = Logger.getLogger("tagdictionary");

    public TagSetSearch(Collection<BComponent> searchSet, FilteredTagsMap filteredTagsMap) {
        this.searchSet = searchSet;
        this.filteredTagsMap = filteredTagsMap;
    }

    public Set<Tag> findIdentifyingTags(BComponent target) {
        if (target == null || this.searchSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.searchSet.size() == 1 && this.searchSet.contains(target)) {
            return Collections.emptySet();
        }
        List<Tag> targetTags = this.filteredTagsMap.getFilteredTags(target);
        if (targetTags.isEmpty()) {
            return Collections.emptySet();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" filtered tags on target = " + TagSetSearch.tagSetToString(targetTags));
        }
        TagsCandidateIterator candidates = new TagsCandidateIterator(targetTags);
        while (candidates.hasNext()) {
            Set candidate = (Set)candidates.next();
            if (!this.isIdentifying(target, candidate)) continue;
            return candidate;
        }
        return Collections.emptySet();
    }

    private boolean isIdentifying(BComponent target, Collection<Tag> candidate) {
        for (BComponent member : this.searchSet) {
            List<Tag> peerTags;
            if (member == target || !(peerTags = this.filteredTagsMap.getFilteredTags(member)).containsAll(candidate)) continue;
            return false;
        }
        return true;
    }

    private static String tagSetToString(Iterable<Tag> tags) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (Tag tag : tags) {
            joiner.add(tag.getValue() instanceof BMarker ? tag.getId().toString() : tag.getId() + " - " + tag.getValue());
        }
        return joiner.toString();
    }

    public boolean isInSearchSet(BComponent target) {
        return this.searchSet.contains(target);
    }
}

