/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.condition;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

@NiagaraType
@NiagaraProperty(name="relationId", type="String", defaultValue="")
public class BHasRelation
extends BBooleanFilter {
    @Generated
    public static final Property relationId = BHasRelation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHasRelation.class);
    private Id id;
    private boolean parsed;

    @Generated
    public String getRelationId() {
        return this.getString(relationId);
    }

    @Generated
    public void setRelationId(String v) {
        this.setString(relationId, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHasRelation() {
    }

    public BHasRelation(Id relationId, String filter) {
        super(filter);
        this.setRelationId(relationId.getQName());
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (cx != Context.decoding && prop.equals(relationId)) {
            this.parsed = false;
            this.id = null;
        }
    }

    @Override
    public boolean test(Predicate<Entity> predicate, Entity entity) {
        Id id = this.getId();
        if (id == null) {
            return false;
        }
        HashSet<Entity> visited = new HashSet<Entity>();
        Entity obj = entity;
        while (obj != null) {
            if (predicate.test(obj)) {
                return true;
            }
            Optional rel = obj.relations().get(id);
            if (rel.isPresent()) {
                obj = ((Relation)rel.get()).getEndpoint();
                if (visited.contains(obj)) {
                    return false;
                }
                visited.add(obj);
                continue;
            }
            obj = null;
        }
        return false;
    }

    public Id getId() {
        if (!this.parsed || this.id == null) {
            try {
                this.parsed = true;
                this.id = Id.newId((String)this.getRelationId());
            }
            catch (Exception ex) {
                this.id = null;
            }
        }
        return this.id;
    }

    @Override
    public void encodeToJson(JSONWriter writer) {
        writer.key(relationId.getName()).value((Object)this.getRelationId());
        writer.key("filter").value((Object)this.getFilter());
    }

    @Override
    public void decodeFromJson(JSONObject conditionJson) {
        super.decodeFromJson(conditionJson);
        this.setRelationId(conditionJson.getString(relationId.getName()));
    }
}

