/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary;

import com.tridium.sys.service.ServiceManager;
import com.tridium.tagdictionary.util.ImportUtil;
import java.util.ArrayList;
import javax.baja.gx.BColor;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BTagDictionary;

@NiagaraType
public class BTagDictionaryImportJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BTagDictionaryImportJob.class);
    private final BOrd fileOrd;
    private final BTagDictionary dict;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTagDictionaryImportJob() {
        this.fileOrd = BOrd.NULL;
        this.dict = null;
    }

    public BTagDictionaryImportJob(BTagDictionary dictionary, BOrd file) {
        this.fileOrd = file;
        this.dict = dictionary;
    }

    public BOrd submit(Context cx) {
        BComponent jobService = (BComponent)BJobService.getService();
        BJob[] jobs = (BJob[])jobService.getChildren(BTagDictionaryImportJob.class);
        if (jobs.length > 0) {
            int disposeIndex = jobs.length - ServiceManager.jobMaxCountPerType;
            for (int i = jobs.length - 1; i >= 0; --i) {
                BTagDictionaryImportJob job = (BTagDictionaryImportJob)jobs[i];
                if (job.isAlive() && job.dict.getName().equals(this.dict.getName())) {
                    throw new LocalizableRuntimeException("tagdictionary", "tagDictionaryImportJob.jobAlreadyRunning");
                }
                if (i > disposeIndex) continue;
                jobs[i].dispose();
            }
        }
        return super.submit(cx);
    }

    public void run(Context cx) throws Exception {
        this.log().start("tagdictionary", "tagDictionaryImportJob.start", new String[]{this.dict.getName(), this.fileOrd.toString()});
        ArrayList<ImportUtil.ResultInfo> results = ImportUtil.ImportTagDictionary(this.dict, this.fileOrd);
        boolean hasFailed = false;
        for (ImportUtil.ResultInfo result : results) {
            if (result.getForeground().equals((Object)BColor.red)) {
                hasFailed = true;
                this.log().failed(result.getInfo());
                continue;
            }
            this.log().message(result.getInfo());
        }
        if (hasFailed) {
            throw new LocalizableRuntimeException("tagdictionary", "tagDictionaryImportJob.failed");
        }
    }
}

