/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

public class EnumRadioGroup
extends ToggleCommandGroup<EnumCommand> {
    private BRadioButton[] buttons;
    private BEnum enumValue;
    private Array<EnumRadioGroupListener> listeners = new Array(EnumRadioGroupListener.class);

    public EnumRadioGroup(BWidget owner, BEnum initialValue, Context cx) {
        this(owner, initialValue.getRange(), cx);
        this.setValue(initialValue);
    }

    public EnumRadioGroup(BWidget owner, BEnumRange range, Context cx) {
        int[] ordinals = range.getOrdinals();
        String[] labels = new String[ordinals.length];
        BEnum[] values = new BEnum[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            values[i] = range.get(ordinals[i]);
            labels[i] = values[i].getDisplayTag(cx);
        }
        this.init(owner, labels, values);
    }

    public EnumRadioGroup(BWidget owner, String[] labels, BEnum[] enumValues, BEnum initialValue) {
        this(owner, labels, enumValues);
        this.setValue(initialValue);
    }

    public EnumRadioGroup(BWidget owner, BEnum[] enumValues, BEnum initialValue, Context cx) {
        this(owner, enumValues, cx);
        this.setValue(initialValue);
    }

    public EnumRadioGroup(BWidget owner, BEnum[] enumValues, Context cx) {
        String[] labels = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            labels[i] = enumValues[i].getDisplayTag(cx);
        }
        this.init(owner, labels, enumValues);
    }

    public EnumRadioGroup(BWidget owner, String[] labels, BEnum[] enumValues) {
        this.init(owner, labels, enumValues);
    }

    private void init(BWidget owner, String[] labels, BEnum[] enumValues) {
        this.buttons = new BRadioButton[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            EnumCommand cmd = new EnumCommand(owner, labels[i], enumValues[i]);
            this.buttons[i] = new BRadioButton((ToggleCommand)cmd, true, false);
            this.add(cmd);
        }
    }

    public void linkAction(BComponent target, Slot targetSlot) {
        for (BRadioButton button : this.buttons) {
            target.linkTo(null, (BComponent)button, (Slot)BRadioButton.actionPerformed, targetSlot);
        }
    }

    public BEnum getValue() {
        return this.enumValue;
    }

    public void setValue(BEnum newValue) {
        BRadioButton rb = (BRadioButton)this.getWidget(newValue);
        if (rb != null) {
            rb.setSelected(true);
        }
    }

    public BWidget[] getWidgets() {
        return this.buttons;
    }

    public BWidget getWidget(BEnum value) {
        for (BRadioButton button : this.buttons) {
            if (!((EnumCommand)button.getCommand()).getEnumValue().equals((Object)value)) continue;
            return button;
        }
        return null;
    }

    public void setEnabled(BEnum value, boolean enabled) {
        BRadioButton rb = (BRadioButton)this.getWidget(value);
        if (rb != null) {
            rb.setEnabled(enabled);
        }
    }

    public boolean isEnabled(BEnum value) {
        BRadioButton rb = (BRadioButton)this.getWidget(value);
        return rb != null && rb.isEnabled();
    }

    public void addListener(EnumRadioGroupListener value) {
        this.listeners.add((Object)value);
    }

    public void removeListener(EnumRadioGroupListener value) {
        this.listeners.remove((Object)value);
    }

    protected void selected(EnumCommand command) {
        this.enumValue = command.getEnumValue();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((EnumRadioGroupListener)this.listeners.get(i)).enumSelected(this.enumValue);
        }
    }

    public static class EnumCommand
    extends ToggleCommand {
        private BEnum enumValue;

        public EnumCommand(BWidget pOwner, String pLabel, BEnum pEnumValue) {
            super(pOwner, pLabel);
            this.enumValue = pEnumValue;
        }

        public BEnum getEnumValue() {
            return this.enumValue;
        }
    }

    public static interface EnumRadioGroupListener {
        public void enumSelected(BEnum var1);
    }
}

